/*
** Copyright 1998 - 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

#include	"courier.h"
#include	"esmtpiov.h"
#include	"authlib/auth.h"
#include	"authlib/authmod.h"
#include	"authlib/authsasl.h"

#include	"libexecdir.h"

static const char rcsid[]="$Id: authstart.c,v 1.6 2000/07/25 12:43:47 mrsam Exp $";

static char *getresp(const char *s)
{
char	*p;

	addiovec("334 ", 4);
	addiovec(s, strlen(s));
	addiovec("\r\n", 2);
	iovflush();

	p=iovreadline();
	if (!p)	exit(0);
	if ((p=strdup(p)) == 0)
	{
		perror("malloc");
		exit(0);
	}
	return (p);
}

/*
** We're a root setuid proggie.  Validate args as follows:
**
** 1)  all arguments must exist in authmodulelist.
** 2)  Append authend to the end of the arg list.
*/

static void validate_args(int argc, char **argv, int *new_argc,
	char ***new_argv)
{
int	i;
char	*filename;
char	*authmodules;
char	*authmodcpy;

	filename=config_localfilename("authmodulelist");
	authmodules=config_read1l(filename);
	free(filename);

	if (!authmodules)
	{
		fprintf(stderr, "%s: cannot read authmodulelist.\n",
			argv[0]);
		exit(0);
	}

	if (argc <= 0)	exit(0);

	*new_argv=malloc((argc+2)* sizeof(char *));
	if (!*new_argv || (authmodcpy=strdup(authmodules)) == 0)
	{
		perror("malloc");
		exit (0);
	}
	*new_argc= argc+1;
	(*new_argv)[0]=argv[0];
	for (i=1; i<argc; i++)
	{
	char	*p;

		strcpy(authmodcpy, authmodules);
		for (p=strtok(authmodcpy, " "); p; p=strtok(0, " "))
			if (strcmp(p, argv[i]) == 0)
				break;
		if (!p)
		{
			if (argv[i][0] != '/')
				/* After an error, authstart gets execed
				** again, but this time the args are expanded,
				** and this is where we usually trap it.
				*/
				fprintf(stderr, "%s: invalid module %s\n",
					argv[0], argv[i]);
			exit(0);
		}

		p=malloc(sizeof(LIBEXECDIR "/authlib/")+strlen(argv[i]));
		if (!p)
		{
			perror("malloc");
			exit(0);
		}
		strcat(strcpy(p, LIBEXECDIR "/authlib/"), argv[i]);
		(*new_argv)[i]=p;
	}
	(*new_argv)[i]=LIBEXECDIR "/courier/modules/esmtp/authend";
	(*new_argv)[i+1]=0;
}

int main(int argc, char **argv)
{
const	char *authmethod=getenv("ESMTPAUTHMETHOD");
const	char *initreply=getenv("ESMTPINITREPLY");
char	methodbuf[64];
char	*authtype, *authdata;

char	**new_argv;
int	new_argc;

	validate_args(argc, argv, &new_argc, &new_argv);

	if (authmoduser(new_argc, new_argv, 0, 5) == 0 || !authmethod)
		exit(0);

	methodbuf[0]=0;
	strncat(methodbuf, authmethod, 60);

	if (authsasl(methodbuf, initreply, getresp, &authtype, &authdata))
		exit(0);
	close(1);
	if (dup(3) != 1)	exit(0);
	close(3);
	authmod(new_argc-1, new_argv+1, "esmtp", authtype, authdata);
	exit(0);
}
