// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_PERMISSIONS_PERMISSION_AUDITING_SERVICE_FACTORY_H_
#define CHROME_BROWSER_PERMISSIONS_PERMISSION_AUDITING_SERVICE_FACTORY_H_

#include "components/keyed_service/content/browser_context_keyed_service_factory.h"

class Profile;

namespace base {
template <typename T>
struct DefaultSingletonTraits;
}

namespace permissions {
class PermissionAuditingService;
}

class PermissionAuditingServiceFactory
    : public BrowserContextKeyedServiceFactory {
 public:
  static PermissionAuditingServiceFactory* GetInstance();

  // Creates a permission auditing service for the given `profile`. Will return
  // nullptr in case if |profile| is off-the-record or if `kPermissionAuditing`
  // feature is disabled.
  static permissions::PermissionAuditingService* GetForProfile(
      Profile* profile);

  PermissionAuditingServiceFactory(const PermissionAuditingServiceFactory&) =
      delete;
  PermissionAuditingServiceFactory& operator=(
      const PermissionAuditingServiceFactory&) = delete;

  PermissionAuditingServiceFactory(PermissionAuditingServiceFactory&&) = delete;
  PermissionAuditingServiceFactory& operator=(
      PermissionAuditingServiceFactory&&) = delete;

 private:
  friend struct base::DefaultSingletonTraits<PermissionAuditingServiceFactory>;

  PermissionAuditingServiceFactory();
  ~PermissionAuditingServiceFactory() override;

  // BrowserContextKeyedServiceFactory:
  bool ServiceIsCreatedWithBrowserContext() const override;

  KeyedService* BuildServiceInstanceFor(
      content::BrowserContext* context) const override;
};

#endif  // CHROME_BROWSER_PERMISSIONS_PERMISSION_AUDITING_SERVICE_FACTORY_H_
