// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_EXTENSIONS_API_PASSWORDS_PRIVATE_PASSWORDS_PRIVATE_UTILS_H_
#define CHROME_BROWSER_EXTENSIONS_API_PASSWORDS_PRIVATE_PASSWORDS_PRIVATE_UTILS_H_

#include <map>
#include <string>

#include "base/containers/flat_map.h"
#include "chrome/common/extensions/api/passwords_private.h"

namespace autofill {
struct PasswordForm;
}

namespace extensions {

// Obtains a collection of URLs from the passed in form. This includes an origin
// URL used for internal logic, a human friendly string shown to the user as
// well as a URL that is linked to.
api::passwords_private::UrlCollection CreateUrlCollectionFromForm(
    const autofill::PasswordForm& form);

// This class serves as an identifier for strings created by CreateSortKey() in
// the password_manager namespace. It is similar to base::IDMap, but also allows
// to get the id for an already inserted element.
// TODO(https://crbug.com/778146): This class should be an implementation detail
// of PasswordManagerPresenter. Move this class there once Android uses a
// similar logic.
class SortKeyIdGenerator {
 public:
  SortKeyIdGenerator();
  ~SortKeyIdGenerator();

  // This method generates an id corresponding to |sort_key|. Additionally it
  // remembers ids generated in the past, so that this method is idempotent.
  // Furthermore, it is guaranteed that different ids are returned for different
  // |sort_key| arguments. This implies GenerateId(a) == GenerateId(b) if and
  // only if a == b.
  int GenerateId(const std::string& sort_key);

  // This method tries to return the sort key corresponding to |id|. In case
  // |id| was not generated by GenerateId() before, this method returns nullptr.
  // Otherwise it returns a pointer s to a sort key, such that |id| ==
  // GenerateId(*s).
  const std::string* TryGetSortKey(int id) const;

 private:
  std::map<std::string, int> sort_key_cache_;
  base::flat_map<int, const std::string*> id_cache_;
  int next_id_ = 0;
};

}  // namespace extensions

#endif  // CHROME_BROWSER_EXTENSIONS_API_PASSWORDS_PRIVATE_PASSWORDS_PRIVATE_UTILS_H_
