/**********************************************************************

  Audacity: A Digital Audio Editor

  Repair.h

  Dominic Mazzoni

**********************************************************************/

#ifndef __AUDACITY_EFFECT_REPAIR__
#define __AUDACITY_EFFECT_REPAIR__

#include <wx/intl.h>
#include <wx/string.h>

#include "SimpleMono.h"

class WaveTrack;

class EffectRepair: public Effect {
   
public:
   
   EffectRepair();
   virtual ~EffectRepair();

   virtual wxString GetEffectName() {
      return wxString(_("Repair"));
   }

   virtual wxString GetEffectIdentifier() {
      return wxString(wxT("Repair"));
   }

   virtual wxString GetEffectAction() {
      return wxString(_("Repairing damaged audio"));
   }
   
   virtual bool PromptUser();
   virtual bool TransferParameters( Shuttle & shuttle );
   
   virtual bool Process();
   
private:
   bool ProcessOne(int count, WaveTrack * track,
                   longSampleCount start,
                   sampleCount len,
                   sampleCount repairStart, sampleCount repairLen);
};

#endif // __AUDACITY_EFFECT_REPAIT__

// Indentation settings for Vim and Emacs.
// Please do not modify past this point.
//
// Local Variables:
// c-basic-offset: 3
// indent-tabs-mode: nil
// End:
//
// vim: et sts=3 sw=3

