/*
 *  defines.h -- header file for apcupsd package
 *
 *  apcupsd.c -- Simple Daemon to catch power failure signals from a
 *               BackUPS, BackUPS Pro, or SmartUPS (from APCC).
 *            -- Now SmartMode support for SmartUPS and BackUPS Pro.
 *
 *  Copyright (C) 1996-99 Andre M. Hedrick <andre@suse.com>
 *  All rights reserved.
 *
 */

/*
 *                     GNU GENERAL PUBLIC LICENSE
 *                        Version 2, June 1991
 *
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *                           675 Mass Ave, Cambridge, MA 02139, USA
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 *  IN NO EVENT SHALL ANY AND ALL PERSONS INVOLVED IN THE DEVELOPMENT OF THIS
 *  PACKAGE, NOW REFERRED TO AS "APCUPSD-Team" BE LIABLE TO ANY PARTY FOR
 *  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
 *  OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ANY OR ALL
 *  OF THE "APCUPSD-Team" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  THE "APCUPSD-Team" SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 *  BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 *  ON AN "AS IS" BASIS, AND THE "APCUPSD-Team" HAS NO OBLIGATION TO PROVIDE
 *  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *  THE "APCUPSD-Team" HAS ABSOLUTELY NO CONNECTION WITH THE COMPANY
 *  AMERICAN POWER CONVERSION, "APCC".  THE "APCUPSD-Team" DID NOT AND
 *  HAS NOT SIGNED ANY NON-DISCLOSURE AGREEMENTS WITH "APCC".  ANY AND ALL
 *  OF THE LOOK-A-LIKE ( UPSlink(tm) Language ) WAS DERIVED FROM THE
 *  SOURCES LISTED BELOW.
 *
 */

#ifndef _APC_DEFINES_H
#define _APC_DEFINES_H

#define CORENAME "*Core*"

#define APCCONTROL              SYSCONFDIR "/apccontrol"

#ifndef APCCONF
#define APCCONF                 SYSCONFDIR "/apcupsd.conf"
#endif

#ifndef PWRFAILDIR
#define PWRFAILDIR              SYSCONFDIR
#endif

#ifndef PWRFAIL
#define PWRFAIL                 PWRFAILDIR "/powerfail"
#endif

#define NOLOGIN                 NOLOGDIR "/nologin"

#define APCPID                  PIDDIR "/apcupsd.pid"

/*
 * These two are not to be touched: we can not be sure how the user will
 * insert the locks directory path so we have to prepend the '/' just to be
 * sure: is better have /blah//LCK.. than /blahLCK..
 * -RF
 */
#define APC_LOCK_PREFIX         "/LCK.."
#define LOCK_DEFAULT            "/var/lock"

/*
 * JHNC:
 * This string should be the first line of the configuration file.
 * Then if we change the format later, we can just change this string.
 * Also, we could write code to use/convert out-of-date config files.
 */
#define APC_CONFIG_MAGIC        "## apcupsd.conf v1.1 ##"

#define POWERFAIL               "POWER FAILURE" /* put in nologin file */
#define REDO_NET                "RESET NET"

#define MAXSTRING               256
#define MESSAGELEN              256
#define MAXTOKENLEN             80
#define MAXSLAVES               20
#define UPSNAMELEN              100

#define DEFAULT_SPEED           B2400

/*
 * These are for UPS internal test routines.
 * They are all != 0 because this way there will be no
 * risk of confusing these statuses as boolean values:
 * they are all a boolean true.
 */
#define UPS_TEST_PASSED         0x01
#define UPS_TEST_FAILED         0x02
#define UPS_TEST_INPROGRESS     0x03
#define UPS_TEST_ACTIVATED      0x04

/* bit values for APC UPS Status Byte (ups->Status) */
#define UPS_CALIBRATION   0x001
#define UPS_SMARTTRIM     0x002
#define UPS_SMARTBOOST    0x004
#define UPS_ONLINE        0x008
#define UPS_ONBATT        0x010
#define UPS_OVERLOAD      0x020
#define UPS_BATTLOW       0x040
#define UPS_REPLACEBATT   0x080
/* Extended bit values added by apcupsd */
#define UPS_COMMLOST      0x100          /* Communications lost */
#define UPS_SHUTDOWN      0x200          /* Shutdown in progress */
#define UPS_SLAVE         0x400          /* Slave */

/*
 * CI_ is Capability or command index
 * XXX_CMD_ is the command code sent to UPS
 *  NOTE: the XXX_XXX_CMD_s are never used in the actual code,
 *        except to initialize the UPS_Cmd[] structure.
 *        this way, we will be able to support other UPSes
 *        later.
 *        The actual command is obtained by reference to
 *        UPS_Cmd[CI_xxx]    
 *  If the command is valid for this UPS, UPS_Cap[CI_xxx]
 *        will be true.
 */
#define CI_UPSMODEL             0     /* Model number */
#define    XXX_CMD_UPSMODEL       'V'
#define CI_STATUS               1     /* status function */
#define    XXX_CMD_STATUS         'Q'
#define CI_LQUAL                2     /* line quality status */ 
#define    XXX_CMD_LQUAL          '9'
#define CI_WHY_BATT             3     /* why transferred to battery */
#define    XXX_CMD_WHY_BATT       'G'
#define CI_ST_STAT              4     /* self test stat */
#define    XXX_CMD_ST_STAT        'X'
#define CI_VLINE                5     /* line voltage */
#define    XXX_CMD_VLINE          'L'
#define CI_VMAX                 6     /* max voltage */
#define    XXX_CMD_VMAX           'M'
#define CI_VMIN                 7     /* min line voltage */
#define    XXX_CMD_VMIN           'N'
#define CI_VOUT                 8     /* Output voltage */
#define    XXX_CMD_VOUT           'O'
#define CI_BATTLEV              9     /* Battery level percentage */
#define    XXX_CMD_BATTLEV        'f'
#define CI_VBATT               10     /* Battery voltage */
#define    XXX_CMD_VBATT          'B'
#define CI_LOAD                11     /* UPS Load */
#define    XXX_CMD_LOAD           'P'
#define CI_FREQ                12     /* Line Frequency */
#define    XXX_CMD_FREQ           'F'
#define CI_RUNTIM              13     /* Est. Runtime left */
#define    XXX_CMD_RUNTIM         'j'
#define CI_ITEMP               14     /* Internal UPS temperature */
#define    XXX_CMD_ITEMP          'C'
#define CI_DIPSW               15     /* Dip switch settings */
#define    XXX_CMD_DIPSW          '7'
#define CI_SENS                16     /* Sensitivity */
#define    XXX_CMD_SENS           's'
#define CI_DWAKE               17     /* Wakeup delay */
#define    XXX_CMD_DWAKE          'r'
#define CI_DSHUTD              18     /* Shutdown delay */
#define    XXX_CMD_DSHUTD         'p'
#define CI_LTRANS              19     /* Low transfer voltage */
#define    XXX_CMD_LTRANS         'l'
#define CI_HTRANS              20     /* High transfer voltage */
#define    XXX_CMD_HTRANS         'u'
#define CI_RETPCT              21     /* Return percent threshhold */
#define    XXX_CMD_RETPCT         'e'
#define CI_DALARM              22     /* Alarm delay */
#define    XXX_CMD_DALARM         'k'
#define CI_DLBATT              23     /* low battery warning, mins */
#define    XXX_CMD_DLBATT         'q'
#define CI_IDEN                24     /* UPS Identification (name) */
#define    XXX_CMD_IDEN           'c'
#define CI_STESTI              25     /* Self test interval */
#define    XXX_CMD_STESTI         'E'
#define CI_MANDAT              26     /* Manufacture date */
#define    XXX_CMD_MANDAT         'm'
#define CI_SERNO               27     /* serial number */
#define    XXX_CMD_SERNO          'n'
#define CI_BATTDAT             28     /* Last battery change */
#define    XXX_CMD_BATTDAT        'x'
#define CI_NOMBATTV            29     /* Nominal battery voltage */
#define    XXX_CMD_NOMBATTV       'g'
#define CI_HUMID               30     /* UPS Humidity percentage */
#define    XXX_CMD_HUMID          'h'
#define CI_REVNO               31     /* Firmware revision */
#define    XXX_CMD_REVNO          'b'
#define CI_REG1                32     /* Register 1 */
#define    XXX_CMD_REG1           '~'
#define CI_REG2                33     /* Register 2 */
#define    XXX_CMD_REG2           '\''
#define CI_REG3                34     /* Register 3 */
#define    XXX_CMD_REG3           '8'
#define CI_EXTBATTS            35     /* Number of external batteries */
#define    XXX_CMD_EXTBATTS       '>'
#define CI_ATEMP               36     /* Ambient temp */
#define    XXX_CMD_ATEMP          't'
#define CI_NOMOUTV             37     /* Nominal output voltage */
#define    XXX_CMD_NOMOUTV        'o'
#define CI_BADBATTS            38     /* Number of bad battery packs */
#define    XXX_CMD_BADBATTS       '<'
#define CI_EPROM               39     /* Valid eprom values */
#define    XXX_CMD_EPROM          0x1a
#define CI_ST_TIME             40     /* hours since last self test */
#define    XXX_CMD_ST_TIME        'd'

#define CI_CYCLE_EPROM         41     /* Cycle programmable EPROM values */
#define    XXX_CMD_CYCLE_EPROM    '-'
#define CI_UPS_CAPS            42     /* Get UPS capabilities (command) string */
#define    XXX_CMD_UPS_CAPS       'a'
/* ^^^^^^^^^^ see below if you change this ^^^^^^ */
/* set to last command index. CHANGE!!! when adding new code.  */
/* vvvvvvvvvv change here vvvvvvvvvvvvvvvvvvvvvvv */
#define CI_MAXCI         CI_UPS_CAPS      /* maximum UPS commands we handle */
#define CI_MAX_CAPS      CI_ST_TIME

#define GO_ON_BATT              'W'
#define GO_ON_LINE              'X'
#define LIGHTS_TEST             'A'
#define FAILURE_TEST            'U'

/*
 * Future additions for contolled discharing of batteries
 * extend lifetimes.
 */

#define DISCHARGE               'D'
#define CHARGE_LIM              25

#define UPS_ENABLED             '?'
#define UPS_ON_BATT             '!'
#define UPS_ON_LINE             '$'
#define UPS_REPLACE_BATTERY     '#'
#define BATT_LOW                '%'
#define BATT_OK                 '+'
#define UPS_EPROM_CHANGE        '|'
#define UPS_TRAILOR             ':'
#define UPS_LF                  '\n'
#define UPS_CR                  '\r'
/*
 * For apclock.c functions
 *
 * -RF
 */
#define LCKSUCCESS              0 /* lock file does not exist so go */
#define LCKERROR                1 /* lock file not our own and error encountered */
#define LCKEXIST                2 /* lock file is our own lock file */
#define LCKNOLOCK               3 /* lock file not needed: APC_NET */

/*
 * Generic defines for boolean return values.
 *
 * -RF
 */
#define SUCCESS                 0 /* Function successfull */
#define FAILURE                 1 /* Function failure */

/* These seem unavoidable :-( */
#ifndef TRUE
#       define TRUE            1
#endif
#ifndef FALSE
#       define FALSE           0
#endif


/*
 * This timer is the serial polling timer used by select().
 * We keep this one low because we don't want to wait too much on the FD if it
 * is silent. 5 seconds seem to be enough, may be less can be done. But I
 * think not less than 1 second because we don't want to eat too much CPU.
 */
#define TIMER_SERIAL            5

/*
 * Actions process need to check if there are actions to be done at least
 * every TIMER_SERIAL seconds. So TIMER_ACTION >= TIMER_SERIAL.
 */
#define TIMER_ACTION            5

/*
 * Net code will be soon obsoleted.
 */
#define TIMER_SLAVES            10

/* Make the size of these strings the next multiple of 4 */
#define APC_MAGIC               "apcupsd-linux-6.0"
#define APC_MAGIC_SIZE          4 * ((sizeof(APC_MAGIC) + 3) / 4)

#define ACCESS_MAGIC            "apcaccess-linux-4.0"
#define ACCESS_MAGIC_SIZE       4 * ((sizeof(APC_MAGIC) + 3) / 4)

/* 
 * These are the remote_state for networked master/slaves
 */
#define RMT_NOTCONNECTED        0
#define RMT_CONNECTED           1
#define RMT_RECONNECT           2
#define RMT_ERROR               3
#define RMT_DOWN                4


#define MAX_THREADS             7

/*
 * IPC defines.
 */
#define SEM_ID                  0x00FEED00
#define SHM_ID                  0x10FEED01
#define READ_CNT                0
#define WRITE_LCK               1
#define NUM_SEM                 2
#define NUM_SEM_OPER            3    /* 3 for write sem that need 1 operation more */

/*
 * Find members position in the UPSINFO and GLOBALCFG structures.
 */
#define WHERE(MEMBER) ((size_t) &((UPSINFO *)0)->MEMBER)
#define AT(UPS,OFFSET) ((size_t)UPS + OFFSET)
#define SIZE(MEMBER) ((GENINFO *)sizeof(((UPSINFO *)0)->MEMBER))


/*
 * Only 1 semaphore
 */
#define SEMNUM                  0


/*
 * These are the commands understood by the apccontrol shell script.
 * You _must_ keep the #defines in sync with the commands[] array in
 * apcaction.c
 */
#define CMDPOWEROUT      0
#define CMDONBATTERY     1
#define CMDFAILING       2
#define CMDTIMEOUT       3
#define CMDLOADLIMIT     4
#define CMDRUNLIMIT      5
#define CMDDOREBOOT      6
#define CMDDOSHUTDOWN    7
#define CMDMAINSBACK     8
#define CMDANNOYME       9
#define CMDEMERGENCY     10
#define CMDCHANGEME      11
#define CMDREMOTEDOWN    12
#define CMDRESTARTME     13
#define CMDCOMMFAILURE   14
#define CMDCOMMOK        15
#define CMDSTARTSELFTEST 16
#define CMDENDSELFTEST   17

/*
 * These defines are for netcmd and netserver
 */
#define AUTHKO  0               /* Not identified, not authorized */
#define AUTHID  1               /* Identified, not authorized */
#define AUTHPW  2               /* Identified, authorized */
#define POWERPW 3               /* For clients that interact with hardware */

#define IS_SERVER(x) ((x).NetUpsInterface[0] != '\0' && (x).NetUpsPort != 0)
#define IS_CONNECTED_TO_UPS(x) ((x)->device[0] == '/')
#define IS_NETCLIENT(x) ((x)->device[0] != '/')

/*
 * NetCodes for numeric chatting.
 */
#define NETCODENUL          100
#define NETCODEQUIT         101
#define NETCODERETRY        102
#define NETCODEOK           200
#define NETCODEURG          201
#define NETCODENOERR        202
#define NETCODEDONE         203
#define NETCODEERR          300
#define NETCODEINACT        301


/* Simple way of handling varargs for those compilers that
 * don't support varargs in #defines.
 */
#define Error_abort0(fmd) error_out(__FILE__, __LINE__, fmd)
#define Error_abort1(fmd, arg1) error_out(__FILE__, __LINE__, fmd, arg1)
#define Error_abort2(fmd, arg1,arg2) error_out(__FILE__, __LINE__, fmd, arg1,arg2)
#define Error_abort3(fmd, arg1,arg2,arg3) error_out(__FILE__, __LINE__, fmd, arg1,arg2,arg3)
#define Error_abort4(fmd, arg1,arg2,arg3,arg4) error_out(__FILE__, __LINE__, fmd, arg1,arg2,arg3,arg4)
#define Error_abort5(fmd, arg1,arg2,arg3,arg4,arg5) error_out(__FILE__, __LINE__, fmd, arg1,arg2,arg3,arg4,arg5)
#define Error_abort6(fmd, arg1,arg2,arg3,arg4,arg5,arg6) error_out(__FILE__, __LINE__, fmd, arg1,arg2,arg3,arg4,arg5,arg5)

#ifdef HAVE_PTHREADS
/* These probably should be subroutines */
#define P(x) \
   do { int errstat; if ((errstat=pthread_mutex_lock(&(x)))) \
      error_out(__FILE__, __LINE__, "Mutex lock failure. ERR=%s\n",\
           strerror(errstat)); \
   } while(0)

#define V(x) \
   do { int errstat; if ((errstat=pthread_mutex_unlock(&(x)))) \
         error_out(__FILE__, __LINE__, "Mutex unlock failure. ERR=%s\n",\
           strerror(errstat)); \
   } while(0)

#endif

#endif /* _APC_DEFINES_H */
