/*
 * Include file for apcnetlib.c definitions
 *
 */


extern struct sockaddr_in tcp_serv_addr;     /* socket information */
extern int net_errno;                        /* error number -- not yet implemented */
extern char *net_errmsg;                     /* pointer to error message */
extern char net_errbuf[256];                 /* error message buffer for messages */



/* 
 * Receive a message from the other end. Each message consists of
 * two packets. The first is a header that contains the size
 * of the data that follows in the second packet.
 * Returns number of bytes read
 * Returns 0 on end of file
 * Returns -1 on error
 */
int net_recv(int sockfd, char *buff, int maxlen);

/*
 * Send a message over the network. The send consists of
 * two network packets. The first is sends a short containing
 * the length of the data packet which follows.
 * Returns number of bytes sent
 * Returns -1 on error
 */
int net_send(int sockfd, char *buff, int len);

/*     
 * Open a TCP connection to the UPS network server
 * Returns -1 on error
 * Returns socket file descriptor otherwise
 */
int net_open(char *host, char *service, int port);

/* Close the network connection */
void net_close(int sockfd);

extern int  upserror, syserrno;

#define UNKNOWN         0x1000
#define NOSUCHVAR       0x1001
#define NOSUCHHOST      0x1002
#define SENDFAILURE     0x1003
#define RECVFAILURE     0x1004
#define SOCKFAILURE     0x1005
#define BINDFAILURE     0x1006
#define RECVTIMEOUT     0x1007
#define NOCOMM1         0x1008
#define UNKNOWNUPS      0x1009
#define ACCESSDENIED    0x100A
#define CONNFAILURE     0x100B
#define READERROR       0x100C
#define WRITEERROR      0x100D
#define INVALIDPW       0x100E
#define BADPASSWD       0x100F
#define WRONGVAR        0x1010
#define UNKNOWNLVL      0x1011
#define UNKNOWNCMD      0x1012


/* common error condition handler */
int errcheck (char *buf);
