/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef STARTREK_FUNCTIONMAP_H
#define STARTREK_FUNCTIONMAP_H

#include "startrek/action.h"
#include "startrek/room.h"

namespace StarTrek {

RoomAction demon0ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::demon0Tick1 },
	{ {ACTION_TICK, 2, 0, 0}, &Room::demon0Tick2 },
	{ {ACTION_TICK, 60, 0, 0}, &Room::demon0Tick60 },
	{ {ACTION_TICK, 100, 0, 0}, &Room::demon0Tick100 },
	{ {ACTION_TICK, 140, 0, 0}, &Room::demon0Tick140 },

	{ {ACTION_TOUCHED_WARP, 0, 0, 0}, &Room::demon0TouchedWarp0 },

	{ {ACTION_WALK, 0x27, 0, 0}, &Room::demon0WalkToBottomDoor },
	{ {ACTION_WALK, 9, 0, 0}, &Room::demon0WalkToBottomDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 1, 0, 0}, &Room::demon0TouchedHotspot1 },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::demon0ReachedBottomDoor },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::demon0ReachedBottomDoor },

	{ {ACTION_WALK, 0x26, 0, 0}, &Room::demon0WalkToTopDoor },
	{ {ACTION_WALK, 10, 0, 0}, &Room::demon0WalkToTopDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::demon0TouchedHotspot0 },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::demon0ReachedTopDoor },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::demon0ReachedTopDoor },

	{ {ACTION_TALK, 8, 0, 0}, &Room::demon0TalkToPrelate },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::demon0LookAtPrelate },

	{ {ACTION_USE, OBJECT_IPHASERS, 0x23, 0}, &Room::demon0UsePhaserOnSnow },
	{ {ACTION_USE, OBJECT_IPHASERK, 0x23, 0}, &Room::demon0UsePhaserOnSnow },
	{ {ACTION_USE, OBJECT_IPHASERS, 0x25, 0}, &Room::demon0UsePhaserOnSign },
	{ {ACTION_USE, OBJECT_IPHASERK, 0x25, 0}, &Room::demon0UsePhaserOnSign },
	{ {ACTION_USE, OBJECT_IPHASERK, 0x20, 0}, &Room::demon0UsePhaserOnShelter },
	{ {ACTION_USE, OBJECT_IPHASERK, 8, 0}, &Room::demon0UsePhaserOnPrelate },

	{ {ACTION_LOOK, 0x25, 0, 0}, &Room::demon0LookAtSign },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::demon0LookAtTrees },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::demon0LookAtTrees },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::demon0LookAtSnow },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::demon0LookAnywhere },
	{ {ACTION_LOOK, 0x24, 0, 0}, &Room::demon0LookAtBushes },

	{ {ACTION_LOOK, OBJECT_KIRK,     0, 0}, &Room::demon0LookAtKirk },
	{ {ACTION_LOOK, OBJECT_MCCOY,    0, 0}, &Room::demon0LookAtMcCoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::demon0LookAtRedShirt },
	{ {ACTION_LOOK, OBJECT_SPOCK,    0, 0}, &Room::demon0LookAtSpock },

	{ {ACTION_LOOK, 9, 0, 0}, &Room::demon0LookAtShelter },    // Door 1
	{ {ACTION_LOOK, 10, 0, 0}, &Room::demon0LookAtShelter },   // Door 2
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::demon0LookAtShelter }, // Shelter itself

	{ {ACTION_TALK, OBJECT_KIRK,     0, 0}, &Room::demon0TalkToKirk },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::demon0TalkToRedshirt },
	{ {ACTION_TALK, OBJECT_MCCOY,    0, 0}, &Room::demon0TalkToMcCoy },
	{ {ACTION_TALK, OBJECT_SPOCK,    0, 0}, &Room::demon0TalkToSpock },

	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::demon0UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0xff, 0}, &Room::demon0UseMTricorderAnywhere },
	{ {ACTION_USE, OBJECT_IMTRICOR, 8, 0}, &Room::demon0UseMTricorderOnPrelate },
};

RoomAction demon1ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::demon1Tick1 },

	{ {ACTION_WALK, 0x25, 0, 0}, &Room::demon1WalkToCave },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::demon1TouchedTopWarp },
	{ {ACTION_TOUCHED_WARP, 0, 0, 0}, &Room::demon1TouchedTopWarp },
	{ {ACTION_TOUCHED_WARP, 1, 0, 0}, &Room::demon1TouchedBottomWarp },

	{ {ACTION_TIMER_EXPIRED, 2, 0, 0}, &Room::demon1Timer2Expired },
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::demon1Timer0Expired },
	{ {ACTION_TIMER_EXPIRED, 3, 0, 0}, &Room::demon1Timer3Expired },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::demon1Timer1Expired },

	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::demon1KlingonFinishedAimingWeapon },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::demon1KirkShot },

	{ {ACTION_USE, OBJECT_IPHASERK, 0xff, 0}, &Room::demon1UsePhaserOnAnything },
	{ {ACTION_USE, OBJECT_IPHASERS, 0xff, 0}, &Room::demon1UsePhaserOnAnything },

	{ {ACTION_USE, OBJECT_IPHASERK, 8, 0}, &Room::demon1UsePhaserOnKlingon1 },
	{ {ACTION_USE, OBJECT_IPHASERS, 8, 0}, &Room::demon1UsePhaserOnKlingon1 },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::demon1ShootKlingon1 },
	{ {ACTION_FINISHED_ANIMATION, 7, 0, 0}, &Room::demon1KlingonDropsHand },

	{ {ACTION_USE, OBJECT_IPHASERK, 9, 0}, &Room::demon1UsePhaserOnKlingon2 },
	{ {ACTION_USE, OBJECT_IPHASERS, 9, 0}, &Room::demon1UsePhaserOnKlingon2 },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::demon1ShootKlingon2 },

	{ {ACTION_USE, OBJECT_IPHASERK, 10, 0}, &Room::demon1UsePhaserOnKlingon3 },
	{ {ACTION_USE, OBJECT_IPHASERS, 10, 0}, &Room::demon1UsePhaserOnKlingon3 },
	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0}, &Room::demon1ShootKlingon3 },

	{ {ACTION_TIMER_EXPIRED, 6, 0, 0}, &Room::demon1AllKlingonsDead },
	{ {ACTION_TIMER_EXPIRED, 5, 0, 0}, &Room::demon1Timer5Expired },

	{ {ACTION_USE, OBJECT_IMTRICOR, 13, 0}, &Room::demon1UseMTricorderOnKlingon },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::demon1UseSTricorderOnTulips },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x22, 0}, &Room::demon1UseSTricorderOnPods },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::demon1UseSTricorderOnCattails },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x23, 0}, &Room::demon1UseSTricorderOnFerns },
	{ {ACTION_USE, OBJECT_ISTRICOR, 13, 0}, &Room::demon1UseSTricorderOnHand },
	{ {ACTION_USE, OBJECT_ISTRICOR, 8, 0}, &Room::demon1UseSTricorderOnKlingon1 },
	{ {ACTION_USE, OBJECT_ISTRICOR, 10, 0}, &Room::demon1UseSTricorderOnKlingon2Or3 },
	{ {ACTION_USE, OBJECT_ISTRICOR, 9, 0}, &Room::demon1UseSTricorderOnKlingon2Or3 },
	{ {ACTION_USE, OBJECT_IMEDKIT,  8, 0}, &Room::demon1UseMTricorderOnKlingon },
	{ {ACTION_USE, OBJECT_IMTRICOR, 8, 0}, &Room::demon1UseMTricorderOnKlingon },
	{ {ACTION_USE, OBJECT_IMEDKIT, 10, 0}, &Room::demon1UseMTricorderOnKlingon },
	{ {ACTION_USE, OBJECT_IMEDKIT,  9, 0}, &Room::demon1UseMTricorderOnKlingon },
	{ {ACTION_USE, OBJECT_IMTRICOR, 10, 0}, &Room::demon1UseMTricorderOnKlingon },
	{ {ACTION_USE, OBJECT_IMTRICOR,  9, 0}, &Room::demon1UseMTricorderOnKlingon },
	{ {ACTION_USE, OBJECT_ISTRICOR, 8, 0}, &Room::demon1UseSTricorderOnKlingon2Or3 }, // This is redundant

	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_KIRK, 0}, &Room::demon1UseMTricorderOnKirk },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_SPOCK, 0}, &Room::demon1UseMTricorderOnSpock },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_REDSHIRT, 0}, &Room::demon1UseMTricorderOnRedshirt },

	{ {ACTION_GET, 13, 0, 0}, &Room::demon1GetHand },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::demon1ReachedHand },
	{ {ACTION_FINISHED_ANIMATION, 6, 0, 0}, &Room::demon1PickedUpHand },
	{ {ACTION_TIMER_EXPIRED, 4, 0, 0}, &Room::demon1FinishedGettingHand },

	{ {ACTION_LOOK, 8, 0, 0}, &Room::demon1LookAtKlingon },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::demon1LookAtKlingon },
	{ {ACTION_LOOK, 10, 0, 0}, &Room::demon1LookAtKlingon },

	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::demon1LookAtCattails },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::demon1LookAtTulips },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::demon1LookAtPods },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::demon1LookAtFerns },
	{ {ACTION_LOOK, 0x24, 0, 0}, &Room::demon1LookAtStream },
	{ {ACTION_LOOK, 0x25, 0, 0}, &Room::demon1LookAtMine },
	{ {ACTION_LOOK, 0x26, 0, 0}, &Room::demon1LookAtMountain },
	{ {ACTION_LOOK, 13, 0, 0}, &Room::demon1LookAtHand },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::demon1LookAnywhere },
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::demon1LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::demon1LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::demon1LookAtMcCoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::demon1LookAtRedshirt },

	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::demon1TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::demon1TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::demon1TalkToMcCoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::demon1TalkToRedshirt },
};

RoomAction demon2ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::demon2Tick1 },
	{ {ACTION_WALK, 0x27, 0, 0}, &Room::demon2WalkToCave },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::demon2ReachedCave },
	{ {ACTION_TOUCHED_WARP, 1, 0, 0}, &Room::demon2TouchedWarp1 },

	{ {ACTION_LOOK, 0x27, 0, 0}, &Room::demon2LookAtCave },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::demon2LookAtCave },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::demon2LookAtMountain },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::demon2LookAtMountain },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::demon2LookAtBerries },
	{ {ACTION_LOOK, 0x24, 0, 0}, &Room::demon2LookAtFern },
	{ {ACTION_LOOK, 0x25, 0, 0}, &Room::demon2LookAtMoss },
	{ {ACTION_LOOK, 0x26, 0, 0}, &Room::demon2LookAtLights },
	{ {ACTION_LOOK, 0xff, 0, 0},   &Room::demon2LookAtAnything },

	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::demon2LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::demon2LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::demon2LookAtMcCoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::demon2LookAtRedshirt },

	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::demon2TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::demon2TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::demon2TalkToMcCoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::demon2TalkToRedshirt },

	{ {ACTION_USE, OBJECT_IPHASERK, 0x23, 0}, &Room::demon2UsePhaserOnBerries },
	{ {ACTION_USE, OBJECT_IPHASERS, 0x23, 0}, &Room::demon2UsePhaserOnBerries },

	{ {ACTION_USE, OBJECT_ISTRICOR, 0x23, 0}, &Room::demon2UseSTricorderOnBerries },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x25, 0}, &Room::demon2UseSTricorderOnMoss },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x24, 0}, &Room::demon2UseSTricorderOnFern },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::demon2UseSTricorderOnCave },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::demon2UseSTricorderOnCave },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x22, 0}, &Room::demon2UseSTricorderOnCave },

	{ {ACTION_USE, OBJECT_IMTRICOR, 0x23, 0}, &Room::demon2UseMTricorderOnBerries },
	{ {ACTION_GET, 0x23, 0, 0}, &Room::demon2GetBerries },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::demon2ReachedBerries },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::demon2PickedUpBerries },
};

RoomAction demon3ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::demon3Tick1 },
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::demon3Timer0Expired },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::demon3Timer1Expired },
	{ {ACTION_TIMER_EXPIRED, 3, 0, 0}, &Room::demon3Timer3Expired },

	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::demon3FinishedAnimation1 },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::demon3FinishedAnimation2 },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0}, &Room::demon3FinishedWalking5 },

	{ {ACTION_FINISHED_WALKING, 3, 0, 0}, &Room::demon3McCoyInFiringPosition },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::demon3SpockInFiringPosition },
	{ {ACTION_FINISHED_WALKING, 4, 0, 0}, &Room::demon3RedShirtInFiringPosition },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::demon3KirkInFiringPosition },

	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::demon3FireAtBoulder },

	{ {ACTION_USE, OBJECT_IPHASERS, OBJECT_REDSHIRT, 0}, &Room::demon3UsePhaserOnRedshirt },
	{ {ACTION_USE, OBJECT_IPHASERK, OBJECT_REDSHIRT, 0}, &Room::demon3UsePhaserOnRedshirt },

	{ {ACTION_USE, OBJECT_IPHASERS,  9, 0}, &Room::demon3UseStunPhaserOnBoulder },
	{ {ACTION_USE, OBJECT_IPHASERS, 10, 0}, &Room::demon3UseStunPhaserOnBoulder },
	{ {ACTION_USE, OBJECT_IPHASERS, 11, 0}, &Room::demon3UseStunPhaserOnBoulder },
	{ {ACTION_USE, OBJECT_IPHASERS, 12, 0}, &Room::demon3UseStunPhaserOnBoulder },

	{ {ACTION_USE, OBJECT_IPHASERK,  9, 0}, &Room::demon3UsePhaserOnBoulder1 },
	{ {ACTION_USE, OBJECT_IPHASERK, 10, 0}, &Room::demon3UsePhaserOnBoulder2 },
	{ {ACTION_USE, OBJECT_IPHASERK, 11, 0}, &Room::demon3UsePhaserOnBoulder3 },
	{ {ACTION_USE, OBJECT_IPHASERK, 12, 0}, &Room::demon3UsePhaserOnBoulder4 },

	{ {ACTION_USE, OBJECT_ISTRICOR, 13, 0}, &Room::demon3UseSTricorderOnMiner },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::demon3UseSTricorderOnPanel },
	{ {ACTION_USE, OBJECT_ISTRICOR,  9, 0}, &Room::demon3UseSTricorderOnBoulder },
	{ {ACTION_USE, OBJECT_ISTRICOR, 10, 0}, &Room::demon3UseSTricorderOnBoulder },
	{ {ACTION_USE, OBJECT_ISTRICOR, 11, 0}, &Room::demon3UseSTricorderOnBoulder },
	{ {ACTION_USE, OBJECT_ISTRICOR, 12, 0}, &Room::demon3UseSTricorderOnBoulder },
	{ {ACTION_USE, OBJECT_IMTRICOR,  9, 0}, &Room::demon3UseMTricorderOnBoulder },
	{ {ACTION_USE, OBJECT_IMTRICOR, 10, 0}, &Room::demon3UseMTricorderOnBoulder },
	{ {ACTION_USE, OBJECT_IMTRICOR, 11, 0}, &Room::demon3UseMTricorderOnBoulder },
	{ {ACTION_USE, OBJECT_IMTRICOR, 12, 0}, &Room::demon3UseMTricorderOnBoulder },

	{ {ACTION_USE, OBJECT_KIRK, 0x20, 0}, &Room::demon3UseCrewmanOnPanel },
	{ {ACTION_USE, OBJECT_SPOCK, 0x20, 0}, &Room::demon3UseCrewmanOnPanel },
	{ {ACTION_USE, OBJECT_MCCOY, 0x20, 0}, &Room::demon3UseCrewmanOnPanel },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x20, 0}, &Room::demon3UseRedshirtOnPanel },
	{ {ACTION_FINISHED_WALKING, 8, 0, 0}, &Room::demon3RedshirtReachedPanel },
	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0}, &Room::demon3RedshirtUsedPanel },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::demon3RedshirtElectrocuted },

	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::demon3UseSTricorderOnDoor },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::demon3UseSTricorderOnAnything },
	{ {ACTION_USE, OBJECT_IMTRICOR, 14, 0}, &Room::demon3UseMTricorderOnDoor },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x21, 0}, &Room::demon3UseMTricorderOnDoor },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x22, 0}, &Room::demon3UseMTricorderOnDoor },
	{ {ACTION_USE, OBJECT_IPHASERS, 14, 0}, &Room::demon3UsePhaserOnDoor },
	{ {ACTION_USE, OBJECT_IPHASERK, 14, 0}, &Room::demon3UsePhaserOnDoor },
	{ {ACTION_USE, OBJECT_IPHASERS, 0x21, 0}, &Room::demon3UsePhaserOnDoor },
	{ {ACTION_USE, OBJECT_IPHASERK, 0x21, 0}, &Room::demon3UsePhaserOnDoor },

	{ {ACTION_USE, OBJECT_IHAND, 0x20, 0}, &Room::demon3UseHandOnPanel },
	{ {ACTION_FINISHED_WALKING, 7, 0, 0}, &Room::demon3KirkReachedHandPanel },
	{ {ACTION_FINISHED_ANIMATION, 6, 0, 0}, &Room::demon3KirkUsedHandPanel },

	{ {ACTION_USE, OBJECT_IMTRICOR, 13, 0}, &Room::demon3UseMTricorderOnMiner },
	{ {ACTION_USE, OBJECT_MCCOY, 13, 0}, &Room::demon3UseMedkitOnMiner },
	{ {ACTION_USE, OBJECT_IMEDKIT, 13, 0}, &Room::demon3UseMedkitOnMiner },
	{ {ACTION_FINISHED_WALKING, 6, 0, 0}, &Room::demon3McCoyReachedMiner },
	{ {ACTION_FINISHED_ANIMATION, 7, 0, 0}, &Room::demon3McCoyFinishedHealingMiner },

	{ {ACTION_GET, 13, 0, 0}, &Room::demon3GetMiner },
	{ {ACTION_TALK, 13, 0, 0}, &Room::demon3TalkToMiner },

	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::demon3TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::demon3TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::demon3TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::demon3TalkToRedshirt },

	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::demon3LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::demon3LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::demon3LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::demon3LookAtRedshirt },

	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::demon3LookAnywhere },
	{ {ACTION_LOOK, 13, 0, 0}, &Room::demon3LookAtMiner },
	{ {ACTION_LOOK,  9, 0, 0}, &Room::demon3LookAtBoulder1 },
	{ {ACTION_LOOK, 10, 0, 0}, &Room::demon3LookAtBoulder2 },
	{ {ACTION_LOOK, 11, 0, 0}, &Room::demon3LookAtBoulder3 },
	{ {ACTION_LOOK, 12, 0, 0}, &Room::demon3LookAtBoulder4 },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::demon3LookAtStructure },
	{ {ACTION_LOOK, 14, 0, 0}, &Room::demon3LookAtDoor },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::demon3LookAtDoor },
	{ {ACTION_LOOK, 15, 0, 0}, &Room::demon3LookAtPanel },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::demon3LookAtPanel },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::demon3LookAtLight },

};

RoomAction demon4ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::demon4Tick1 },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::demon4FinishedAnimation1 },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::demon4FinishedAnimation2 },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::demon4FinishedAnimation3 },
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::demon4Timer0Expired },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::demon4Timer1Expired },
	{ {ACTION_FINISHED_WALKING, 4, 0, 0}, &Room::demon4CrewmanReachedBeamoutPosition },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0}, &Room::demon4Timer2Expired },
	{ {ACTION_TIMER_EXPIRED, 3, 0, 0}, &Room::demon4Timer3Expired },
	{ {ACTION_TIMER_EXPIRED, 4, 0, 0}, &Room::demon4Timer4Expired },
	{ {ACTION_TIMER_EXPIRED, 5, 0, 0}, &Room::demon4Timer5Expired },
	{ {ACTION_TIMER_EXPIRED, 6, 0, 0}, &Room::demon4Timer6Expired },

	{ {ACTION_USE, OBJECT_IPHASERK, 8, 0}, &Room::demon4UsePhaserOnNauian },
	{ {ACTION_USE, OBJECT_IPHASERS, 8, 0}, &Room::demon4UsePhaserOnNauian },
	{ {ACTION_USE, OBJECT_IMETAL, 0x22, 0}, &Room::demon4UseMetalOnSecurityEquipment },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0}, &Room::demon4KirkReachedSecurityEquipment },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::demon4KirkFinishedUsingSecurityEquipment },
	{ {ACTION_USE, OBJECT_IMETAL, 8, 0}, &Room::demon4UseMetalOnNauian },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::demon4KirkReachedNauian },
	{ {ACTION_USE, OBJECT_ISKULL, 8, 0}, &Room::demon4UseSkullOnNauian },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::demon4KirkReachedNauianWithSkull },

	{ {ACTION_USE, OBJECT_IPHASERS, 0x21, 0}, &Room::demon4UsePhaserOnPanel },
	{ {ACTION_USE, OBJECT_IPHASERS, 0x20, 0}, &Room::demon4UsePhaserOnPattern },
	{ {ACTION_USE, OBJECT_IPHASERS, OBJECT_MCCOY, 0}, &Room::demon4UsePhaserOnMccoy },

	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0}, &Room::demon4TalkToNauian },
	{ {ACTION_TALK, 8, 0, 0}, &Room::demon4TalkToNauian },

	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::demon4LookAtPattern },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::demon4LookAtAlien },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::demon4LookAnywhere },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::demon4LookAtSecurityEquipment },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::demon4LookAtFloor },

	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::demon4LookAtKirk },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::demon4LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::demon4LookAtSpock },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::demon4LookAtRedshirt },

	{ {ACTION_LOOK, 10, 0, 0}, &Room::demon4LookAtChamber },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::demon4LookAtPanel },

	{ {ACTION_USE, OBJECT_KIRK, 0x21, 0}, &Room::demon4UseKirkOnPanel },
	{ {ACTION_USE, OBJECT_SPOCK, 0x21, 0}, &Room::demon4UseSpockOnPanel },
	{ {ACTION_USE, OBJECT_MCCOY, 0x21, 0}, &Room::demon4UseMccoyOnPanel },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x21, 0}, &Room::demon4UseRedshirtOnPanel },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0}, &Room::demon4CrewmanReachedPanel },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::demon4TalkToKirk },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::demon4TalkToMccoy },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::demon4TalkToSpock },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::demon4TalkToRedshirt },
	{ {ACTION_USE, OBJECT_ISTRICOR, 10, 0}, &Room::demon4UseSTricorderOnChamber },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::demon4UseSTricorderOnPattern },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x20, 0}, &Room::demon4UseMTricorderOnPattern },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::demon4UseSTricorderOnPanel },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x21, 0}, &Room::demon4UseMTricorderOnPanel },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x23, 0}, &Room::demon4UseSTricorderOnAnything },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::demon4UseSTricorderOnAnything },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x23, 0}, &Room::demon4UseMTricorderOnAnything },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0xff, 0}, &Room::demon4UseMTricorderOnAnything },
	{ {ACTION_USE, OBJECT_ISTRICOR, 8, 0}, &Room::demon4UseSTricorderOnNauian },
	{ {ACTION_USE, OBJECT_IMTRICOR, 8, 0}, &Room::demon4UseMTricorderOnNauian },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x22, 0}, &Room::demon4UseSTricorderOnSecurityEquipment },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x22, 0}, &Room::demon4UseMTricorderOnSecurityEquipment },
};

RoomAction demon5ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::demon5Tick1 },
	{ {ACTION_WALK, 0x22, 0, 0}, &Room::demon5WalkToDoor },
	{ {ACTION_WALK, 12, 0, 0}, &Room::demon5WalkToDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::demon5TouchedDoorOpenTrigger },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::demon5DoorOpenedOrReachedDoor },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::demon5DoorOpenedOrReachedDoor },

	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::demon5UseSTricorderOnCrate },
	{ {ACTION_USE, OBJECT_IPHASERK, 0xff, 0}, &Room::demon5UsePhaserOnAnything },
	{ {ACTION_USE, OBJECT_IPHASERS, 0xff, 0}, &Room::demon5UsePhaserOnAnything },

	{ {ACTION_USE, OBJECT_IHAND, 11, 0}, &Room::demon5UseHandOnStephen },
	{ {ACTION_USE, OBJECT_IBERRY, 11, 0}, &Room::demon5UseBerryOnStephen },
	{ {ACTION_USE, OBJECT_IDETOXIN, 9, 0}, &Room::demon5UseHypoDytoxinOnChub },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::demon5MccoyReachedChub },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::demon5MccoyHealedChub },

	{ {ACTION_USE, OBJECT_IDETOXIN, 0xff, 0}, &Room::demon5UseHypoDytoxinOnAnything },
	{ {ACTION_USE, OBJECT_IBERRY, 9, 0}, &Room::demon5UseBerryOnChub },

	{ {ACTION_LOOK, 8, 0, 0}, &Room::demon5LookAtRoberts },
	{ {ACTION_LOOK, 10, 0, 0}, &Room::demon5LookAtGrisnash },
	{ {ACTION_LOOK, 11, 0, 0}, &Room::demon5LookAtStephen },

	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::demon5LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::demon5LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::demon5LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::demon5LookAtRedshirt },

	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::demon5LookAtMountain },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::demon5LookAtCrate },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::demon5LookAnywhere },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::demon5LookAtChub },

	{ {ACTION_TALK, 8, 0, 0}, &Room::demon5TalkToRoberts },
	{ {ACTION_TALK, 9, 0, 0}, &Room::demon5TalkToChub },
	{ {ACTION_TALK, 10, 0, 0}, &Room::demon5TalkToGrisnash },
	{ {ACTION_TALK, 11, 0, 0}, &Room::demon5TalkToStephen },

	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::demon5TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::demon5TalkToSpock },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::demon5TalkToRedshirt },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::demon5TalkToMccoy },

	{ {ACTION_USE, OBJECT_IMTRICOR, 8, 0}, &Room::demon5UseMTricorderOnRoberts },
	{ {ACTION_USE, OBJECT_IMEDKIT,  9, 0}, &Room::demon5UseMTricorderOnChub },
	{ {ACTION_USE, OBJECT_MCCOY,    9, 0}, &Room::demon5UseMTricorderOnChub },
	{ {ACTION_USE, OBJECT_IMTRICOR, 9, 0}, &Room::demon5UseMTricorderOnChub },
	{ {ACTION_USE, OBJECT_IMTRICOR, 10, 0}, &Room::demon5UseMTricorderOnGrisnash },
	{ {ACTION_USE, OBJECT_IMTRICOR, 11, 0}, &Room::demon5UseMTricorderOnStephen },

	{ {ACTION_GET, 0x21, 0, 0}, &Room::demon5GetCrate },
};

RoomAction demon6ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::demon6Tick1 },
	{ {ACTION_TICK, 30, 0, 0}, &Room::demon6Tick30 },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0}, &Room::demon6SpockReachedComputer },

	{ {ACTION_WALK, 0x26, 0, 0}, &Room::demon6WalkToDoor },
	{ {ACTION_WALK, 10, 0, 0}, &Room::demon6WalkToDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::demon6TouchedDoorOpenTrigger },
	{ {ACTION_FINISHED_WALKING, 4, 0, 0}, &Room::demon6DoorOpenedOrReachedDoor },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::demon6DoorOpenedOrReachedDoor },
	{ {ACTION_USE, OBJECT_IPHASERK, 8, 0}, &Room::demon6UsePhaserOnStephen },
	{ {ACTION_USE, OBJECT_IPHASERS, 8, 0}, &Room::demon6UsePhaserOnStephen },
	{ {ACTION_USE, OBJECT_IPHASERK, 0x20, 0}, &Room::demon6UsePhaserOnCase },
	{ {ACTION_USE, OBJECT_IPHASERS, 0x20, 0}, &Room::demon6UsePhaserOnCase },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::demon6LookAtWorkspace },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::demon6LookAtCase },
	{ {ACTION_LOOK, 0x25, 0, 0}, &Room::demon6LookAtTable },
	{ {ACTION_LOOK, OBJECT_IMINERAL, 0, 0}, &Room::demon6LookAtMineral },
	{ {ACTION_LOOK, OBJECT_ISHELLS, 0, 0}, &Room::demon6LookAtShells },
	{ {ACTION_LOOK, OBJECT_ISKULL, 0, 0}, &Room::demon6LookAtSkull },
	{ {ACTION_LOOK, OBJECT_IMETAL, 0, 0}, &Room::demon6LookAtMetal },
	{ {ACTION_LOOK, OBJECT_IMETEOR, 0, 0}, &Room::demon6LookAtMeteor },
	{ {ACTION_LOOK, 0x24, 0, 0}, &Room::demon6LookAtMountain },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::demon6LookAtSynthesizer },
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::demon6LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::demon6LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::demon6LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::demon6LookAtRedshirt },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::demon6LookAtComputer },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::demon6LookAtComputer },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::demon6LookAnywhere },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::demon6LookAtStephen },

	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::demon6TalkToMccoy },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::demon6TalkToSpock },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::demon6TalkToKirk },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::demon6TalkToRedshirt },
	{ {ACTION_TALK, 8, 0, 0}, &Room::demon6TalkToStephen },
	{ {ACTION_USE, OBJECT_IBERRY, 8, 0}, &Room::demon6UseBerryOnStephen },
	{ {ACTION_USE, OBJECT_IBERRY, 0x23, 0}, &Room::demon6UseBerryOnSynthesizer },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::demon6MccoyReachedSynthesizer },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::demon6FinishedMakingHypoDytoxin },
	{ {ACTION_USE, OBJECT_IHAND, 0x22, 0}, &Room::demon6UseHandOnWorkspace },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::demon6SpockReachedWorkspace },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::demon6SpockFinishedRepairingHand },
	{ {ACTION_USE, 0xff, 0x22, 0}, &Room::demon6UseAnythingOnWorkspace },
	{ {ACTION_USE, OBJECT_KIRK, 0x20, 0}, &Room::demon6UseCrewmanOnCase },
	{ {ACTION_USE, OBJECT_MCCOY, 0x20, 0}, &Room::demon6UseCrewmanOnCase },
	{ {ACTION_USE, OBJECT_SPOCK, 0x20, 0}, &Room::demon6UseCrewmanOnCase },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x20, 0}, &Room::demon6UseCrewmanOnCase },

	{ {ACTION_USE, OBJECT_KIRK, 0x21, 0}, &Room::demon6UseKirkOnComputer },
	{ {ACTION_USE, OBJECT_KIRK, 9, 0}, &Room::demon6UseKirkOnComputer },
	{ {ACTION_USE, OBJECT_MCCOY, 0x21, 0}, &Room::demon6UseMccoyOnComputer },
	{ {ACTION_USE, OBJECT_MCCOY, 9, 0}, &Room::demon6UseMccoyOnComputer },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x21, 0}, &Room::demon6UseRedshirtOnComputer },
	{ {ACTION_USE, OBJECT_REDSHIRT, 9, 0}, &Room::demon6UseRedshirtOnComputer },
	{ {ACTION_USE, OBJECT_SPOCK, 0x21, 0}, &Room::demon6UseSpockOnComputer },
	{ {ACTION_USE, OBJECT_SPOCK, 9, 0}, &Room::demon6UseSpockOnComputer },
	{ {ACTION_USE, OBJECT_IMINERAL, 8, 0}, &Room::demon6UseMineralOnStephen },
	{ {ACTION_USE, OBJECT_ISHELLS, 8, 0}, &Room::demon6UseShellsOnStephen },
	{ {ACTION_USE, OBJECT_IMETEOR, 8, 0}, &Room::demon6UseMeteorOnStephen },
	{ {ACTION_USE, OBJECT_ISKULL, 8, 0}, &Room::demon6UseSkullOnStephen },
	{ {ACTION_USE, OBJECT_IMETAL, 8, 0}, &Room::demon6UseMetalOnStephen },
	{ {ACTION_USE, OBJECT_IHAND, 8, 0}, &Room::demon6UseHandOnStephen },
	{ {ACTION_USE, OBJECT_IMTRICOR, 8, 0}, &Room::demon6UseMTricoderOnStephen },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x25, 0}, &Room::demon6UseSTricoderOnTable },
	{ {ACTION_USE, OBJECT_ISTRICOR, 9, 0}, &Room::demon6UseSTricoderOnComputer },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::demon6UseSTricoderOnComputer },
	{ {ACTION_USE, OBJECT_ISTRICOR, OBJECT_IMINERAL, 0}, &Room::demon6UseSTricoderOnMineral },
	{ {ACTION_USE, OBJECT_ISTRICOR, OBJECT_ISHELLS, 0}, &Room::demon6UseSTricoderOnShells },
	{ {ACTION_USE, OBJECT_ISTRICOR, OBJECT_ISKULL, 0}, &Room::demon6UseSTricoderOnSkull },
	{ {ACTION_USE, OBJECT_ISTRICOR, OBJECT_IMETAL, 0}, &Room::demon6UseSTricoderOnMetal },
	{ {ACTION_USE, OBJECT_ISTRICOR, OBJECT_IMETEOR, 0}, &Room::demon6UseSTricoderOnMeteor },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::demon6UseSTricoderOnCase },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x23, 0}, &Room::demon6UseSTricoderOnSynthesizer },
	{ {ACTION_GET, 0x20, 0, 0}, &Room::demon6GetCase },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0}, &Room::demon6KirkReachedCase },
};


RoomAction tug0ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::tug0Tick1 },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::tug0LookAtEngineer },
	{ {ACTION_GET, 8, 0, 0}, &Room::tug0GetEngineer },

	{ {ACTION_LOOK, 11, 0, 0}, &Room::tug0LookAtControls },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::tug0LookAtControls },
	{ {ACTION_USE, OBJECT_SPOCK, 0x21, 0}, &Room::tug0UseSpockOnControls },
	{ {ACTION_FINISHED_WALKING, 16, 0, 0}, &Room::tug0SpockReachedControlsToExamine },
	{ {ACTION_FINISHED_ANIMATION, 17, 0, 0}, &Room::tug0SpockExaminedControls },
	{ {ACTION_USE, OBJECT_IRT, 0x21, 0}, &Room::tug0UseTransmogrifierWithoutBitOnControls },
	{ {ACTION_USE, OBJECT_IRTWB, 0x21, 0}, &Room::tug0UseTransmogrifierWithBitOnControls },
	{ {ACTION_FINISHED_WALKING, 6, 0, 0}, &Room::tug0SpockReachedControlsWithTransmogrifier },
	{ {ACTION_FINISHED_ANIMATION, 7, 0, 0}, &Room::tug0SpockFinishedUsingTransmogrifier },
	{ {ACTION_FINISHED_ANIMATION, 22, 0, 0}, &Room::tug0TransporterScreenFullyLit },
	{ {ACTION_USE, OBJECT_IWIRSCRP, 0x21, 0}, &Room::tug0UseWireScrapsOnControls },
	{ {ACTION_USE, OBJECT_IWIRING, 0x21, 0}, &Room::tug0UseWireOnControls },
	{ {ACTION_FINISHED_WALKING, 8, 0, 0}, &Room::tug0SpockReachedControlsWithWire },
	{ {ACTION_FINISHED_ANIMATION, 9, 0, 0}, &Room::tug0SpockFinishedUsingWire },
	{ {ACTION_USE, OBJECT_IMEDKIT, 8, 0}, &Room::tug0UseMedkitOnEngineer },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::tug0MccoyReachedEngineer },
	{ {ACTION_FINISHED_ANIMATION, 13, 0, 0}, &Room::tug0MccoyHealedEngineer },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::tug0EngineerGotUp },
	{ {ACTION_GET, 9, 0, 0}, &Room::tug0GetTransmogrifier },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0}, &Room::tug0KirkReachedToolbox },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::tug0KirkGotTransmogrifier },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::tug0LookAtToolbox },

	{ {ACTION_USE, OBJECT_IPHASERS, OBJECT_IPWE, 0}, &Room::tug0UsePhaserOnWelder },
	{ {ACTION_USE, OBJECT_IPHASERK, OBJECT_IPWE, 0}, &Room::tug0UsePhaserOnWelder },
	{ {ACTION_USE, OBJECT_IPWF, OBJECT_IWIRSCRP, 0}, &Room::tug0UseWelderOnWireScraps },
	{ {ACTION_USE, OBJECT_IPWF, OBJECT_IJNKMETL, 0}, &Room::tug0UseWelderOnMetalScraps },
	{ {ACTION_USE, OBJECT_ICOMBBIT, OBJECT_IRT, 0}, &Room::tug0UseCombBitOnTransmogrifier },

	{ {ACTION_USE, OBJECT_SPOCK, 11, 0}, &Room::tug0UseTransporter },
	{ {ACTION_USE, OBJECT_KIRK, 0x22, 0}, &Room::tug0UseTransporter },
	{ {ACTION_FINISHED_WALKING, 14, 0, 0}, &Room::tug0SpockReachedControlsToTransport },
	{ {ACTION_FINISHED_ANIMATION, 18, 0, 0}, &Room::tug0SpockPreparedTransporter },
	{ {ACTION_FINISHED_WALKING, 20, 0, 0}, &Room::tug0SpockReachedTransporter },
	{ {ACTION_FINISHED_ANIMATION, 21, 0, 0}, &Room::tug0FinishedTransporting },

	{ {ACTION_USE, OBJECT_IBOMB, 0x22, 0}, &Room::tug0UseBombOnTransporter },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0}, &Room::tug0KirkReachedTransporter },
	{ {ACTION_FINISHED_ANIMATION, 10, 0, 0}, &Room::tug0KirkPlacedBomb },
	{ {ACTION_FINISHED_WALKING, 15, 0, 0}, &Room::tug0SpockReachedControlsForBomb },
	{ {ACTION_FINISHED_ANIMATION, 19, 0, 0}, &Room::tug0SpockBeginsBeamingBomb },
	{ {ACTION_FINISHED_ANIMATION, 12, 0, 0}, &Room::tug0SpockFinishesBeamingBomb },
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::tug0BombExploded },

	{ {ACTION_USE, OBJECT_MCCOY, 0x21, 0}, &Room::tug0UseMTricorderOnControls },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x21, 0}, &Room::tug0UseMTricorderOnControls },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::tug0UseSTricorderOnControls },
	{ {ACTION_USE, OBJECT_IMTRICOR, 8, 0}, &Room::tug0UseMTricorderOnEngineer },
	{ {ACTION_FINISHED_WALKING, 24, 0, 0}, &Room::tug0MccoyReachedEngineerToScan },
	{ {ACTION_FINISHED_ANIMATION, 25, 0, 0}, &Room::tug0MccoyFinishedScanningEngineer },
	{ {ACTION_USE, OBJECT_SPOCK, 8, 0}, &Room::tug0UseSTricorderOnEngineer },
	{ {ACTION_USE, OBJECT_ISTRICOR, 8, 0}, &Room::tug0UseSTricorderOnEngineer },
	{ {ACTION_WALK, 0x23, 0, 0}, &Room::tug0WalkToDoor },
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::tug0LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::tug0LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::tug0LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::tug0LookAtRedshirt },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::tug0LookAtTransporter },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::tug0LookAtDoor },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::tug0TalkToKirk },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::tug0TalkToMccoy },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::tug0TalkToSpock },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::tug0TalkToRedshirt },
	{ {ACTION_TALK, 8, 0, 0}, &Room::tug0TalkToEngineer },
	{ {ACTION_USE, OBJECT_ICOMM, 0, 0}, &Room::tug0UseCommunicator },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::tug0LookAnywhere },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::tug0UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0xff, 0}, &Room::tug0UseMTricorderAnywhere },
};


RoomAction tug1ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::tug1Tick1 },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::tug1UseSTricorderOnAnything },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::tug1LookAtBridgeDoor },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::tug1UseSTricorderOnBridgeDoor },
	{ {ACTION_USE, OBJECT_IPHASERS, 0x21, 0}, &Room::tug1UsePhaserOnBridgeDoor },
	{ {ACTION_USE, OBJECT_IPHASERK, 0x21, 0}, &Room::tug1UsePhaserOnBridgeDoor },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0}, &Room::tug1KirkReachedFiringPosition },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::tug1KirkPulledOutPhaser },
	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0}, &Room::tug1KirkFinishedFiringPhaser },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::tug1TalkToSpock },
	{ {ACTION_USE, OBJECT_ISTRICOR, 8, 0}, &Room::tug1UseSTricorderOnJunkPile },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::tug1LookAtJunkPile },
	{ {ACTION_GET, 8, 0, 0}, &Room::tug1GetJunkPile },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::tug1KirkReachedJunkPile },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::tug1KirkFinishedTakingJunkPile },

	{ {ACTION_USE, OBJECT_IPHASERS, OBJECT_IPWE, 0}, &Room::tug1UsePhaserOnWelder },
	{ {ACTION_USE, OBJECT_IPHASERK, OBJECT_IPWE, 0}, &Room::tug1UsePhaserOnWelder },
	{ {ACTION_USE, OBJECT_IPWF, OBJECT_IWIRSCRP, 0}, &Room::tug1UseWelderOnWireScraps },
	{ {ACTION_USE, OBJECT_IPWF, OBJECT_IJNKMETL, 0}, &Room::tug1UseWelderOnMetalScraps },
	{ {ACTION_USE, OBJECT_ICOMBBIT, OBJECT_IRT, 0}, &Room::tug1UseCombBitOnTransmogrifier },

	{ {ACTION_USE, OBJECT_IPWF, 0x22, 0}, &Room::tug1UsePhaserWelderOnBridgeDoor },
	{ {ACTION_USE, OBJECT_IPWF, 0x21, 0}, &Room::tug1UsePhaserWelderOnBridgeDoor },
	{ {ACTION_USE, OBJECT_IPWF, 0x20, 0}, &Room::tug1UsePhaserWelderOnBridgeDoorInLeftSpot },
	{ {ACTION_FINISHED_WALKING, 6, 0, 0}, &Room::tug1KirkReachedBridgeDoorWithWelder },
	{ {ACTION_FINISHED_ANIMATION, 7, 0, 0}, &Room::tug1KirkFinishedUsingWelder },
	{ {ACTION_FINISHED_WALKING, 8, 0, 0}, &Room::tug1KirkReachedBridgeDoorWithWelderInLeftSpot },
	{ {ACTION_FINISHED_ANIMATION, 9, 0, 0}, &Room::tug1KirkFinishedUsingWelderInLeftSpot },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::tug1LookAnywhere },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::tug1LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::tug1LookAtSpock },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::tug1LookAtRedshirt },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::tug1TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::tug1TalkToRedshirt },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::tug1LookAtTerminal },
	{ {ACTION_LOOK, 0x24, 0, 0}, &Room::tug1LookAtDebris },
	{ {ACTION_LOOK, 0x25, 0, 0}, &Room::tug1LookAtBrigDoor },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x25, 0}, &Room::tug1UseSTricorderOnBrigDoor },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::tug1TalkToKirk },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0}, &Room::tug1UseCommunicator },
	{ {ACTION_WALK, 0x21, 0, 0}, &Room::tug1WalkToBridgeDoor },
	{ {ACTION_FINISHED_WALKING, 10, 0, 0}, &Room::tug1KirkReachedBridgeDoor },
	{ {ACTION_FINISHED_ANIMATION, 11, 0, 0}, &Room::tug1BridgeDoorOpened },
	{ {ACTION_WALK, 0x25, 0, 0}, &Room::tug1WalkToBrigDoor },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0xff, 0}, &Room::tug1UseMTricorderAnywhere },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x21, 0}, &Room::tug1UseMTricorderOnBridgeDoor },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x20, 0}, &Room::tug1UseMTricorderOnBridgeDoor },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x22, 0}, &Room::tug1UseMTricorderOnBridgeDoor },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x25, 0}, &Room::tug1UseMTricorderOnBrigDoor },
	{ {ACTION_USE, OBJECT_SPOCK, 0x20, 0}, &Room::tug1UseSpockOnBridgeDoor },
	{ {ACTION_USE, OBJECT_SPOCK, 0x21, 0}, &Room::tug1UseSpockOnBridgeDoor },
	{ {ACTION_USE, OBJECT_SPOCK, 0x22, 0}, &Room::tug1UseSpockOnBridgeDoor },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x20, 0}, &Room::tug1UseRedshirtOnBridgeDoor },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x21, 0}, &Room::tug1UseRedshirtOnBridgeDoor },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x22, 0}, &Room::tug1UseRedshirtOnBridgeDoor },
	{ {ACTION_USE, OBJECT_IMEDKIT, 0x20, 0}, &Room::tug1UseMedkitOnBridgeDoor },
	{ {ACTION_USE, OBJECT_IMEDKIT, 0x21, 0}, &Room::tug1UseMedkitOnBridgeDoor },
	{ {ACTION_USE, OBJECT_IMEDKIT, 0x22, 0}, &Room::tug1UseMedkitOnBridgeDoor },
};


RoomAction tug2ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::tug2Tick1 },
	{ {ACTION_TICK, 60, 0, 0}, &Room::tug2Tick60 },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::tug2LookAtButton },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::tug2LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::tug2LookAtSpock },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::tug2LookAtRedshirt },
	{ {ACTION_GET, 11, 0, 0}, &Room::tug2GetBomb },
	{ {ACTION_FINISHED_WALKING, 12, 0, 0}, &Room::tug2KirkReachedBomb },
	{ {ACTION_FINISHED_ANIMATION, 13, 0, 0}, &Room::tug2KirkGotBomb },
	{ {ACTION_LOOK, 11, 0, 0}, &Room::tug2LookAtBomb },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::tug2LookAtGuard1 },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::tug2LookAtGuard2 },
	{ {ACTION_LOOK, 12, 0, 0}, &Room::tug2LookAtWires },
	{ {ACTION_USE, OBJECT_ISTRICOR, 12, 0}, &Room::tug2UseSTricorderOnButton },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::tug2UseSTricorderOnButton },
	{ {ACTION_USE, OBJECT_MCCOY, 12, 0}, &Room::tug2UseMccoyOnWires },
	{ {ACTION_USE, OBJECT_MCCOY, 11, 0}, &Room::tug2UseMccoyOnBomb },
	{ {ACTION_USE, OBJECT_REDSHIRT, 12, 0}, &Room::tug2UseRedshirtOnWires },
	{ {ACTION_FINISHED_WALKING, 6, 0, 0}, &Room::tug2RedshirtReachedWires },
	{ {ACTION_FINISHED_ANIMATION, 7, 0, 0}, &Room::tug2RedshirtDefusedBomb },
	{ {ACTION_FINISHED_WALKING, 8, 0, 0}, &Room::tug2RedshirtReturnedToPosition },
	{ {ACTION_USE, OBJECT_KIRK, 12, 0}, &Room::tug2UseKirkOnWires },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0}, &Room::tug2KirkReachedWires },
	{ {ACTION_USE, OBJECT_SPOCK, 12, 0}, &Room::tug2UseSpockOnWires },
	{ {ACTION_FINISHED_WALKING, 9, 0, 0}, &Room::tug2SpockReachedWires },
	{ {ACTION_FINISHED_WALKING, 11, 0, 0}, &Room::tug2SpockReturnedToPosition },
	{ {ACTION_GET, 12, 0, 0}, &Room::tug2GetWires },
	{ {ACTION_FINISHED_WALKING, 28, 0, 0}, &Room::tug2KirkReachedWiresToGet },
	{ {ACTION_FINISHED_ANIMATION, 29, 0, 0}, &Room::tug2KirkGotWires },
	{ {ACTION_USE, OBJECT_KIRK, 0x20, 0}, &Room::tug2UseKirkOnButton },
	{ {ACTION_FINISHED_WALKING, 14, 0, 0}, &Room::tug2KirkReachedButton },
	{ {ACTION_USE, OBJECT_SPOCK, 0x20, 0}, &Room::tug2UseSpockOnButton },
	{ {ACTION_FINISHED_WALKING, 16, 0, 0}, &Room::tug2SpockReachedButton },
	{ {ACTION_USE, OBJECT_MCCOY, 0x20, 0}, &Room::tug2UseMccoyOnButton },
	{ {ACTION_FINISHED_WALKING, 18, 0, 0}, &Room::tug2MccoyReachedButton },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x20, 0}, &Room::tug2UseRedshirtOnButton },
	{ {ACTION_FINISHED_WALKING, 20, 0, 0}, &Room::tug2RedshirtReachedButton },
	{ {ACTION_FINISHED_ANIMATION, 15, 0, 0}, &Room::tug2TurnedOffForceField },
	{ {ACTION_FINISHED_ANIMATION, 17, 0, 0}, &Room::tug2TurnedOffForceField },
	{ {ACTION_FINISHED_ANIMATION, 19, 0, 0}, &Room::tug2TurnedOffForceField },
	{ {ACTION_FINISHED_ANIMATION, 21, 0, 0}, &Room::tug2TurnedOffForceField },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::tug2PrisonersDead },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::tug2PrisonersReleased },
	{ {ACTION_USE, OBJECT_IPHASERS, 10, 0}, &Room::tug2UsePhaserOnBrig },
	{ {ACTION_USE, OBJECT_IPHASERK, 10, 0}, &Room::tug2UsePhaserOnBrig },
	{ {ACTION_USE, OBJECT_IPHASERS, 8, 0}, &Room::tug2UseStunPhaserOnGuard1 },
	{ {ACTION_FINISHED_ANIMATION, 22, 0, 0}, &Room::tug2KirkShootGuard1 },
	{ {ACTION_USE, OBJECT_IPHASERS, 9, 0}, &Room::tug2UseStunPhaserOnGuard2 },
	{ {ACTION_FINISHED_ANIMATION, 23, 0, 0}, &Room::tug2KirkShootGuard2 },
	{ {ACTION_USE, OBJECT_IPHASERK, 8, 0}, &Room::tug2UseKillPhaserOnGuard1 },
	{ {ACTION_FINISHED_ANIMATION, 24, 0, 0}, &Room::tug2KirkKillGuard1 },
	{ {ACTION_USE, OBJECT_IPHASERK, 9, 0}, &Room::tug2UseKillPhaserOnGuard2 },
	{ {ACTION_FINISHED_ANIMATION, 25, 0, 0}, &Room::tug2KirkKillGuard2 },

	{ {ACTION_USE, OBJECT_IPHASERS, OBJECT_IPWE, 0}, &Room::tug2UsePhaserOnWelder },
	{ {ACTION_USE, OBJECT_IPHASERK, OBJECT_IPWE, 0}, &Room::tug2UsePhaserOnWelder },
	{ {ACTION_USE, OBJECT_IPWF, OBJECT_IWIRSCRP, 0}, &Room::tug2UseWelderOnWireScraps },
	{ {ACTION_USE, OBJECT_IPWF, OBJECT_IJNKMETL, 0}, &Room::tug2UseWelderOnMetalScraps },
	{ {ACTION_USE, OBJECT_ICOMBBIT, OBJECT_IRT, 0}, &Room::tug2UseCombBitOnTransmogrifier },

	{ {ACTION_FINISHED_ANIMATION, 26, 0, 0}, &Room::tug2ShotByElasi },
	{ {ACTION_FINISHED_ANIMATION, 27, 0, 0}, &Room::tug2ShotByElasi },
	{ {ACTION_WALK, 0x21, 0, 0}, &Room::tug2WalkToDoor },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::tug2LookAtDoor },
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::tug2LookAtKirk },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::tug2TalkToKirk },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::tug2TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::tug2TalkToRedshirt },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::tug2TalkToSpock },
	{ {ACTION_USE, OBJECT_ICOMM, 0, 0}, &Room::tug2UseCommunicator },
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::tug2Timer0Expired },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0}, &Room::tug2Timer2Expired },
	{ {ACTION_USE, OBJECT_ISTRICOR, 11, 0}, &Room::tug2UseSTricorderOnBomb },
	{ {ACTION_USE, OBJECT_IMTRICOR, 8, 0}, &Room::tug2UseMTricorderOnGuard1 },
	{ {ACTION_USE, OBJECT_IMTRICOR, 9, 0}, &Room::tug2UseMTricorderOnGuard2 },
	{ {ACTION_TALK, 8, 0, 0}, &Room::tug2TalkToGuard1 },
	{ {ACTION_TALK, 9, 0, 0}, &Room::tug2TalkToGuard2 },
	{ {ACTION_USE, OBJECT_IMEDKIT, 11, 0}, &Room::tug2UseMedkitOnBomb },
	{ {ACTION_USE, OBJECT_IMEDKIT, 8, 0}, &Room::tug2UseMedkitOnGuard1 },
	{ {ACTION_USE, OBJECT_IMEDKIT, 9, 0}, &Room::tug2UseMedkitOnGuard2 },
	{ {ACTION_LOOK, 10, 0, 0}, &Room::tug2LookAnywhere },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::tug2LookAnywhere },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::tug2LookAnywhere },
	{ {ACTION_TALK, 10, 0, 0}, &Room::tug2TalkToBrig },
	{ {ACTION_USE, OBJECT_IMTRICOR, 10, 0}, &Room::tug2UseMTricorderOnBrig },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x22, 0}, &Room::tug2UseMTricorderOnOpenBrig },
	{ {ACTION_USE, OBJECT_IPHASERS, 0xff, 0}, &Room::tug2UsePhaserAnywhere },
	{ {ACTION_USE, OBJECT_IPHASERK, 0xff, 0}, &Room::tug2UsePhaserAnywhere },
};

RoomAction tug3ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::tug3Tick1 },
	{ {ACTION_TICK, 40, 0, 0}, &Room::tug3Tick40 },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::tug3LookAnywhere },
	{ {ACTION_USE, OBJECT_IPHASERS, 0xff, 0}, &Room::tug3UsePhaserAnywhere },
	{ {ACTION_USE, OBJECT_IPHASERK, 0xff, 0}, &Room::tug3UsePhaserAnywhere },
	{ {ACTION_USE, OBJECT_IPHASERS, 8, 0}, &Room::tug3UseStunPhaserOnElasi1 },
	{ {ACTION_USE, OBJECT_IPHASERS, 9, 0}, &Room::tug3UseStunPhaserOnElasi2 },
	{ {ACTION_USE, OBJECT_IPHASERS, 10, 0}, &Room::tug3UseStunPhaserOnElasi3 },
	{ {ACTION_USE, OBJECT_IPHASERS, 11, 0}, &Room::tug3UseStunPhaserOnElasi4 },
	{ {ACTION_USE, OBJECT_IPHASERK, 8, 0}, &Room::tug3UseKillPhaserOnElasi1 },
	{ {ACTION_USE, OBJECT_IPHASERK, 9, 0}, &Room::tug3UseKillPhaserOnElasi2 },
	{ {ACTION_USE, OBJECT_IPHASERK, 10, 0}, &Room::tug3UseKillPhaserOnElasi3 },
	{ {ACTION_USE, OBJECT_IPHASERK, 11, 0}, &Room::tug3UseKillPhaserOnElasi4 },
	{ {ACTION_FINISHED_ANIMATION, 12, 0, 0}, &Room::tug3ElasiStunnedOrKilled },
	{ {ACTION_TALK, 8, 0, 0}, &Room::tug3TalkToElasi1 },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::tug3Elasi1DrewPhaser },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::tug3Elasi1ShotConsole },
	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0}, &Room::tug3Elasi1DrewPhaser2 },
	{ {ACTION_FINISHED_ANIMATION, 6, 0, 0}, &Room::tug3Elasi1ShotConsoleAndSurrenders },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::tug3LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::tug3LookAtSpock },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::tug3LookAtRedshirt },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::tug3LookAtElasi1 },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::tug3LookAtElasi2 },
	{ {ACTION_LOOK, 10, 0, 0}, &Room::tug3LookAtElasi3 },
	{ {ACTION_LOOK, 11, 0, 0}, &Room::tug3LookAtElasi4 },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::tug3TalkToMccoy },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::tug3TalkToSpock },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::tug3TalkToRedshirt },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0}, &Room::tug3UseCommunicator },
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::tug3Timer0Expired },
	{ {ACTION_FINISHED_ANIMATION, 13, 0, 0}, &Room::tug3AllCrewmenDead },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::tug3Timer1Expired },
	{ {ACTION_FINISHED_ANIMATION, 7, 0, 0}, &Room::tug3SecurityTeamBeamedIn },
};


RoomAction love0ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::love0Tick1 },
	{ {ACTION_TICK, 10, 0, 0}, &Room::love0Tick10 },
	{ {ACTION_WALK, 0x21, 0, 0}, &Room::love0WalkToDoor2 },
	{ {ACTION_WALK, 9, 0, 0}, &Room::love0WalkToDoor2 },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::love0OpenDoor2 },
	{ {ACTION_FINISHED_WALKING, 4, 0, 0}, &Room::love0ReachedDoor2 },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::love0ReachedDoor2 },
	{ {ACTION_WALK, 0x22, 0, 0}, &Room::love0WalkToDoor1 },
	{ {ACTION_WALK, 8, 0, 0}, &Room::love0WalkToDoor1 },
	{ {ACTION_TOUCHED_HOTSPOT, 1, 0, 0}, &Room::love0OpenDoor1 },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0}, &Room::love0ReachedDoor1 },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::love0ReachedDoor1 },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::love0LookAtConsole },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::love0LookAtViewscreen },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::love0LookAnywhere },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::love0LookAtDoor1 },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::love0LookAtDoor2 },
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::love0LookAtKirk },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::love0LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::love0LookAtSpock },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::love0LookAtRedshirt },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::love0TalkToKirk },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::love0TalkToMccoy },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::love0TalkToSpock },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::love0TalkToRedshirt },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0xff, 0}, &Room::love0UseMTricorderAnywhere },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::love0UseSTricorderOnConsole },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::love0UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_KIRK, 0x20, 0}, &Room::love0UseKirkOnConsole },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x20, 0}, &Room::love0UseRedshirtOnConsole },
	{ {ACTION_USE, OBJECT_SPOCK, 0x20, 0}, &Room::love0UseSpockOnConsole },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::love0SpockReachedConsole },
	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0}, &Room::love0SpockAccessedConsole },
	{ {ACTION_USE, OBJECT_MCCOY, 0x20, 0}, &Room::love0UseMccoyOnConsole },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0}, &Room::love0MccoyReachedConsole },
	{ {ACTION_FINISHED_ANIMATION, 6, 0, 0}, &Room::love0MccoyAccessedConsole },
	{ {ACTION_GET,    8, 0, 0}, &Room::love0GetDoorOrConsole },
	{ {ACTION_GET,    9, 0, 0}, &Room::love0GetDoorOrConsole },
	{ {ACTION_GET, 0x20, 0, 0}, &Room::love0GetDoorOrConsole },

	// Common code
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::loveaTimer0Expired },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::loveaTimer1Expired },
	{ {ACTION_USE, OBJECT_IMEDKIT, OBJECT_SPOCK, 0}, &Room::loveaUseMedkitOnSpock },
	{ {ACTION_USE, OBJECT_ISAMPLE, OBJECT_SPOCK, 0}, &Room::loveaUseCureSampleOnSpock },
	{ {ACTION_USE, OBJECT_ICURE, OBJECT_SPOCK, 0}, &Room::loveaUseCureOnSpock },
	{ {ACTION_FINISHED_WALKING,   99, 0, 0}, &Room::loveaSpockOrMccoyInPositionToUseCure },
	{ {ACTION_FINISHED_ANIMATION, 99, 0, 0}, &Room::loveaFinishedCuringSpock },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0}, &Room::loveaTimer2Expired },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_SPOCK, 0}, &Room::loveaUseMTricorderOnSpock },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_KIRK, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_MCCOY, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_REDSHIRT, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IRLG, 0xff, 0}, &Room::loveaUseRomulanLaughingGas },
	{ {ACTION_USE, OBJECT_IN2O, 0xff, 0}, &Room::loveaUseHumanLaughingGas },
	{ {ACTION_USE, OBJECT_INH3, 0xff, 0}, &Room::loveaUseAmmonia },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0}, &Room::loveaUseCommunicator },
};

RoomAction love1ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::love1Tick1 },

	{ {ACTION_WALK, 10, 0, 0}, &Room::love1WalkToDoor3 },
	{ {ACTION_WALK, 0x26, 0, 0}, &Room::love1WalkToDoor3 },
	{ {ACTION_TOUCHED_HOTSPOT, 1, 0, 0}, &Room::love1OpenDoor3 },
	{ {ACTION_FINISHED_WALKING, 15, 0, 0}, &Room::love1ReachedDoor3 },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::love1ReachedDoor3 },

	{ {ACTION_WALK, 8, 0, 0}, &Room::love1WalkToDoor1 },
	{ {ACTION_WALK, 0x27, 0, 0}, &Room::love1WalkToDoor1 },
	{ {ACTION_TOUCHED_HOTSPOT, 2, 0, 0}, &Room::love1OpenDoor1 },
	{ {ACTION_FINISHED_WALKING, 16, 0, 0}, &Room::love1ReachedDoor1 },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::love1ReachedDoor1 },

	{ {ACTION_WALK, 9, 0, 0}, &Room::love1WalkToDoor2 },
	{ {ACTION_WALK, 0x28, 0, 0}, &Room::love1WalkToDoor2 },
	{ {ACTION_TOUCHED_HOTSPOT, 3, 0, 0}, &Room::love1OpenDoor2 },
	{ {ACTION_FINISHED_WALKING, 17, 0, 0}, &Room::love1ReachedDoor2 },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::love1ReachedDoor2 },

	{ {ACTION_LOOK, 0x25, 0, 0}, &Room::love1LookAtLaser },
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::love1LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::love1LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::love1LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::love1LookAtRedshirt },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::love1LookAnywhere },
	{ {ACTION_LOOK, 15, 0, 0}, &Room::love1LookAtNozzle },
	{ {ACTION_LOOK, 0x24, 0, 0}, &Room::love1LookAtNozzle },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::love1LookAtLadder },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::love1LookAtDoor1Or2 },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::love1LookAtDoor1Or2 },
	{ {ACTION_LOOK, 10, 0, 0}, &Room::love1LookAtDoor3 },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::love1LookAtDistillator },
	{ {ACTION_LOOK, 14, 0, 0}, &Room::love1LookAtChamber },
	{ {ACTION_LOOK, 12, 0, 0}, &Room::love1LookAtChamber },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::love1LookAtReplicator },
	{ {ACTION_LOOK, 11, 0, 0}, &Room::love1LookAtFreezer },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::love1LookAtFreezer },
	{ {ACTION_LOOK, OBJECT_IDISHES, 0, 0}, &Room::love1LookAtDishes },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::love1TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::love1TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::love1TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::love1TalkToRedshirt },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_IDISHES, 0}, &Room::love1UseMTricorderOnDishes },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0xff, 0}, &Room::love1UseMTricorderAnywhere },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x23, 0}, &Room::love1UseSTricorderOnReplicator },
	{ {ACTION_USE, OBJECT_ISTRICOR, 12, 0}, &Room::love1UseSTricorderOnReplicator },
	{ {ACTION_USE, OBJECT_SPOCK, 0x25, 0}, &Room::love1UseSTricorderOnLaser },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x25, 0}, &Room::love1UseSTricorderOnLaser },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x22, 0}, &Room::love1UseSTricorderOnFreezer },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::love1UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_ISTRICOR, OBJECT_IDISHES, 0}, &Room::love1UseSTricorderOnDishes },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::love1UseSTricorderOnDistillator },
	{ {ACTION_GET, 11, 0, 0}, &Room::love1GetFreezer },
	{ {ACTION_GET, 0x22, 0, 0}, &Room::love1GetFreezer },
	{ {ACTION_FINISHED_WALKING, 14, 0, 0}, &Room::love1KirkReachedFreezer },
	{ {ACTION_FINISHED_ANIMATION, 9, 0, 0}, &Room::love1KirkGotVirusCulture },
	{ {ACTION_GET, 14, 0, 0}, &Room::love1GetFromChamber },
	{ {ACTION_GET, 12, 0, 0}, &Room::love1GetFromChamber },
	{ {ACTION_GET, 0x23, 0, 0}, &Room::love1GetFromChamber },
	{ {ACTION_FINISHED_WALKING, 8, 0, 0}, &Room::love1KirkReachedChamber },
	{ {ACTION_FINISHED_ANIMATION, 10, 0, 0}, &Room::love1KirkGotCureSample },
	{ {ACTION_GET, 15, 0, 0}, &Room::love1GetFromNozzle },
	{ {ACTION_GET, 0x24, 0, 0}, &Room::love1GetFromNozzle },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::love1KirkReachedNozzleToGet },
	{ {ACTION_FINISHED_ANIMATION, 11, 0, 0}, &Room::love1KirkGotBottleFromNozzle },
	{ {ACTION_USE, OBJECT_IN2O, 0x24, 0}, &Room::love1UseN2OOnNozzle },
	{ {ACTION_USE, OBJECT_IH2O, 0x24, 0}, &Room::love1UseH2OOnNozzle },
	{ {ACTION_USE, OBJECT_INH3, 0x24, 0}, &Room::love1UseNH3OnNozzle },
	{ {ACTION_USE, OBJECT_IRLG, 0x24, 0}, &Room::love1UseRLGOnNozzle },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0}, &Room::love1KirkReachedNozzleToPut },
	{ {ACTION_FINISHED_ANIMATION, 12, 0, 0}, &Room::love1KirkPutBottleInNozzle },
	{ {ACTION_USE, 0xff, 0x24, 0}, &Room::love1UseAnthingOnNozzle },
	{ {ACTION_USE, OBJECT_SPOCK, 0x23, 0}, &Room::love1UseSpockOnReplicator },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x23, 0}, &Room::love1UseRedshirtOnReplicator },
	{ {ACTION_USE, OBJECT_MCCOY, 14, 0}, &Room::love1UseMccoyOnReplicator },
	{ {ACTION_USE, OBJECT_MCCOY, 15, 0}, &Room::love1UseMccoyOnReplicator },
	{ {ACTION_USE, OBJECT_MCCOY, 0x23, 0}, &Room::love1UseMccoyOnReplicator },
	{ {ACTION_FINISHED_WALKING, 4, 0, 0}, &Room::love1MccoyReachedReplicator },
	{ {ACTION_FINISHED_ANIMATION, 13, 0, 0}, &Room::love1MccoyUsedReplicator },
	{ {ACTION_FINISHED_ANIMATION, 7, 0, 0}, &Room::love1ChamberClosed },
	{ {ACTION_FINISHED_ANIMATION, 8, 0, 0}, &Room::love1ChamberOpened },
	{ {ACTION_USE, 0xff, 12, 0}, &Room::love1UseAnythingOnChamber },
	{ {ACTION_USE, OBJECT_IDISHES, 12, 0}, &Room::love1UseDishesOnChamber },
	{ {ACTION_USE, OBJECT_IDISHES, 0x23, 0}, &Room::love1UseDishesOnChamber },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0}, &Room::love1KirkReachedChamberToPut },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::love1ChamberOpenedForDish },
	{ {ACTION_FINISHED_ANIMATION, 14, 0, 0}, &Room::love1KirkPutDishInChamber },
	{ {ACTION_USE, OBJECT_IINSULAT, 0x21, 0}, &Room::love1UseInsulationOnDistillator },
	{ {ACTION_FINISHED_WALKING, 6, 0, 0}, &Room::love1KirkReachedDistillator },
	{ {ACTION_FINISHED_ANIMATION, 15, 0, 0}, &Room::love1KirkGotPolyberylcarbonate },
	{ {ACTION_USE, OBJECT_KIRK, 0x22, 0}, &Room::love1UseKirkOnFreezer },
	{ {ACTION_USE, OBJECT_KIRK, 11, 0}, &Room::love1UseKirkOnFreezer },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x22, 0}, &Room::love1UseRedshirtOnFreezer },
	{ {ACTION_USE, OBJECT_REDSHIRT, 11, 0}, &Room::love1UseRedshirtOnFreezer },
	{ {ACTION_USE, OBJECT_SPOCK, 0x22, 0}, &Room::love1UseSpockOnFreezer },
	{ {ACTION_USE, OBJECT_SPOCK, 11, 0}, &Room::love1UseSpockOnFreezer },
	{ {ACTION_USE, OBJECT_MCCOY, 0x22, 0}, &Room::love1UseMccoyOnFreezer },
	{ {ACTION_USE, OBJECT_MCCOY, 11, 0}, &Room::love1UseMccoyOnFreezer },
	{ {ACTION_FINISHED_WALKING, 7, 0, 0}, &Room::love1CrewmanReachedFreezer },
	{ {ACTION_FINISHED_ANIMATION, 16, 0, 0}, &Room::love1CrewmanOpenedOrClosedFreezer },
	{ {ACTION_USE, 0xff, 0x22, 0}, &Room::love1UseAnythingOnFreezer },
	{ {ACTION_FINISHED_WALKING, 11, 0, 0}, &Room::love1ReachedFreezerWithArbitraryItem },
	{ {ACTION_FINISHED_ANIMATION, 17, 0, 0}, &Room::love1FinishedUsingArbitraryItemOnFreezer },
	{ {ACTION_USE, 0xff, 0x23, 0}, &Room::love1UseAnythingOnReplicator },
	{ {ACTION_FINISHED_WALKING, 12, 0, 0}, &Room::love1ReachedReplicatorWithArbitraryItem },
	{ {ACTION_FINISHED_ANIMATION, 18, 0, 0}, &Room::love1FinishedUsingArbitraryItemOnReplicator },
	{ {ACTION_USE, 0xff, 0x21, 0}, &Room::love1UseAnythingOnDistillator },
	{ {ACTION_FINISHED_WALKING, 13, 0, 0}, &Room::love1ReachedDistillatorWithArbitraryItem },
	{ {ACTION_FINISHED_ANIMATION, 19, 0, 0}, &Room::love1FinishedUsingArbitraryItemOnDistillator },
	{ {ACTION_USE, OBJECT_KIRK, 0x20, 0}, &Room::love1UseKirkOnLadder },
	{ {ACTION_USE, OBJECT_SPOCK, 0x20, 0}, &Room::love1UseSpockOnLadder },
	{ {ACTION_USE, OBJECT_MCCOY, 0x20, 0}, &Room::love1UseMccoyOnLadder },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x20, 0}, &Room::love1UseRedshirtOnLadder },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::love1CrewmanReachedLadder },
	{ {ACTION_FINISHED_ANIMATION, 6, 0, 0}, &Room::love1CrewmanDiedFromPhaser },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::love1TouchedHotspot0 },

	// Common code
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::loveaTimer0Expired },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::loveaTimer1Expired },
	{ {ACTION_USE, OBJECT_IMEDKIT, OBJECT_SPOCK, 0}, &Room::loveaUseMedkitOnSpock },
	{ {ACTION_USE, OBJECT_ISAMPLE, OBJECT_SPOCK, 0}, &Room::loveaUseCureSampleOnSpock },
	{ {ACTION_USE, OBJECT_ICURE, OBJECT_SPOCK, 0}, &Room::loveaUseCureOnSpock },
	{ {ACTION_FINISHED_WALKING,   99, 0, 0}, &Room::loveaSpockOrMccoyInPositionToUseCure },
	{ {ACTION_FINISHED_ANIMATION, 99, 0, 0}, &Room::loveaFinishedCuringSpock },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0}, &Room::loveaTimer2Expired },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_SPOCK, 0}, &Room::loveaUseMTricorderOnSpock },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_KIRK, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_MCCOY, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_REDSHIRT, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IRLG, 0xff, 0}, &Room::loveaUseRomulanLaughingGas },
	{ {ACTION_USE, OBJECT_IN2O, 0xff, 0}, &Room::loveaUseHumanLaughingGas },
	{ {ACTION_USE, OBJECT_INH3, 0xff, 0}, &Room::loveaUseAmmonia },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0}, &Room::loveaUseCommunicator },
};

RoomAction love2ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::love2Tick1 },
	{ {ACTION_TOUCHED_WARP, 1, 0, 0}, &Room::love2TouchedWarp1 },
	{ {ACTION_TIMER_EXPIRED, 3, 0, 0}, &Room::love2Timer3Expired },
	{ {ACTION_WALK, 10, 0, 0}, &Room::love2WalkToDoor },
	{ {ACTION_WALK, 0x22, 0, 0}, &Room::love2WalkToDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::love2TouchedHotspot0 },
	{ {ACTION_FINISHED_WALKING, 14, 0, 0}, &Room::love2DoorReachedOrOpened },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::love2DoorReachedOrOpened },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::love2LookAtCabinet },
	{ {ACTION_LOOK, 10, 0, 0}, &Room::love2LookAtDoor },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::love2LookAtSynthesizer },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::love2LookAtAnywhere },
	{ {ACTION_LOOK, 14, 0, 0}, &Room::love2LookAtAntigrav },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::love2LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::love2LookAtSpock },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::love2LookAtRedshirt },
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::love2LookAtKirk },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::love2LookAtArdak },
	{ {ACTION_LOOK, 15, 0, 0}, &Room::love2LookAtChamber },
	{ {ACTION_LOOK, 16, 0, 0}, &Room::love2LookAtChamber },
	{ {ACTION_LOOK, 18, 0, 0}, &Room::love2LookAtChamber },
	{ {ACTION_LOOK, 19, 0, 0}, &Room::love2LookAtChamber },
	{ {ACTION_LOOK, 17, 0, 0}, &Room::love2LookAtChamber },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::love2LookAtChamber },
	{ {ACTION_LOOK, 12, 0, 0}, &Room::love2LookAtCan1 },
	{ {ACTION_LOOK, 13, 0, 0}, &Room::love2LookAtCan2 },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::love2TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::love2TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::love2TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::love2TalkToRedshirt },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0xff, 0}, &Room::love2UseMTricorderAnywhere },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::love2UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_KIRK, 8, 0}, &Room::love2UseKirkOnCabinet },
	{ {ACTION_USE, OBJECT_SPOCK, 8, 0}, &Room::love2UseSpockOnCabinet },
	{ {ACTION_USE, OBJECT_MCCOY, 8, 0}, &Room::love2UseMccoyOnCabinet },
	{ {ACTION_USE, OBJECT_REDSHIRT, 8, 0}, &Room::love2UseRedshirtOnCabinet },
	{ {ACTION_FINISHED_WALKING, 12, 0, 0}, &Room::love2CrewmanReachedCabinet },
	{ {ACTION_FINISHED_ANIMATION, 11, 0, 0}, &Room::love2CrewmanAccessedCabinet },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::love2CrewmanOpenedOrClosedCabinet },
	{ {ACTION_USE, OBJECT_IWRENCH, 11, 0}, &Room::love2UseWrenchOnGasFeed },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::love2ReachedGasFeed },
	{ {ACTION_FINISHED_ANIMATION, 12, 0, 0}, &Room::love2ChangedGasFeed },
	{ {ACTION_USE, OBJECT_IO2GAS, 0x23, 0}, &Room::love2UseO2GasOnCanisterSlot },
	{ {ACTION_USE, OBJECT_IH2GAS, 0x23, 0}, &Room::love2UseH2GasOnCanisterSlot },
	{ {ACTION_USE, OBJECT_IN2GAS, 0x23, 0}, &Room::love2UseN2GasOnCanisterSlot },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0}, &Room::love2ReachedCanisterSlot },
	{ {ACTION_FINISHED_ANIMATION, 13, 0, 0}, &Room::love2PutCanisterInSlot1 },
	{ {ACTION_FINISHED_ANIMATION, 14, 0, 0}, &Room::love2PutCanisterInSlot2 },
	{ {ACTION_USE, OBJECT_IANTIGRA, 12, 0}, &Room::love2UseAntigravOnCanister1 },
	{ {ACTION_FINISHED_WALKING, 4, 0, 0}, &Room::love2ReachedCanisterSlot1ToGet },
	{ {ACTION_FINISHED_ANIMATION, 15, 0, 0}, &Room::love2TookCanister1 },
	{ {ACTION_USE, OBJECT_IANTIGRA, 13, 0}, &Room::love2UseAntigravOnCanister2 },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0}, &Room::love2ReachedCanisterSlot2ToGet },
	{ {ACTION_FINISHED_ANIMATION, 16, 0, 0}, &Room::love2TookCanister2 },
	{ {ACTION_USE, OBJECT_KIRK, 0x20, 0}, &Room::love2UseKirkOnSynthesizer },
	{ {ACTION_USE, OBJECT_SPOCK, 0x20, 0}, &Room::love2UseSpockOnSynthesizer },
	{ {ACTION_USE, OBJECT_MCCOY, 0x20, 0}, &Room::love2UseMccoyOnSynthesizer },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x20, 0}, &Room::love2UseRedshirtOnSynthesizer },
	{ {ACTION_FINISHED_WALKING, 13, 0, 0}, &Room::love2CrewmanReachedSynthesizer },
	{ {ACTION_FINISHED_ANIMATION, 17, 0, 0}, &Room::love2CrewmanUsedSynthesizer },
	{ {ACTION_FINISHED_WALKING, 16, 0, 0}, &Room::love2SpockReachedGasFeeds },
	{ {ACTION_FINISHED_ANIMATION, 18, 0, 0}, &Room::love2SpockEnabledGasFeeds },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::love2SynthesizerDoorClosed },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::love2SynthesizerFinished },
	{ {ACTION_FINISHED_ANIMATION, 27, 0, 0}, &Room::love2ClosedSynthesizerDoorMakingRLG },
	{ {ACTION_FINISHED_ANIMATION, 8, 0, 0}, &Room::love2ClosedSynthesizerDoorMakingCure },
	{ {ACTION_FINISHED_ANIMATION, 9, 0, 0}, &Room::love2CureStartedSynthesizing },
	{ {ACTION_FINISHED_ANIMATION, 10, 0, 0}, &Room::love2CureSynthesized },
	{ {ACTION_USE, OBJECT_IPBC, 9, 0}, &Room::love2UsePolyberylcarbonateOnSynthesizerDoor },
	{ {ACTION_FINISHED_WALKING, 6, 0, 0}, &Room::love2KirkReachedSynthesizerWithPolyberylcarbonate },
	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0}, &Room::love2SynthesizerDoorOpenedWithPolyberylcarbonate },
	{ {ACTION_FINISHED_ANIMATION, 19, 0, 0}, &Room::love2PutPolyberylcarbonateInSynthesizer },

	{ {ACTION_USE, OBJECT_IDISHES, 9, 0}, &Room::love2UseVirusSampleOnSynthesizerDoor },
	{ {ACTION_FINISHED_WALKING, 7, 0, 0}, &Room::love2KirkReachedSynthesizerWithVirusSample },
	{ {ACTION_FINISHED_ANIMATION, 6, 0, 0}, &Room::love2SynthesizerDoorOpenedWithVirusSample },
	{ {ACTION_FINISHED_ANIMATION, 20, 0, 0}, &Room::love2PutVirusSampleInSynthesizer },

	{ {ACTION_USE, OBJECT_ISAMPLE, 9, 0}, &Room::love2UseCureSampleOnSynthesizerDoor },
	{ {ACTION_FINISHED_WALKING, 8, 0, 0}, &Room::love2KirkReachedSynthesizerWithCureSample },
	{ {ACTION_FINISHED_ANIMATION, 7, 0, 0}, &Room::love2SynthesizerDoorOpenedWithCureSample },
	{ {ACTION_FINISHED_ANIMATION, 21, 0, 0}, &Room::love2PutCureSampleInSynthesizer },

	{ {ACTION_USE, 0xff, 9, 0}, &Room::love2UseAnythingOnSynthesizerDoor },
	{ {ACTION_USE, 0xff, 0x20, 0}, &Room::love2UseAnythingOnSynthesizer },
	{ {ACTION_GET, 13, 0, 0}, &Room::love2GetCanister },
	{ {ACTION_GET, 12, 0, 0}, &Room::love2GetCanister },

	{ {ACTION_GET, 14, 0, 0}, &Room::love2GetAntigrav },
	{ {ACTION_FINISHED_WALKING, 9, 0, 0}, &Room::love2ReachedAntigrav },
	{ {ACTION_FINISHED_ANIMATION, 22, 0, 0}, &Room::love2GotAntigrav },

	{ {ACTION_GET, 16, 0, 0}, &Room::love2GetPolyberylcarbonate },
	{ {ACTION_FINISHED_WALKING, 18, 0, 0}, &Room::love2ReachedPolyberylcarbonate },
	{ {ACTION_FINISHED_ANIMATION, 26, 0, 0}, &Room::love2GotPolyberylcarbonate },

	{ {ACTION_GET, 17, 0, 0}, &Room::love2GetDishes },
	{ {ACTION_FINISHED_WALKING, 17, 0, 0}, &Room::love2ReachedDishes },
	{ {ACTION_FINISHED_ANIMATION, 25, 0, 0}, &Room::love2GotDishes },

	{ {ACTION_GET, 18, 0, 0}, &Room::love2GetSample },
	{ {ACTION_FINISHED_WALKING, 19, 0, 0}, &Room::love2ReachedSample },
	{ {ACTION_FINISHED_ANIMATION, 28, 0, 0}, &Room::love2GotSample },

	{ {ACTION_GET, 15, 0, 0}, &Room::love2GetSynthesizerOutput },
	{ {ACTION_FINISHED_WALKING, 10, 0, 0}, &Room::love2ReachedSynthesizerOutput },
	{ {ACTION_FINISHED_ANIMATION, 23, 0, 0}, &Room::love2GotSynthesizerOutput },

	{ {ACTION_GET, 19, 0, 0}, &Room::love2GetCure },
	{ {ACTION_FINISHED_WALKING, 11, 0, 0}, &Room::love2ReachedCure },
	{ {ACTION_FINISHED_ANIMATION, 24, 0, 0}, &Room::love2GotCure },

	// Common code
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::loveaTimer0Expired },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::loveaTimer1Expired },
	{ {ACTION_USE, OBJECT_IMEDKIT, OBJECT_SPOCK, 0}, &Room::loveaUseMedkitOnSpock },
	{ {ACTION_USE, OBJECT_ISAMPLE, OBJECT_SPOCK, 0}, &Room::loveaUseCureSampleOnSpock },
	{ {ACTION_USE, OBJECT_ICURE, OBJECT_SPOCK, 0}, &Room::loveaUseCureOnSpock },
	{ {ACTION_FINISHED_WALKING,   99, 0, 0}, &Room::loveaSpockOrMccoyInPositionToUseCure },
	{ {ACTION_FINISHED_ANIMATION, 99, 0, 0}, &Room::loveaFinishedCuringSpock },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0}, &Room::loveaTimer2Expired },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_SPOCK, 0}, &Room::loveaUseMTricorderOnSpock },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_KIRK, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_MCCOY, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_REDSHIRT, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IRLG, 0xff, 0}, &Room::loveaUseRomulanLaughingGas },
	{ {ACTION_USE, OBJECT_IN2O, 0xff, 0}, &Room::loveaUseHumanLaughingGas },
	{ {ACTION_USE, OBJECT_INH3, 0xff, 0}, &Room::loveaUseAmmonia },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0}, &Room::loveaUseCommunicator },
};

RoomAction love3ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::love3Tick1 },
	{ {ACTION_TICK, 80, 0, 0}, &Room::love3Tick80 },
	{ {ACTION_TOUCHED_WARP, 1, 0, 0}, &Room::love3TouchedWarp1 },
	{ {ACTION_TIMER_EXPIRED, 3, 0, 0}, &Room::love3Timer3Expired },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::love3LookAtServicePanel },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::love3LookAtMonitor },
	{ {ACTION_LOOK, 10, 0, 0}, &Room::love3LookAtWrench },
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::love3LookAtKirk },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::love3LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::love3LookAtSpock },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::love3LookAtRedshirt },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::love3LookAnywhere },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::love3LookAtShaft },
	{ {ACTION_LOOK, 11, 0, 0}, &Room::love3LookAtGrate },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::love3LookAtPanel },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::love3LookAtPanel },
	{ {ACTION_LOOK, 12, 0, 0}, &Room::love3LookAtGasTank },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::love3LookAtTurbines },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::love3TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::love3TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::love3TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::love3TalkToRedshirt },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0xff, 0}, &Room::love3UseMTricorderAnywhere },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x23, 0}, &Room::love3UseSTricorderOnTurbines },
	{ {ACTION_USE, OBJECT_ISTRICOR, 9, 0}, &Room::love3UseSTricorderOnInsulation },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::love3UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_KIRK, 8, 0}, &Room::love3UseKirkOnServicePanel },
	{ {ACTION_USE, OBJECT_SPOCK, 8, 0}, &Room::love3UseSpockOnServicePanel },
	{ {ACTION_USE, OBJECT_MCCOY, 8, 0}, &Room::love3UseMccoyOnServicePanel },
	{ {ACTION_USE, OBJECT_REDSHIRT, 8, 0}, &Room::love3UseRedshirtOnServicePanel },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::love3CrewmanReachedServicePanel },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::love3OpenedOrClosedServicePanel },

	{ {ACTION_USE, OBJECT_IWRENCH, 12, 0}, &Room::love3UseWrenchOnGasTank },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::love3ReachedGasTankToUnscrew },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::love3ScrewedOrUnscrewedGasTank },

	{ {ACTION_USE, OBJECT_IWRENCH, OBJECT_IO2GAS, 0}, &Room::love3UseWrenchOnO2OrH2Gas },
	{ {ACTION_USE, OBJECT_IWRENCH, OBJECT_IH2GAS, 0}, &Room::love3UseWrenchOnO2OrH2Gas },

	{ {ACTION_USE, OBJECT_IWRENCH, OBJECT_IN2GAS, 0}, &Room::love3UseWrenchOnN2Gas },
	{ {ACTION_FINISHED_WALKING, 15, 0, 0}, &Room::love3ReachedGasTankToPutDown },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::love3PutN2TankBack },

	{ {ACTION_USE, OBJECT_IWRENCH, 0x20, 0}, &Room::love3UseWrenchOnEngineeringPanel },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0}, &Room::love3ReachedEngineeringPanel },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::love3OpenedEngineeringPanel },

	{ {ACTION_USE, OBJECT_IWRENCH, 0x21, 0}, &Room::love3UseWrenchOnMonitor },

	{ {ACTION_USE, OBJECT_IH2O, 0x21, 0}, &Room::love3UseWaterOnMonitor },
	{ {ACTION_FINISHED_WALKING, 14, 0, 0}, &Room::love3ReachedMonitorToUseWater },
	{ {ACTION_FINISHED_ANIMATION, 6, 0, 0}, &Room::love3PouredWaterOnMonitor },

	{ {ACTION_USE, OBJECT_KIRK, 0x20, 0}, &Room::love3UseCrewmanOnEngineeringPanelOrGrate },
	{ {ACTION_USE, OBJECT_SPOCK, 0x20, 0}, &Room::love3UseCrewmanOnEngineeringPanelOrGrate },
	{ {ACTION_USE, OBJECT_MCCOY, 0x20, 0}, &Room::love3UseCrewmanOnEngineeringPanelOrGrate },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x20, 0}, &Room::love3UseCrewmanOnEngineeringPanelOrGrate },
	{ {ACTION_USE, OBJECT_KIRK, 11, 0}, &Room::love3UseCrewmanOnEngineeringPanelOrGrate },
	{ {ACTION_USE, OBJECT_SPOCK, 11, 0}, &Room::love3UseCrewmanOnEngineeringPanelOrGrate },
	{ {ACTION_USE, OBJECT_MCCOY, 11, 0}, &Room::love3UseCrewmanOnEngineeringPanelOrGrate },
	{ {ACTION_USE, OBJECT_REDSHIRT, 11, 0}, &Room::love3UseCrewmanOnEngineeringPanelOrGrate },

	{ {ACTION_USE, OBJECT_IWRENCH, 11, 0}, &Room::love3UseWrenchOnGrate },
	{ {ACTION_FINISHED_WALKING, 4, 0, 0}, &Room::love3ReachedGateWithWrench },
	{ {ACTION_FINISHED_ANIMATION, 7, 0, 0}, &Room::love3OpenedOrClosedGrate },

	{ {ACTION_USE, OBJECT_KIRK, 0x22, 0}, &Room::love3UseCrewmanOnShaft },
	{ {ACTION_USE, OBJECT_SPOCK, 0x22, 0}, &Room::love3UseCrewmanOnShaft },
	{ {ACTION_USE, OBJECT_MCCOY, 0x22, 0}, &Room::love3UseCrewmanOnShaft },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x22, 0}, &Room::love3UseCrewmanOnShaft },

	{ {ACTION_USE, OBJECT_IH2O, 0x22, 0}, &Room::love3UseWaterOnShaft },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0}, &Room::love3ReachedShaftUsingWater },
	{ {ACTION_FINISHED_ANIMATION, 8, 0, 0}, &Room::love3PouredWaterDownShaft },

	{ {ACTION_USE, OBJECT_IN2O, 0x22, 0}, &Room::love3UseNitrousOxideOnShaft },
	{ {ACTION_FINISHED_WALKING, 6, 0, 0}, &Room::love3ReachedShaftUsingNitrousOxide },
	{ {ACTION_FINISHED_ANIMATION, 9, 0, 0}, &Room::love3PouredNitrousOxideDownShaft },

	{ {ACTION_USE, OBJECT_INH3, 0x22, 0}, &Room::love3UseAmmoniaOnShaft },
	{ {ACTION_FINISHED_WALKING, 7, 0, 0}, &Room::love3ReachedShaftUsingAmmonia },
	{ {ACTION_FINISHED_ANIMATION, 10, 0, 0}, &Room::love3PouredAmmoniaDownShaft },

	{ {ACTION_USE, OBJECT_IRLG, 0x22, 0}, &Room::love3UseRomulanLaughingGasOnShaft },
	{ {ACTION_FINISHED_WALKING, 8, 0, 0}, &Room::love3ReachedShaftUsingRomulanLaughingGas },
	{ {ACTION_FINISHED_ANIMATION, 11, 0, 0}, &Room::love3PouredRomulanLaughingGasDownShaft },

	{ {ACTION_GET, 10, 0, 0}, &Room::love3GetWrench },
	{ {ACTION_FINISHED_WALKING, 9, 0, 0}, &Room::love3ReachedWrenchToGet },
	{ {ACTION_FINISHED_ANIMATION, 12, 0, 0}, &Room::love3PickedUpWrench },

	{ {ACTION_GET, 12, 0, 0}, &Room::love3GetGasTank },
	{ {ACTION_FINISHED_WALKING, 10, 0, 0}, &Room::love3ReachedGasTankToGet },

	{ {ACTION_USE, OBJECT_IANTIGRA, 12, 0}, &Room::love3UseAntigravOnGasTank },
	{ {ACTION_FINISHED_WALKING, 11, 0, 0}, &Room::love3ReachedGasTankUsingAntigrav },
	{ {ACTION_FINISHED_ANIMATION, 13, 0, 0}, &Room::love3PickedUpGasTank },

	{ {ACTION_GET, 9, 0, 0}, &Room::love3GetInsulation },
	{ {ACTION_FINISHED_WALKING, 12, 0, 0}, &Room::love3ReachedInsulationToGet },
	{ {ACTION_FINISHED_ANIMATION, 14, 0, 0}, &Room::love3PickedUpInsulation },

	// Common code
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::loveaTimer0Expired },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::loveaTimer1Expired },
	{ {ACTION_USE, OBJECT_IMEDKIT, OBJECT_SPOCK, 0}, &Room::loveaUseMedkitOnSpock },
	{ {ACTION_USE, OBJECT_ISAMPLE, OBJECT_SPOCK, 0}, &Room::loveaUseCureSampleOnSpock },
	{ {ACTION_USE, OBJECT_ICURE, OBJECT_SPOCK, 0}, &Room::loveaUseCureOnSpock },
	{ {ACTION_FINISHED_WALKING,   99, 0, 0}, &Room::loveaSpockOrMccoyInPositionToUseCure },
	{ {ACTION_FINISHED_ANIMATION, 99, 0, 0}, &Room::loveaFinishedCuringSpock },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0}, &Room::loveaTimer2Expired },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_SPOCK, 0}, &Room::loveaUseMTricorderOnSpock },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_KIRK, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_MCCOY, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_REDSHIRT, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IRLG, 0xff, 0}, &Room::loveaUseRomulanLaughingGas },
	{ {ACTION_USE, OBJECT_IN2O, 0xff, 0}, &Room::loveaUseHumanLaughingGas },
	{ {ACTION_USE, OBJECT_INH3, 0xff, 0}, &Room::loveaUseAmmonia },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0}, &Room::loveaUseCommunicator },
};

RoomAction love4ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::love4Tick1 },
	{ {ACTION_TICK, 10, 0, 0}, &Room::love4Tick10 },

	{ {ACTION_WALK, 8, 0, 0}, &Room::love4WalkToDoor },
	{ {ACTION_WALK, 0x20, 0, 0}, &Room::love4WalkToDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::love4TouchedHotspot0 },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0}, &Room::love4DoorOpenedOrReached },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::love4DoorOpenedOrReached },

	{ {ACTION_USE, OBJECT_KIRK, 0x21, 0}, &Room::love4UseKirkOnLadder },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0}, &Room::love4ReachedLadder },
	{ {ACTION_USE, OBJECT_IPHASERS,  9, 0}, &Room::love4UseStunPhaserOnRomulan },
	{ {ACTION_USE, OBJECT_IPHASERS, 10, 0}, &Room::love4UseStunPhaserOnRomulan },
	{ {ACTION_USE, OBJECT_IPHASERS, 11, 0}, &Room::love4UseStunPhaserOnRomulan },
	{ {ACTION_USE, OBJECT_IPHASERS, 12, 0}, &Room::love4UseStunPhaserOnRomulan },
	// NOTE: nothing for OBJECT_IPHASERK. There's an unused audio file which might fit.
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::love4LookAnywhere },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::love4LookAtLadder },
	{ {ACTION_LOOK, 8, 0, 0}, &Room::love4LookAtDoor },
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::love4LookAtKirk },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::love4LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::love4LookAtSpock },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::love4LookAtRedshirt },
	{ {ACTION_LOOK,  9, 0, 0}, &Room::love4LookAtRomulan },
	{ {ACTION_LOOK, 10, 0, 0}, &Room::love4LookAtRomulan },
	{ {ACTION_LOOK, 11, 0, 0}, &Room::love4LookAtRomulan },
	{ {ACTION_LOOK, 12, 0, 0}, &Room::love4LookAtRomulan },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::love4TalkToKirk },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::love4TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::love4TalkToRedshirt },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::love4TalkToSpock },
	{ {ACTION_TALK,  9, 0, 0}, &Room::love4TalkToRomulan },
	{ {ACTION_TALK, 10, 0, 0}, &Room::love4TalkToRomulan },
	{ {ACTION_TALK, 11, 0, 0}, &Room::love4TalkToRomulan },
	{ {ACTION_TALK, 12, 0, 0}, &Room::love4TalkToRomulan },
	{ {ACTION_USE, OBJECT_IMTRICOR,  9, 0}, &Room::love4UseMTricorderOnRomulan },
	{ {ACTION_USE, OBJECT_IMTRICOR, 10, 0}, &Room::love4UseMTricorderOnRomulan },
	{ {ACTION_USE, OBJECT_IMTRICOR, 11, 0}, &Room::love4UseMTricorderOnRomulan },
	{ {ACTION_USE, OBJECT_IMTRICOR, 12, 0}, &Room::love4UseMTricorderOnRomulan },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0xff, 0}, &Room::love4UseMTricorderAnywhere },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::love4UseSTricorderAnywhere },

	{ {ACTION_USE, OBJECT_ICURE,  9, 0}, &Room::love4UseCureOnRomulan },
	{ {ACTION_USE, OBJECT_ICURE, 10, 0}, &Room::love4UseCureOnRomulan },
	{ {ACTION_USE, OBJECT_ICURE, 11, 0}, &Room::love4UseCureOnRomulan },
	{ {ACTION_USE, OBJECT_ICURE, 12, 0}, &Room::love4UseCureOnRomulan },
	{ {ACTION_FINISHED_WALKING,   3, 0, 0}, &Room::love4MccoyReachedRomulan4 },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::love4MccoyCuredRomulan4 },
	{ {ACTION_FINISHED_WALKING,   4, 0, 0}, &Room::love4MccoyReachedRomulan3 },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::love4MccoyCuredRomulan3 },
	{ {ACTION_FINISHED_WALKING,   5, 0, 0}, &Room::love4MccoyReachedRomulan2 },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::love4MccoyCuredRomulan2 },
	{ {ACTION_FINISHED_WALKING,   6, 0, 0}, &Room::love4MccoyReachedRomulan1 },
	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0}, &Room::love4MccoyCuredRomulan1 },

	{ {ACTION_USE, OBJECT_IH2O,   9, 0}, &Room::love4UseWaterOnRomulan },
	{ {ACTION_USE, OBJECT_IH2O,  10, 0}, &Room::love4UseWaterOnRomulan },
	{ {ACTION_USE, OBJECT_IH2O,  11, 0}, &Room::love4UseWaterOnRomulan },
	{ {ACTION_USE, OBJECT_IH2O,  12, 0}, &Room::love4UseWaterOnRomulan },
	{ {ACTION_USE, OBJECT_IMEDKIT,  9, 0}, &Room::love4UseMedkitOnRomulan },
	{ {ACTION_USE, OBJECT_IMEDKIT, 10, 0}, &Room::love4UseMedkitOnRomulan },
	{ {ACTION_USE, OBJECT_IMEDKIT, 11, 0}, &Room::love4UseMedkitOnRomulan },
	{ {ACTION_USE, OBJECT_IMEDKIT, 12, 0}, &Room::love4UseMedkitOnRomulan },
	{ {ACTION_USE, OBJECT_ISAMPLE,  9, 0}, &Room::love4UseCureSampleOnRomulan },
	{ {ACTION_USE, OBJECT_ISAMPLE, 10, 0}, &Room::love4UseCureSampleOnRomulan },
	{ {ACTION_USE, OBJECT_ISAMPLE, 11, 0}, &Room::love4UseCureSampleOnRomulan },
	{ {ACTION_USE, OBJECT_ISAMPLE, 12, 0}, &Room::love4UseCureSampleOnRomulan },
	{ {ACTION_USE, 0xff,  9, 0}, &Room::love4UseAnythingOnRomulan },
	{ {ACTION_USE, 0xff, 10, 0}, &Room::love4UseAnythingOnRomulan },
	{ {ACTION_USE, 0xff, 11, 0}, &Room::love4UseAnythingOnRomulan },
	{ {ACTION_USE, 0xff, 12, 0}, &Room::love4UseAnythingOnRomulan },

	// Common code
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::loveaTimer0Expired },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::loveaTimer1Expired },
	{ {ACTION_USE, OBJECT_IMEDKIT, OBJECT_SPOCK, 0}, &Room::loveaUseMedkitOnSpock },
	{ {ACTION_USE, OBJECT_ISAMPLE, OBJECT_SPOCK, 0}, &Room::loveaUseCureSampleOnSpock },
	{ {ACTION_USE, OBJECT_ICURE, OBJECT_SPOCK, 0}, &Room::loveaUseCureOnSpock },
	{ {ACTION_FINISHED_WALKING,   99, 0, 0}, &Room::loveaSpockOrMccoyInPositionToUseCure },
	{ {ACTION_FINISHED_ANIMATION, 99, 0, 0}, &Room::loveaFinishedCuringSpock },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0}, &Room::loveaTimer2Expired },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_SPOCK, 0}, &Room::loveaUseMTricorderOnSpock },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_KIRK, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_MCCOY, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_REDSHIRT, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IRLG, 0xff, 0}, &Room::loveaUseRomulanLaughingGas },
	{ {ACTION_USE, OBJECT_IN2O, 0xff, 0}, &Room::loveaUseHumanLaughingGas },
	{ {ACTION_USE, OBJECT_INH3, 0xff, 0}, &Room::loveaUseAmmonia },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0}, &Room::loveaUseCommunicator },
};

RoomAction love5ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::love5Tick1 },
	{ {ACTION_TOUCHED_WARP, 1, 0, 0}, &Room::love5TouchedWarp1 },
	{ {ACTION_TIMER_EXPIRED, 4, 0, 0}, &Room::love5Timer4Expired },
	{ {ACTION_USE, OBJECT_IPHASERS, 9, 0}, &Room::love5UseStunPhaserOnPreax },
	// NOTE: nothing for OBJECT_IPHASERK. There's an unused audio file which might fit.
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0}, &Room::love5LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0}, &Room::love5LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0}, &Room::love5LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::love5LookAtRedshirt },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::love5LookAnywhere },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::love5LookAtDevice },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::love5LookAtConsole },
	{ {ACTION_LOOK, 10, 0, 0}, &Room::love5LookAtDrMarcus },
	{ {ACTION_LOOK, 11, 0, 0}, &Room::love5LookAtDrCheever },
	{ {ACTION_LOOK, 9, 0, 0}, &Room::love5LookAtPreax },
	{ {ACTION_TALK, 9, 0, 0}, &Room::love5TalkToPreax },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0}, &Room::love5MccoyReachedSpockToCure },
	{ {ACTION_FINISHED_ANIMATION, 6, 0, 0}, &Room::love5MccoyCuredSpock },
	{ {ACTION_FINISHED_WALKING, 6, 0, 0}, &Room::love5CrewmanReachedBeamoutPosition },
	{ {ACTION_TALK, 10, 0, 0}, &Room::love5TalkToDrMarcus },
	{ {ACTION_TALK, 11, 0, 0}, &Room::love5TalkToDrCheever },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0}, &Room::love5TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0}, &Room::love5TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0}, &Room::love5TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::love5TalkToRedshirt },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::love5UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::love5UseSTricorderOnDevice },
	{ {ACTION_USE, OBJECT_IMTRICOR, 10, 0}, &Room::love5UseMTricorderOnMarcusOrCheever },
	{ {ACTION_USE, OBJECT_IMTRICOR, 11, 0}, &Room::love5UseMTricorderOnMarcusOrCheever },
	{ {ACTION_USE, OBJECT_IMTRICOR, 9, 0}, &Room::love5UseMTricorderOnPreax },
	{ {ACTION_USE, OBJECT_IMEDKIT, 9, 0}, &Room::love5UseMedkitOnPreax },
	{ {ACTION_USE, OBJECT_IH2O, 9, 0}, &Room::love5UseWaterOnPreax },
	{ {ACTION_USE, OBJECT_ISAMPLE, 9, 0}, &Room::love5UseCureSampleOnPreax },
	{ {ACTION_USE, OBJECT_ICURE, 9, 0}, &Room::love5UseCureOnPreax },
	{ {ACTION_FINISHED_WALKING, 4, 0, 0}, &Room::love5ReachedPreaxUsingCure },
	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0}, &Room::love5CuredPreax },
	{ {ACTION_USE, 0xff, 9, 0}, &Room::love5UseAnythingOnPreax },
	{ {ACTION_USE, OBJECT_KIRK, 10, 0}, &Room::love5UseKirkOnMarcusOrCheever },
	{ {ACTION_USE, OBJECT_KIRK, 11, 0}, &Room::love5UseKirkOnMarcusOrCheever },
	{ {ACTION_FINISHED_WALKING,   1, 0, 0}, &Room::love5KirkReachedCheever },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::love5KirkUntiedCheever },
	{ {ACTION_FINISHED_WALKING,   2, 0, 0}, &Room::love5KirkReachedMarcus },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::love5KirkUntiedMarcus },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::love5MarcusStoodUp },

	// Common code
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0}, &Room::loveaTimer0Expired },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::loveaTimer1Expired },
	{ {ACTION_USE, OBJECT_IMEDKIT, OBJECT_SPOCK, 0}, &Room::loveaUseMedkitOnSpock },
	{ {ACTION_USE, OBJECT_ISAMPLE, OBJECT_SPOCK, 0}, &Room::loveaUseCureSampleOnSpock },
	{ {ACTION_USE, OBJECT_ICURE, OBJECT_SPOCK, 0}, &Room::loveaUseCureOnSpock },
	{ {ACTION_FINISHED_WALKING,   99, 0, 0}, &Room::loveaSpockOrMccoyInPositionToUseCure },
	{ {ACTION_FINISHED_ANIMATION, 99, 0, 0}, &Room::loveaFinishedCuringSpock },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0}, &Room::loveaTimer2Expired },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_SPOCK, 0}, &Room::loveaUseMTricorderOnSpock },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_KIRK, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_MCCOY, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IMTRICOR, OBJECT_REDSHIRT, 0}, &Room::loveaUseMTricorderOnHuman },
	{ {ACTION_USE, OBJECT_IRLG, 0xff, 0}, &Room::loveaUseRomulanLaughingGas },
	{ {ACTION_USE, OBJECT_IN2O, 0xff, 0}, &Room::loveaUseHumanLaughingGas },
	{ {ACTION_USE, OBJECT_INH3, 0xff, 0}, &Room::loveaUseAmmonia },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0}, &Room::loveaUseCommunicator },
};

RoomAction mudd0ActionList[] = {
	{ {ACTION_TICK,  1, 0, 0}, &Room::mudd0Tick1 },
	{ {ACTION_TICK, 50, 0, 0}, &Room::mudd0Tick50 },
	{ {ACTION_TICK, 60, 0, 0}, &Room::mudd0Tick60 },
	{ {ACTION_USE, OBJECT_IPHASERS, 8, 0}, &Room::mudd0UsePhaserOnMudd },
	{ {ACTION_USE, OBJECT_IPHASERK, 8, 0}, &Room::mudd0UsePhaserOnMudd },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0}, &Room::mudd0UseCommunicator },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::mudd0LookAtFoodBox },
	{ {ACTION_LOOK, 0x24, 0, 0}, &Room::mudd0LookAtComponentBox },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::mudd0LookAnywhere },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::mudd0LookAtMemoryDiskBox },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::mudd0LookAtDegrimerBox },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::mudd0LookAtLense },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::mudd0UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0xff, 0}, &Room::mudd0UseMTricorderAnywhere },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::mudd0UseSTricorderOnMemoryDiskBox },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x22, 0}, &Room::mudd0UseSTricorderOnDegrimerBox },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x21, 0}, &Room::mudd0UseMTricorderOnLense },

	// Common code (next 4 lines)
	{ {ACTION_USE, OBJECT_ILENSES, OBJECT_IDEGRIME, 0}, &Room::muddaUseLenseOnDegrimer },
	{ {ACTION_USE, OBJECT_IALIENDV, 0xff, 0}, &Room::muddaUseAlienDevice },
	{ {ACTION_FINISHED_ANIMATION, 9, 0, 0}, &Room::muddaFiredAlienDevice },
	{ {ACTION_USE, OBJECT_IDEGRIME, 0xff, 0}, &Room::muddaUseDegrimer },

	{ {ACTION_GET, 0x21, 0, 0}, &Room::mudd0GetLense },
	{ {ACTION_GET, 0x20, 0, 0}, &Room::mudd0GetMemoryDisk },
	{ {ACTION_GET, 0x22, 0, 0}, &Room::mudd0GetDegrimer },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::mudd0PickedUpLense },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::mudd0PickedUpItem },
	{ {ACTION_WALK, 0x26, 0, 0}, &Room::mudd0WalkToSouthDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 1, 0, 0}, &Room::mudd0TouchedHotspot1 },
	{ {ACTION_WALK, 0x25, 0, 0}, &Room::mudd0WalkToNorthDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::mudd0TouchedHotspot0 },
	{ {ACTION_USE, OBJECT_IMEDKIT, 0xff, 0}, &Room::mudd0UseMedkit },
	{ {ACTION_LOOK, OBJECT_KIRK,     0, 0}, &Room::mudd0LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK,    0, 0}, &Room::mudd0LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY,    0, 0}, &Room::mudd0LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd0LookAtRedshirt },
	{ {ACTION_LOOK, 8,               0, 0}, &Room::mudd0LookAtMudd },
	{ {ACTION_TALK, OBJECT_KIRK,     0, 0}, &Room::mudd0TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK,    0, 0}, &Room::mudd0TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY,    0, 0}, &Room::mudd0TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd0TalkToRedshirt },
	{ {ACTION_TALK, 8,               0, 0}, &Room::mudd0TalkToMudd },

	// Common code (countdown for losing atmosphere when life support malfunctioning)
	{ {ACTION_TICK, 0xff, 0xff, 0xff},           &Room::muddaTick },
};

RoomAction mudd1ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::mudd1Tick1 },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::mudd1Timer1Expired },

	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0},    &Room::mudd1UseCommunicator },
	{ {ACTION_USE, OBJECT_SPOCK, 0x23, 0},  &Room::mudd1UseSpockOnBlueButton },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0},   &Room::mudd1SpockReachedBlueButton },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::mudd1SpockPressedBlueButton },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0}, &Room::mudd1CraneFinishedMoving },
	{ {ACTION_USE, OBJECT_SPOCK, 0x24, 0},  &Room::mudd1UseSpockOnYellowButton },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0},   &Room::mudd1SpockReachedYellowButton },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0}, &Room::mudd1SpockPressedYellowButton },
	{ {ACTION_USE, OBJECT_SPOCK, 0x25, 0},  &Room::mudd1UseSpockOnRedButton },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0},   &Room::mudd1SpockReachedRedButton },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0}, &Room::mudd1SpockPressedRedButton },

	// Common code (next 4 lines)
	{ {ACTION_USE, OBJECT_IDEGRIME, 0xff, 0}, &Room::muddaUseDegrimer },
	{ {ACTION_USE, OBJECT_ILENSES, OBJECT_IDEGRIME, 0}, &Room::muddaUseLenseOnDegrimer },
	{ {ACTION_USE, OBJECT_IALIENDV, 0xff, 0}, &Room::muddaUseAlienDevice },
	{ {ACTION_FINISHED_ANIMATION, 9, 0, 0}, &Room::muddaFiredAlienDevice },

	{ {ACTION_GET, 9,    0, 0}, &Room::mudd1GetTorpedo },
	{ {ACTION_GET, 0x21, 0, 0}, &Room::mudd1GetTorpedo },
	{ {ACTION_GET, 0x20, 0, 0}, &Room::mudd1GetTorpedo },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::mudd1UseSTricorderOnTorpedo },
	{ {ACTION_USE, OBJECT_ISTRICOR, 9,    0}, &Room::mudd1UseSTricorderOnTorpedo },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::mudd1UseSTricorderOnTorpedo },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x22, 0}, &Room::mudd1UseSTricorderOnTorpedoLauncher },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x25, 0}, &Room::mudd1UseSTricorderOnButton },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x23, 0}, &Room::mudd1UseSTricorderOnButton },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x24, 0}, &Room::mudd1UseSTricorderOnButton },
	{ {ACTION_USE, OBJECT_ISTRICOR, 8, 0},    &Room::mudd1UseSTricorderOnCrane },
	{ {ACTION_USE, OBJECT_IMEDKIT, 0xff, 0},  &Room::mudd1UseMedkitAnywhere },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::mudd1LookAnywhere },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::mudd1LookAtTorpedo },
	{ {ACTION_LOOK, 9,    0, 0}, &Room::mudd1LookAtTorpedo },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::mudd1LookAtFallenTorpedo },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::mudd1LookAtTorpedoLauncher },
	{ {ACTION_LOOK, OBJECT_KIRK,     0, 0}, &Room::mudd1LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK,    0, 0}, &Room::mudd1LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY,    0, 0}, &Room::mudd1LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd1LookAtRedshirt },
	{ {ACTION_LOOK, 8,    0, 0}, &Room::mudd1LookAtCrane },
	{ {ACTION_LOOK, 0x25, 0, 0}, &Room::mudd1LookAtRedButton },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::mudd1LookAtBlueButton },
	{ {ACTION_LOOK, 0x24, 0, 0}, &Room::mudd1LookAtYellowButton },
	{ {ACTION_TALK, OBJECT_KIRK,     0, 0}, &Room::mudd1TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK,    0, 0}, &Room::mudd1TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY,    0, 0}, &Room::mudd1TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd1TalkToRedshirt },
	{ {ACTION_WALK, 0x28, 0, 0}, &Room::mudd1WalkToSouthDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 2, 0, 0}, &Room::mudd1TouchedHotspot2 },
	{ {ACTION_WALK, 0x27, 0, 0}, &Room::mudd1WalkToNorthDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 1, 0, 0}, &Room::mudd1TouchedHotspot1 },
	{ {ACTION_WALK, 0x26, 0, 0}, &Room::mudd1WalkToWestDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::mudd1TouchedHotspot0 },

	// Common code (countdown for losing atmosphere when life support malfunctioning)
	{ {ACTION_TICK, 0xff, 0xff, 0xff},           &Room::muddaTick },
};

RoomAction mudd2ActionList[] = {
	{ {ACTION_WALK, 0x21, 0, 0}, &Room::mudd2WalkToNorthDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::mudd2TouchedHotspot0 },
	{ {ACTION_WALK, 0x22, 0, 0}, &Room::mudd2WalkToSouthDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 1, 0, 0}, &Room::mudd2TouchedHotspot1 },
	{ {ACTION_TICK, 1, 0, 0}, &Room::mudd2Tick1 },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0}, &Room::mudd2Timer1Expired },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff,   0}, &Room::mudd2UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_SPOCK,    0x20, 0}, &Room::mudd2UseSpockOnCapsules },
	{ {ACTION_GET, 0x20, 0, 0}, &Room::mudd2GetCapsules },
	{ {ACTION_FINISHED_WALKING,   12, 0, 0}, &Room::mudd2MccoyReachedCapsules },
	{ {ACTION_FINISHED_ANIMATION, 13, 0, 0}, &Room::mudd2MccoyPickedUpCapsules },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0}, &Room::mudd2UseCommunicator },

	// Common code (next 4 lines)
	{ {ACTION_USE, OBJECT_IDEGRIME, 0xff, 0}, &Room::muddaUseDegrimer },
	{ {ACTION_USE, OBJECT_ILENSES, OBJECT_IDEGRIME, 0}, &Room::muddaUseLenseOnDegrimer },
	{ {ACTION_USE, OBJECT_IALIENDV, 0xff, 0}, &Room::muddaUseAlienDevice },
	{ {ACTION_FINISHED_ANIMATION, 18, 0, 0}, &Room::muddaFiredAlienDevice },

	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::mudd2LookAtCapsules },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x20, 0}, &Room::mudd2UseMTricorderOnCapsules },
	{ {ACTION_USE, OBJECT_ICAPSULE, 0x23, 0}, &Room::mudd2UseCapsuleOnControlPanel },
	{ {ACTION_FINISHED_WALKING,   15, 0, 0},  &Room::mudd2MccoyReachedControlPanel },
	{ {ACTION_FINISHED_ANIMATION, 15, 0, 0},  &Room::mudd2MccoyPutCapsuleInControlPanel },
	{ {ACTION_USE, OBJECT_KIRK, 0x24, 0},     &Room::mudd2UseKirkOnBed },
	{ {ACTION_USE, OBJECT_KIRK, 0x25, 0},     &Room::mudd2UseKirkOnBed },
	{ {ACTION_FINISHED_WALKING, 6, 0, 0},     &Room::mudd2KirkReachedBed },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0},   &Room::mudd2MuddNoticedKirk },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0},   &Room::mudd2MuddDroppedCapsule },
	{ {ACTION_USE, OBJECT_IPHASERS, 8, 0},    &Room::mudd2UsePhaserOnMudd },
	{ {ACTION_USE, OBJECT_IPHASERK, 8, 0},    &Room::mudd2UsePhaserOnMudd },

	{ {ACTION_USE, OBJECT_SPOCK, 8, 0},       &Room::mudd2UseSpockOnMudd },
	{ {ACTION_FINISHED_WALKING, 4, 0, 0},     &Room::mudd2SpockReachedMudd },
	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0},   &Room::mudd2SpockPinchedMudd },
	{ {ACTION_USE, OBJECT_KIRK, 8, 0},        &Room::mudd2UseKirkOnMudd },

	{ {ACTION_USE, OBJECT_REDSHIRT, 8, 0},    &Room::mudd2UseRedshirtOnMudd },
	{ {ACTION_FINISHED_WALKING, 16, 0, 0},    &Room::mudd2RedshirtReachedMudd },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0},        &Room::mudd2Timer2Expired },
	{ {ACTION_FINISHED_ANIMATION, 17, 0, 0},  &Room::mudd2MuddFinishedPushingRedshirt },
	{ {ACTION_FINISHED_ANIMATION, 16, 0, 0},  &Room::mudd2RedshirtPushedAway },
	{ {ACTION_USE, OBJECT_IMTRICOR, 8, 0},    &Room::mudd2UseMTricorderOnMudd },
	{ {ACTION_USE, OBJECT_IMEDKIT, 8, 0},     &Room::mudd2UseMedkitOnMudd },
	{ {ACTION_USE, OBJECT_MCCOY, 8, 0},       &Room::mudd2UseMedkitOnMudd },
	{ {ACTION_FINISHED_WALKING, 10, 0, 0},    &Room::mudd2MccoyReachedMudd },
	{ {ACTION_FINISHED_ANIMATION, 11, 0, 0},  &Room::mudd2MccoyCuredMudd },
	{ {ACTION_LOOK, OBJECT_KIRK,     0, 0}, &Room::mudd2LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK,    0, 0}, &Room::mudd2LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY,    0, 0}, &Room::mudd2LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd2LookAtRedshirt },
	{ {ACTION_LOOK, 8,    0, 0}, &Room::mudd2LookAtMudd },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::mudd2LookAtControlPanel },
	{ {ACTION_LOOK, 0x25, 0, 0}, &Room::mudd2LookAtBed },
	{ {ACTION_LOOK, 0x24, 0, 0}, &Room::mudd2LookAtBed },
	{ {ACTION_TALK, OBJECT_KIRK,     0, 0}, &Room::mudd2TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK,    0, 0}, &Room::mudd2TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY,    0, 0}, &Room::mudd2TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd2TalkToRedshirt },
	{ {ACTION_TALK, 8,               0, 0}, &Room::mudd2TalkToMudd },

	// Common code (countdown for losing atmosphere when life support malfunctioning)
	{ {ACTION_TICK, 0xff, 0xff, 0xff},           &Room::muddaTick },
};

RoomAction mudd3ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::mudd3Tick1 },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0},    &Room::mudd3UseCommunicator },
	{ {ACTION_LOOK, 0x20, 0, 0},              &Room::mudd3LookAtScreen },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::mudd3UseSTricorderOnScreen },
	{ {ACTION_USE, OBJECT_KIRK, 0x20, 0},     &Room::mudd3UseKirkOnScreen },
	{ {ACTION_USE, OBJECT_SPOCK, 0x21, 0},    &Room::mudd3UseSpockOnSphere },
	{ {ACTION_TIMER_EXPIRED, 3, 0, 0},        &Room::mudd3Timer3Expired },
	{ {ACTION_USE, OBJECT_MCCOY, 0x21, 0},    &Room::mudd3UseMccoyOnSphere },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x21, 0}, &Room::mudd3UseRedshirtOnSphere },
	{ {ACTION_USE, OBJECT_IMTRICOR, 0x21, 0}, &Room::mudd3UseMTricorderOnSphere },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::mudd3UseSTricorderOnSphere },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0},     &Room::mudd3ReadyToHookUpTricorders },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0},        &Room::mudd3Timer1Expired },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0},        &Room::mudd3Timer2Expired },
	{ {ACTION_TIMER_EXPIRED, 4, 0, 0},        &Room::mudd3Timer4Expired },
	{ {ACTION_USE, OBJECT_IDISKS, 0x21, 0},   &Room::mudd3UseMemoryDiskOnSphere },

	// Common code (next 4 lines)
	{ {ACTION_USE, OBJECT_IDEGRIME, 0xff, 0}, &Room::muddaUseDegrimer },
	{ {ACTION_USE, OBJECT_ILENSES, OBJECT_IDEGRIME, 0}, &Room::muddaUseLenseOnDegrimer },
	{ {ACTION_USE, OBJECT_IALIENDV, 0xff, 0}, &Room::muddaUseAlienDevice },
	{ {ACTION_FINISHED_ANIMATION, 9, 0, 0}, &Room::muddaFiredAlienDevice },

	{ {ACTION_GET, 13, 0, 0}, &Room::mudd3GetRepairTool },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0},   &Room::mudd3ReachedRepairTool },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0}, &Room::mudd3PickedUpRepairTool },
	{ {ACTION_LOOK, 0x21, 0, 0},            &Room::mudd3LookAtSphere },
	{ {ACTION_WALK, 0x22, 0, 0},            &Room::mudd3WalkToNorthDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0},    &Room::mudd3TouchedHotspot0 },
	{ {ACTION_WALK, 0x23, 0, 0},            &Room::mudd3WalkToEastDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 1, 0, 0},    &Room::mudd3TouchedHotspot1 },
	{ {ACTION_LOOK, OBJECT_KIRK,     0, 0}, &Room::mudd3LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK,    0, 0}, &Room::mudd3LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY,    0, 0}, &Room::mudd3LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd3LookAtRedshirt },
	{ {ACTION_LOOK, 8,               0, 0}, &Room::mudd3LookAtMudd },
	{ {ACTION_TALK, OBJECT_KIRK,     0, 0}, &Room::mudd3TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK,    0, 0}, &Room::mudd3TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY,    0, 0}, &Room::mudd3TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd3TalkToRedshirt },
	{ {ACTION_TALK, 8,               0, 0}, &Room::mudd3TalkToMudd },
	{ {ACTION_USE, OBJECT_IMEDKIT,  0xff, 0}, &Room::mudd3UseMedkit },

	// Common code (countdown for losing atmosphere when life support malfunctioning)
	{ {ACTION_TICK, 0xff, 0xff, 0xff},           &Room::muddaTick },
};

RoomAction mudd4ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::mudd4Tick1 },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0},    &Room::mudd4UseCommunicator },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0},        &Room::mudd4Timer2Expired },
	{ {ACTION_TIMER_EXPIRED, 3, 0, 0},        &Room::mudd4Timer3Expired },
	{ {ACTION_USE, OBJECT_SPOCK, 0x21, 0},    &Room::mudd4UseSpockOnLeftConsole },
	{ {ACTION_USE, OBJECT_SPOCK, 0x22, 0},    &Room::mudd4UseSpockOnLeftConsole },
	{ {ACTION_USE, OBJECT_SPOCK, 0x23, 0},    &Room::mudd4UseSpockOnRightConsole },
	{ {ACTION_FINISHED_WALKING, 1, 0, 0},     &Room::mudd4SpockReachedChair },
	{ {ACTION_FINISHED_ANIMATION, 1, 0, 0},   &Room::mudd4SpockSatInChair },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0},   &Room::mudd4SpockUsedSensors },
	{ {ACTION_FINISHED_ANIMATION, 3, 0, 0},   &Room::mudd4SpockUsedEngineering },
	{ {ACTION_FINISHED_ANIMATION, 4, 0, 0},   &Room::mudd4SpockUsedNavigation },
	{ {ACTION_FINISHED_WALKING, 3, 0, 0},     &Room::mudd4FinishedWalking3 },
	{ {ACTION_USE, OBJECT_KIRK, 0x21, 0},     &Room::mudd4UseKirkOnRightConsole },
	{ {ACTION_USE, OBJECT_KIRK, 0x23, 0},     &Room::mudd4UseKirkOnRightConsole },
	{ {ACTION_USE, OBJECT_KIRK, 0x22, 0},     &Room::mudd4UseKirkOnLeftConsole },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0},     &Room::mudd4KirkReachedRightConsole },
	{ {ACTION_FINISHED_ANIMATION, 5, 0, 0},   &Room::mudd4KirkSatInChair },
	{ {ACTION_FINISHED_ANIMATION, 6, 0, 0},   &Room::mudd4KirkUsedViewScreen },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0},        &Room::mudd4Timer1Expired },
	{ {ACTION_FINISHED_ANIMATION, 7, 0, 0},   &Room::mudd4KirkUsedCommunications },
	{ {ACTION_FINISHED_WALKING, 4, 0, 0},     &Room::mudd4KirkReachedPositionToTalkToMudd },
	{ {ACTION_USE, OBJECT_MCCOY, 0x21, 0},    &Room::mudd4UseMccoyOnConsole },
	{ {ACTION_USE, OBJECT_MCCOY, 0x22, 0},    &Room::mudd4UseMccoyOnConsole },
	{ {ACTION_USE, OBJECT_MCCOY, 0x23, 0},    &Room::mudd4UseMccoyOnConsole },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x21, 0}, &Room::mudd4UseRedshirtOnConsole },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x22, 0}, &Room::mudd4UseRedshirtOnConsole },
	{ {ACTION_USE, OBJECT_REDSHIRT, 0x23, 0}, &Room::mudd4UseRedshirtOnConsole },
	{ {ACTION_USE, OBJECT_ISTRICOR, 10, 0},   &Room::mudd4UseSTricorderOnRepairTool },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::mudd4UseSTricorderOnConsole },

	// ENHANCEMENT: Allow scanning the console to work when scanning the specific stations
	// as well
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x22, 0}, &Room::mudd4UseSTricorderOnConsole },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x23, 0}, &Room::mudd4UseSTricorderOnConsole },

	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::mudd4UseSTricorderOnViewscreen },

	// ENHANCEMENT: Allow scanning the viewscreen when it's on, not just when off
	{ {ACTION_USE, OBJECT_ISTRICOR, 8, 0},    &Room::mudd4UseSTricorderOnViewscreen },

	// Common code (next 4 lines)
	{ {ACTION_USE, OBJECT_ILENSES, OBJECT_IDEGRIME, 0}, &Room::muddaUseLenseOnDegrimer },
	{ {ACTION_USE, OBJECT_IALIENDV, 0xff, 0}, &Room::muddaUseAlienDevice },
	{ {ACTION_FINISHED_ANIMATION, 9, 0, 0}, &Room::muddaFiredAlienDevice },
	{ {ACTION_USE, OBJECT_IDEGRIME, 0xff, 0}, &Room::muddaUseDegrimer },

	{ {ACTION_USE, OBJECT_IMEDKIT, 0xff, 0},   &Room::mudd4UseMedkit },
	{ {ACTION_GET, 10, 0, 0},                &Room::mudd4GetRepairTool },
	{ {ACTION_FINISHED_WALKING, 5, 0, 0},    &Room::mudd4ReachedRepairTool },
	{ {ACTION_FINISHED_ANIMATION, 10, 0, 0}, &Room::mudd4PickedUpRepairTool },

	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::mudd4LookAtConsole },
	// ENHANCEMENT: Allow look action work with the specific stations as well
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::mudd4LookAtConsole },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::mudd4LookAtConsole },

	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::mudd4LookAtViewscreen },
	// ENHANCEMENT: Allow look action work when viewscreen is on, not just when off
	{ {ACTION_LOOK, 8, 0, 0},    &Room::mudd4LookAtViewscreen },

	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0},     &Room::mudd4LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0},    &Room::mudd4LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0},    &Room::mudd4LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd4LookAtRedshirt },
	{ {ACTION_LOOK, 10, 0, 0},              &Room::mudd4LookAtRepairTool },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0},     &Room::mudd4TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0},    &Room::mudd4TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0},    &Room::mudd4TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd4TalkToRedshirt },
	{ {ACTION_WALK, 0x24, 0, 0},            &Room::mudd4WalkToEastDoor },
	{ {ACTION_WALK, 0x25, 0, 0},            &Room::mudd4WalkToWestDoor },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0},    &Room::mudd4TouchedHotspot0 },

	// Common code (countdown for losing atmosphere when life support malfunctioning)
	{ {ACTION_TICK, 0xff, 0xff, 0xff},           &Room::muddaTick },
};

RoomAction mudd5ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0}, &Room::mudd5Tick1 },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0},        &Room::mudd5Timer1Expired },
	{ {ACTION_TIMER_EXPIRED, 2, 0, 0},        &Room::mudd5Timer2Expired },
	{ {ACTION_USE, OBJECT_ICOMM, 0xff, 0},      &Room::mudd5UseCommunicator },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0},   &Room::mudd5UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x21, 0}, &Room::mudd5UseSTricorderOnEngine },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x22, 0}, &Room::mudd5UseSTricorderOnCrane },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0x20, 0}, &Room::mudd5UseSTricorderOnHatch },
	{ {ACTION_USE, OBJECT_ISTRICOR, 9,    0}, &Room::mudd5UseSTricorderOnLifeSupportGenerator },
	{ {ACTION_USE, OBJECT_IPHASERS, 0x20, 0}, &Room::mudd5UseStunPhaserOnHatch },
	{ {ACTION_USE, OBJECT_IPHASERK, 0x20, 0}, &Room::mudd5UseKillPhaserOnHatch },
	{ {ACTION_USE, 0xff,            9,    0}, &Room::mudd5UseAnythingOnLifeSupportGenerator },
	{ {ACTION_USE, OBJECT_IDOOVER,  9,    0}, &Room::mudd5UseDooverOnLifeSupportGenerator },
	{ {ACTION_FINISHED_WALKING, 2, 0, 0},     &Room::mudd5KirkReachedLifeSupportGenerator },
	{ {ACTION_TIMER_EXPIRED, 4, 0, 0},        &Room::mudd5KirkTimer4Expired },
	{ {ACTION_FINISHED_ANIMATION, 2, 0, 0},   &Room::mudd5KirkRepairedLifeSupportGenerator },
	{ {ACTION_TIMER_EXPIRED, 3, 0, 0},        &Room::mudd5KirkTimer3Expired },

	// Common code (next 4 lines)
	{ {ACTION_USE, OBJECT_ILENSES, OBJECT_IDEGRIME, 0}, &Room::muddaUseLenseOnDegrimer },
	{ {ACTION_USE, OBJECT_IALIENDV, 0xff, 0}, &Room::muddaUseAlienDevice },
	{ {ACTION_FINISHED_ANIMATION, 9, 0, 0}, &Room::muddaFiredAlienDevice },
	{ {ACTION_USE, OBJECT_IDEGRIME, 0xff, 0}, &Room::muddaUseDegrimer },

	{ {ACTION_LOOK, 0x20, 0, 0},         &Room::mudd5LookAtHatch },
	{ {ACTION_LOOK, 9,    0, 0},         &Room::mudd5LookAtLifeSupportGenerator },
	{ {ACTION_TOUCHED_HOTSPOT, 0, 0, 0}, &Room::mudd5TouchedHotspot0 },
	{ {ACTION_WALK, 0x22, 0, 0},         &Room::mudd5WalkToDoor },
	{ {ACTION_LOOK, OBJECT_KIRK, 0, 0},     &Room::mudd5LookAtKirk },
	{ {ACTION_LOOK, OBJECT_SPOCK, 0, 0},    &Room::mudd5LookAtSpock },
	{ {ACTION_LOOK, OBJECT_MCCOY, 0, 0},    &Room::mudd5LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd5LookAtRedshirt },
	{ {ACTION_LOOK, 0x22, 0, 0},            &Room::mudd5LookAtDoor },
	{ {ACTION_LOOK, 0x23, 0, 0},            &Room::mudd5LookAtCrane },
	{ {ACTION_LOOK, 0x21, 0, 0},            &Room::mudd5LookAtEngine },
	{ {ACTION_TALK, OBJECT_KIRK, 0, 0},     &Room::mudd5TalkToKirk },
	{ {ACTION_TALK, OBJECT_SPOCK, 0, 0},    &Room::mudd5TalkToSpock },
	{ {ACTION_TALK, OBJECT_MCCOY, 0, 0},    &Room::mudd5TalkToMccoy },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::mudd5TalkToRedshirt },
	{ {ACTION_USE, OBJECT_IMEDKIT, 0xff, 0},  &Room::mudd5UseMedkit },

	// Common code (countdown for losing atmosphere when life support malfunctioning)
	{ {ACTION_TICK, 0xff, 0xff, 0xff},           &Room::muddaTick },
};

RoomAction feather0ActionList[] = {
	{ {ACTION_TICK, 1, 0, 0},  &Room::feather0Tick1 },
	{ {ACTION_TICK, 60, 0, 0}, &Room::feather0Tick60 },
	{ {ACTION_TALK, 8, 0, 0},  &Room::feather0TalkToQuetzecoatl },
	{ {ACTION_TIMER_EXPIRED, 0, 0, 0},                &Room::feather0Timer0Expired },
	{ {ACTION_TIMER_EXPIRED, 1, 0, 0},                &Room::feather0Timer1Expired },
	{ {ACTION_USE, OBJECT_IPHASERS, 8,            0}, &Room::feather0UsePhaserOnQuetzecoatl },
	{ {ACTION_USE, OBJECT_IPHASERK, 8,            0}, &Room::feather0UsePhaserOnQuetzecoatl },
	{ {ACTION_USE, OBJECT_IPHASERS, OBJECT_MCCOY, 0}, &Room::feather0UsePhaserOnMccoy },
	{ {ACTION_USE, OBJECT_IPHASERS, OBJECT_MCCOY, 0}, &Room::feather0UsePhaserOnMccoy },
	{ {ACTION_USE, OBJECT_IMEDKIT, 0xff,          0}, &Room::feather0UseMedkit },
	{ {ACTION_LOOK, 8,    0, 0}, &Room::feather0LookAtQuetzecoatl },
	{ {ACTION_LOOK, 0x20, 0, 0}, &Room::feather0LookAtMoon },
	{ {ACTION_LOOK, 0x21, 0, 0}, &Room::feather0LookAtLog },
	{ {ACTION_LOOK, 0x22, 0, 0}, &Room::feather0LookAtHut },
	{ {ACTION_LOOK, 0xff, 0, 0}, &Room::feather0LookAnywhere },
	{ {ACTION_LOOK, 0x23, 0, 0}, &Room::feather0LookAtEyes },
	{ {ACTION_LOOK, 0x24, 0, 0}, &Room::feather0LookAtEyes },
	{ {ACTION_LOOK, 0x25, 0, 0}, &Room::feather0LookAtEyes },
	{ {ACTION_LOOK, 0x26, 0, 0}, &Room::feather0LookAtEyes },
	{ {ACTION_LOOK, 0x27, 0, 0}, &Room::feather0LookAtEyes },
	{ {ACTION_LOOK, 0x28, 0, 0}, &Room::feather0LookAtEyes },
	{ {ACTION_LOOK, 0x29, 0, 0}, &Room::feather0LookAtEyes },
	{ {ACTION_LOOK, 0x2a, 0, 0}, &Room::feather0LookAtEyes },
	{ {ACTION_LOOK, 0x2b, 0, 0}, &Room::feather0LookAtEyes },
	{ {ACTION_LOOK, 0x2c, 0, 0}, &Room::feather0LookAtTree },
	{ {ACTION_LOOK, OBJECT_MCCOY,    0, 0}, &Room::feather0LookAtMccoy },
	{ {ACTION_LOOK, OBJECT_SPOCK,    0, 0}, &Room::feather0LookAtSpock },
	{ {ACTION_LOOK, OBJECT_REDSHIRT, 0, 0}, &Room::feather0LookAtRedshirt },
	{ {ACTION_TALK, OBJECT_MCCOY,    0, 0}, &Room::feather0TalkToMccoy },
	{ {ACTION_TALK, OBJECT_SPOCK,    0, 0}, &Room::feather0TalkToSpock },
	{ {ACTION_TALK, OBJECT_REDSHIRT, 0, 0}, &Room::feather0TalkToRedshirt },
	{ {ACTION_USE, OBJECT_ISTRICOR,  8, 0}, &Room::feather0UseSTricorderOnQuetzecoatl },
	{ {ACTION_USE, OBJECT_ISTRICOR, 0xff, 0}, &Room::feather0UseSTricorderAnywhere },
	{ {ACTION_USE, OBJECT_IMTRICOR,  8, 0}, &Room::feather0UseMTricorderOnQuetzecoatl },
};

extern const RoomAction feather1ActionList[], feather2ActionList[], feather3ActionList[], feather4ActionList[];
extern const int        feather1NumActions,   feather2NumActions,   feather3NumActions,   feather4NumActions;
extern const RoomAction feather5ActionList[], feather6ActionList[], feather7ActionList[];
extern const int        feather5NumActions,   feather6NumActions,   feather7NumActions;

extern const RoomAction trial0ActionList[], trial1ActionList[], trial2ActionList[], trial3ActionList[];
extern const int        trial0NumActions,   trial1NumActions,   trial2NumActions,   trial3NumActions;
extern const RoomAction trial4ActionList[], trial5ActionList[];
extern const int        trial4NumActions,   trial5NumActions;

extern const RoomAction sins0ActionList[], sins1ActionList[], sins2ActionList[], sins3ActionList[];
extern const int        sins0NumActions,   sins1NumActions,   sins2NumActions,   sins3NumActions;
extern const RoomAction sins4ActionList[], sins5ActionList[];
extern const int        sins4NumActions,   sins5NumActions;

extern const RoomAction veng0ActionList[], veng1ActionList[], veng2ActionList[], veng3ActionList[];
extern const int        veng0NumActions,   veng1NumActions,   veng2NumActions,   veng3NumActions;
extern const RoomAction veng4ActionList[], veng5ActionList[], veng6ActionList[], veng7ActionList[], veng8ActionList[];
extern const int        veng4NumActions,   veng5NumActions,   veng6NumActions,   veng7NumActions,   veng8NumActions;

}

#endif
