Convert OpenDNSSEC 1.4 database to OpenDNSSEC 2.0 database
==========================================================

The ODS2.0 database is set up very different from the ODS1.4 database. We 
provide a couple of scripts to make the transition. Please review this 
document entirely before starting the conversation.

Requirements
------------

These scripts will work coming from ODS version 1.4.8.2 or 1.4.9. Earlier
versions are not supported. Please upgrade to one of these 2 versions before 
migration.

General preparation
-------------------

 * First stop OpenDNSSEC entirely.
 * You are strongly advised to backup /etc/opendnssec and /var/opendnssec before
   continuing.
 * Also prevent any nameserver from receiving updates from OpenDNSSEC until
   you are sure the migration was successful.
 * It is discouraged to perform the migration during a rollover. The migration
   script tries to deal with it as gracefull as possible though many corner
   cased exist. Generally it will not break the zone but unexpected behaviour
   may occur. If you do, and see unexpected state, the best way to deal with it
   is to start a rollover for the offending keytype.

Conversion Sqlite
-----------------

There are 2 relevant files for the conversion:

 * convert_sqlite - A bash conversion script
 * sqlite_convert.sql - Contains SQL statements, called by convert_sqlite

call the script like so: `./convert_sqlite -i INPUT -o OUTPUT`. Where INPUT is
the kasp.db file commonly found in _/var/opendnssec/kasp.db_. And OUTPUT is a
non-existing file where the new database should go. On success, replace old
database file with the new database file or adjust _conf.xml_ accordingly.

Conversion MySQL
----------------
 
There are 2 relevant files for the conversion:

 * convert_mysql - A bash conversion script
 * mysql_convert.sql - Contains SQL statements, called by convert_mysql

call the script like so: `./convert_sqlite -i INPUT -o OUTPUT -h HOST -u USER
-p PASSWORD`. Where INPUT is the name of the existing database on HOST. And
OUTPUT is a non-existing database on the same host where the new database
should go. On success, replace old database with the new database file or
adjust _conf.xml_ accordingly.
  
Post Conversion
---------------

ODS 2.0 stores the keytags in the database, 1.4 unfortunately does not.
Therefore an additional tool is provided which calculates the keytags and
stores them in the database. Make sure that at this point conf.xml points to
the new database. Then run `ods-migrate`.

Now your new database is ready for use. At this point the signer will refuse to
run because the file `/var/opendnssec/enforcer/zones.xml` does not exist
yet.  In ODS 1.4 `/etc/opendnssec/zonelist.xml` is always on par with the
database contents (this is no longer true for 2.0) so it is safe to copy this
file over to the missing file.

If all went well you should be able to start OpenDNSSEC and review its output.
If applicable start any nameservers you stopped in the process. 
