/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject;

import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;

public class Tools
extends ResourceObject {
    public static final String COMMONNAME = "http://purl.org/dc/elements/1.1/:title";
    public static final String MAIL = "http://purl.oclc.org/NET/cmcs/schema/:mail";
    public static final String DESCRIPTION = "http://purl.org/dc/elements/1.1/:description";
    public static final String URL = "http://purl.oclc.org/NET/cmcs/schema/:url";
    public static final String MEMBERSHIP = "http://purl.oclc.org/NET/cmcs/schema/:memberOf";
    public static final String CATEGORIES = "http://purl.org/dc/elements/1.1/:subject";

    public Tools() {
        this.setAttributeTypes();
        try {
            this.add("http://purl.org/dc/elements/1.1/:type", this.getClass().getName());
        }
        catch (Exception dsme) {
            this.mLog.severe("Exception creating Tools class: " + dsme.toString());
        }
    }

    private void setAttributeTypes() {
        this.mAttributeTypes.put(COMMONNAME, String.class);
        this.mAttributeTypes.put(MAIL, String.class);
        this.mAttributeTypes.put(DESCRIPTION, String.class);
        this.mAttributeTypes.put(URL, String.class);
        this.mAttributeTypes.put(MEMBERSHIP, String[].class);
        this.mAttributeTypes.put(CATEGORIES, String[].class);
    }

    public String getCommonName() {
        Object commonName = this.mResourceEntry.get(COMMONNAME);
        return (String)commonName;
    }

    public String getMail() {
        Object mail = this.mResourceEntry.get(MAIL);
        return (String)mail;
    }

    public String getDescription() {
        Object description = this.mResourceEntry.get(DESCRIPTION);
        return (String)description;
    }

    public String getUrl() {
        Object url = this.mResourceEntry.get(URL);
        return (String)url;
    }

    public String[] getMembership() {
        return this.getAsStringArray(MEMBERSHIP);
    }

    public String[] getCategories() {
        return this.getAsStringArray(CATEGORIES);
    }

    public void setCommonName(String commonName) {
        this.mResourceEntry.put(COMMONNAME, commonName);
    }

    public void setMail(String mail) {
        this.mResourceEntry.put(MAIL, mail);
    }

    public void setDescription(String description) {
        this.mResourceEntry.put(DESCRIPTION, description);
    }

    public void setUrl(String url) {
        this.mResourceEntry.put(URL, url);
    }

    public void setMembership(String[] membership) {
        this.mResourceEntry.put(MEMBERSHIP, membership);
    }

    public void setCategories(String[] categories) {
        this.mResourceEntry.put(CATEGORIES, categories);
    }
}

