/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __BLENDER_H

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif

#define BLEND_MAX_AMP 32768
#define BLEND_MIN_AMP 0

typedef struct blender{

  sample *(* get_buffer)(struct blender *);
  void (*next_buffer)(struct blender *);
  sample_producer **(*get_children)(struct blender *);
  char **(*get_header)(struct blender *);
  char **(*get_code)(struct blender *);
  char **(*get_footer)(struct blender *);
  char **header;
  char **code;
  int next;
  sample_producer **source;
  sample *buffer;
  sample **bufs;
  int *strength;
  int length;
  int blend_factor;

}blender;

blender *blender_new(sample_producer **sources);
void blender_next_buffer(blender *this);
sample *blender_get_buffer(blender *this);
void blender_set_strength(blender *this,int amp,int index);

/*
  Local Variables:
  mode: font-lock
  End:
*/
