/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import visad.CoordinateSystem;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.Integer2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.matrix.JamaCholeskyDecomposition;
import visad.matrix.JamaEigenvalueDecomposition;
import visad.matrix.JamaLUDecomposition;
import visad.matrix.JamaQRDecomposition;
import visad.matrix.JamaSingularValueDecomposition;

public class JamaMatrix
extends FlatField {
    private static final RealType matrix_row = RealType.getRealType("matrix_row");
    private static final RealType matrix_column = RealType.getRealType("matrix_column");
    private static final RealType matrix_value = RealType.getRealType("matrix_value");
    private static final FunctionType matrixType = JamaMatrix.constructFunction();
    private static final Class[] classes = JamaMatrix.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private Object matrix;
    private static final Method[] methods = JamaMatrix.constructMethods();
    private static final Method getColumnDimension = methods[0];
    private static final Method getRowDimension = methods[1];
    private static final Method getArray = methods[2];
    private static final Method get = methods[3];
    private static final Method getMatrix1 = methods[4];
    private static final Method getMatrix2 = methods[5];
    private static final Method getMatrix3 = methods[6];
    private static final Method getMatrix4 = methods[7];
    private static final Method set = methods[8];
    private static final Method setMatrix1 = methods[9];
    private static final Method setMatrix2 = methods[10];
    private static final Method setMatrix3 = methods[11];
    private static final Method setMatrix4 = methods[12];
    private static final Method transpose = methods[13];
    private static final Method norm1 = methods[14];
    private static final Method norm2 = methods[15];
    private static final Method normInf = methods[16];
    private static final Method normF = methods[17];
    private static final Method uminus = methods[18];
    private static final Method plus = methods[19];
    private static final Method plusEquals = methods[20];
    private static final Method minus = methods[21];
    private static final Method minusEquals = methods[22];
    private static final Method arrayTimes = methods[23];
    private static final Method arrayTimesEquals = methods[24];
    private static final Method arrayRightDivide = methods[25];
    private static final Method arrayRightDivideEquals = methods[26];
    private static final Method arrayLeftDivide = methods[27];
    private static final Method arrayLeftDivideEquals = methods[28];
    private static final Method times1 = methods[29];
    private static final Method timesEquals = methods[30];
    private static final Method times2 = methods[31];
    private static final Method solve = methods[32];
    private static final Method solveTranspose = methods[33];
    private static final Method inverse = methods[34];
    private static final Method det = methods[35];
    private static final Method rank = methods[36];
    private static final Method cond = methods[37];
    private static final Method trace = methods[38];
    private static final Method random = methods[39];
    private static final Method identity = methods[40];
    private static final Method print1 = methods[41];
    private static final Method print2 = methods[42];
    private static final Method print3 = methods[43];
    private static final Method print4 = methods[44];
    private static final Method read = methods[45];
    private static final Method chol = methods[46];
    private static final Method eig = methods[47];
    private static final Method lu = methods[48];
    private static final Method qr = methods[49];
    private static final Method svd = methods[50];
    private static final Constructor[] constructors = JamaMatrix.constructConstructors();
    private static final Constructor intintMatrix = constructors[0];
    private static final Constructor doubleMatrix = constructors[1];
    private Object stash = null;

    private static FunctionType constructFunction() {
        try {
            RealTupleType tuple = new RealTupleType(matrix_row, matrix_column);
            FunctionType function = new FunctionType(tuple, matrix_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] cs = new Class[6];
        try {
            cs[0] = Class.forName("Jama.Matrix");
            cs[1] = Class.forName("Jama.CholeskyDecomposition");
            cs[2] = Class.forName("Jama.EigenvalueDecomposition");
            cs[3] = Class.forName("Jama.LUDecomposition");
            cs[4] = Class.forName("Jama.QRDecomposition");
            cs[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return cs;
    }

    private static Class constructMatrixClass() {
        try {
            Class<?> c = Class.forName("Jama.Matrix");
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
    }

    private static Method[] constructMethods() {
        Method[] ms = new Method[51];
        try {
            Class[] param = new Class[]{};
            ms[0] = classMatrix.getMethod("getColumnDimension", param);
            ms[1] = classMatrix.getMethod("getRowDimension", param);
            ms[2] = classMatrix.getMethod("getArray", param);
            param = new Class[]{Integer.TYPE, Integer.TYPE};
            ms[3] = classMatrix.getMethod("get", param);
            param = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            ms[4] = classMatrix.getMethod("getMatrix", param);
            param = new Class[]{int[].class, int[].class};
            ms[5] = classMatrix.getMethod("getMatrix", param);
            param = new Class[]{Integer.TYPE, Integer.TYPE, int[].class};
            ms[6] = classMatrix.getMethod("getMatrix", param);
            param = new Class[]{int[].class, Integer.TYPE, Integer.TYPE};
            ms[7] = classMatrix.getMethod("getMatrix", param);
            param = new Class[]{Integer.TYPE, Integer.TYPE, Double.TYPE};
            ms[8] = classMatrix.getMethod("set", param);
            param = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, classMatrix};
            ms[9] = classMatrix.getMethod("setMatrix", param);
            param = new Class[]{int[].class, int[].class, classMatrix};
            ms[10] = classMatrix.getMethod("setMatrix", param);
            param = new Class[]{Integer.TYPE, Integer.TYPE, int[].class, classMatrix};
            ms[11] = classMatrix.getMethod("setMatrix", param);
            param = new Class[]{int[].class, Integer.TYPE, Integer.TYPE, classMatrix};
            ms[12] = classMatrix.getMethod("setMatrix", param);
            param = new Class[]{};
            ms[13] = classMatrix.getMethod("transpose", param);
            ms[14] = classMatrix.getMethod("norm1", param);
            ms[15] = classMatrix.getMethod("norm2", param);
            ms[16] = classMatrix.getMethod("normInf", param);
            ms[17] = classMatrix.getMethod("normF", param);
            ms[18] = classMatrix.getMethod("uminus", param);
            param = new Class[]{classMatrix};
            ms[19] = classMatrix.getMethod("plus", param);
            ms[20] = classMatrix.getMethod("plusEquals", param);
            ms[21] = classMatrix.getMethod("minus", param);
            ms[22] = classMatrix.getMethod("minusEquals", param);
            ms[23] = classMatrix.getMethod("arrayTimes", param);
            ms[24] = classMatrix.getMethod("arrayTimesEquals", param);
            ms[25] = classMatrix.getMethod("arrayRightDivide", param);
            ms[26] = classMatrix.getMethod("arrayRightDivideEquals", param);
            ms[27] = classMatrix.getMethod("arrayLeftDivide", param);
            ms[28] = classMatrix.getMethod("arrayLeftDivideEquals", param);
            param = new Class[]{Double.TYPE};
            ms[29] = classMatrix.getMethod("times", param);
            ms[30] = classMatrix.getMethod("timesEquals", param);
            param = new Class[]{classMatrix};
            ms[31] = classMatrix.getMethod("times", param);
            ms[32] = classMatrix.getMethod("solve", param);
            ms[33] = classMatrix.getMethod("solveTranspose", param);
            param = new Class[]{};
            ms[34] = classMatrix.getMethod("inverse", param);
            ms[35] = classMatrix.getMethod("det", param);
            ms[36] = classMatrix.getMethod("rank", param);
            ms[37] = classMatrix.getMethod("cond", param);
            ms[38] = classMatrix.getMethod("trace", param);
            param = new Class[]{Integer.TYPE, Integer.TYPE};
            ms[39] = classMatrix.getMethod("random", param);
            ms[40] = classMatrix.getMethod("identity", param);
            ms[41] = classMatrix.getMethod("print", param);
            param = new Class[]{PrintWriter.class, Integer.TYPE, Integer.TYPE};
            ms[42] = classMatrix.getMethod("print", param);
            param = new Class[]{NumberFormat.class, Integer.TYPE};
            ms[43] = classMatrix.getMethod("print", param);
            param = new Class[]{PrintWriter.class, NumberFormat.class, Integer.TYPE};
            ms[44] = classMatrix.getMethod("print", param);
            param = new Class[]{BufferedReader.class};
            ms[45] = classMatrix.getMethod("read", param);
            param = new Class[]{};
            ms[46] = classMatrix.getMethod("chol", param);
            ms[47] = classMatrix.getMethod("eig", param);
            ms[48] = classMatrix.getMethod("lu", param);
            ms[49] = classMatrix.getMethod("qr", param);
            ms[50] = classMatrix.getMethod("svd", param);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return ms;
    }

    private static Constructor[] constructConstructors() {
        Constructor[] cs = new Constructor[2];
        try {
            Class[] param = new Class[]{Integer.TYPE, Integer.TYPE};
            cs[0] = classMatrix.getConstructor(param);
            param = new Class[]{double[][].class};
            cs[1] = classMatrix.getConstructor(param);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return cs;
    }

    public static JamaMatrix convertToMatrix(FlatField field) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        double[][] range;
        Object samples;
        int[] lengths;
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        if (field instanceof JamaMatrix) {
            return (JamaMatrix)field;
        }
        FunctionType ftype = (FunctionType)field.getType();
        Set set = field.getDomainSet();
        Gridded2DSet grid = null;
        if (set instanceof Gridded2DSet) {
            grid = (Gridded2DSet)set;
        } else if (set instanceof GriddedSet && set.getDimension() == 2) {
            lengths = ((GriddedSet)set).getLengths();
            samples = set.getSamples(false);
            grid = new Gridded2DSet(set.getType(), (float[][])samples, lengths[0], lengths[1], set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors());
        } else if (set instanceof Gridded1DSet) {
            lengths = ((Gridded1DSet)set).getLengths();
            samples = set.getSamples(false);
            float[] dummies = new float[lengths[0]];
            for (int i = 0; i < lengths[0]; ++i) {
                dummies[i] = 0.0f;
            }
            samples = new float[][]{samples[0], dummies};
            RealType rt1 = (RealType)((SetType)set.getType()).getDomain().getComponent(0);
            RealType rt0 = RealType.getRealType("dummy");
            RealTupleType rtt = new RealTupleType(rt1, rt0);
            grid = new Gridded2DSet((MathType)rtt, (float[][])samples, lengths[0], 1, null, null, null);
            ftype = new FunctionType(rtt, ftype.getRange());
        } else {
            return null;
        }
        int[] dims = grid.getLengths();
        int rows = dims[0];
        int cols = dims[1];
        double[][] entries = new double[rows][cols];
        try {
            range = field.getValues(false);
        }
        catch (VisADException exc) {
            return null;
        }
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                entries[i][j] = range[0][cols * i + j];
            }
        }
        CoordinateSystem rc = null;
        try {
            CoordinateSystem[] r = field.getRangeCoordinateSystem();
            rc = r[0];
        }
        catch (Exception e) {
            // empty catch block
        }
        CoordinateSystem[] rcs = null;
        try {
            int n = ((TupleType)ftype.getRange()).getDimension();
            rcs = new CoordinateSystem[n];
            for (int i = 0; i < n; ++i) {
                CoordinateSystem[] r = field.getRangeCoordinateSystem(i);
                rcs[i] = r[0];
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Set[] rangeSets = field.getRangeSets();
        Unit[] units = null;
        try {
            Unit[][] us = field.getRangeUnits();
            if (us != null) {
                int n = us.length;
                for (int i = 0; i < n; ++i) {
                    units[i] = us[i][0];
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Object m = doubleMatrix.newInstance(new Object[]{entries});
        return new JamaMatrix(m, ftype, grid, rc, rcs, rangeSets, units);
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        double[][] e1 = new double[][]{{3.0, 4.0, 5.0}, {10.0, 18.0, 6.0}, {2.0, -1.0, 0.0}};
        double[][] e2 = new double[][]{{6.0, 4.0, 2.0}, {-4.0, -3.0, -2.0}, {1.0, 1.0, 1.0}};
        try {
            System.out.println("get = " + get);
            System.out.println("getMatrix2 = " + getMatrix2);
            JamaMatrix m1 = new JamaMatrix(e1);
            JamaMatrix m2 = new JamaMatrix(e2);
            JamaMatrix m3 = JamaMatrix.convertToMatrix((FlatField)m1.add(m2));
            JamaMatrix m4 = m1.plus(m2);
            System.out.println("m1.get(1, 1) = " + m1.get(1, 1));
            System.out.println("m1:");
            m1.print(1, 0);
            System.out.println("m2:");
            m2.print(1, 0);
            System.out.println("m3 = m1 + m2 (VisAD):");
            m3.print(1, 0);
            System.out.println("m4 = m1 + m2 (JAMA):");
            m4.print(1, 0);
            System.out.println("m4 = " + m4);
            JamaSingularValueDecomposition svd4 = m4.svd();
            System.out.println("m4 svd U:");
            svd4.getU().print(1, 0);
            System.out.println("m4 svd S:");
            svd4.getS().print(1, 0);
            System.out.println("m4 svd V:");
            svd4.getV().print(1, 0);
            JamaQRDecomposition qr4 = m4.qr();
            System.out.println("m4 qr Q:");
            qr4.getQ().print(1, 0);
            System.out.println("m4 qr R:");
            qr4.getR().print(1, 0);
            JamaLUDecomposition lu4 = m4.lu();
            System.out.println("m4 lu L:");
            lu4.getL().print(1, 0);
            System.out.println("m4 lu U:");
            lu4.getU().print(1, 0);
            JamaEigenvalueDecomposition ev4 = m4.eig();
            System.out.println("m4 eig D:");
            ev4.getD().print(1, 0);
            System.out.println("m4 eig V:");
            ev4.getV().print(1, 0);
            JamaCholeskyDecomposition chol4 = m4.chol();
            System.out.println("m4 chol L:");
            chol4.getL().print(1, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Integer2DSet getDomainSet(Object matrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        if (!classMatrix.isInstance(matrix)) {
            throw new VisADException("matrix must be an instance of Jama.Matrix");
        }
        int rows = (Integer)getRowDimension.invoke(matrix, new Object[0]);
        int cols = (Integer)getColumnDimension.invoke(matrix, new Object[0]);
        return new Integer2DSet(rows, cols);
    }

    public JamaMatrix(int rows, int cols) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(intintMatrix.newInstance(new Integer(rows), new Integer(cols)), null, null, null, null, null, null);
    }

    public JamaMatrix(double[][] entries) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(doubleMatrix.newInstance(new Object[]{entries}), null, null, null, null, null, null);
    }

    public JamaMatrix(Object matrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrix, null, null, null, null, null, null);
    }

    public JamaMatrix(Object matrix, FunctionType type, Gridded2DSet domain_set) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrix, type, domain_set, null, null, null, null);
    }

    public JamaMatrix(Object matrix, CoordinateSystem range_coord_sys, CoordinateSystem[] range_coord_syses, Set[] range_sets, Unit[] units) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrix, null, null, range_coord_sys, range_coord_syses, range_sets, units);
    }

    public JamaMatrix(Object matrix, FunctionType type, Gridded2DSet domain_set, CoordinateSystem range_coord_sys, CoordinateSystem[] range_coord_syses, Set[] range_sets, Unit[] units) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(type == null ? matrixType : type, domain_set == null ? JamaMatrix.getDomainSet(matrix) : domain_set, range_coord_sys, range_coord_syses, range_sets, units);
        if (type != null && !matrixType.equalsExceptName(type)) {
            throw new VisADException("JamaMatrix: MathType must be of the form ((x, y) -> z)");
        }
        this.setMatrix(matrix);
    }

    void setStash(Object s) {
        this.stash = s;
    }

    Object getStash() {
        return this.stash;
    }

    public Object getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Object matrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        if (!classMatrix.isInstance(matrix)) {
            throw new VisADException("matrix must be an instance of Jama.Matrix");
        }
        int rows = (Integer)getRowDimension.invoke(matrix, new Object[0]);
        int cols = (Integer)getColumnDimension.invoke(matrix, new Object[0]);
        double[][] entries = (double[][])getArray.invoke(matrix, new Object[0]);
        double[][] range = new double[1][rows * cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                range[0][cols * i + j] = entries[i][j];
            }
        }
        try {
            this.setSamples(range, false);
        }
        catch (RemoteException exc) {
            // empty catch block
        }
        this.matrix = matrix;
    }

    public void setMatrix(double[][] entries) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this.setMatrix(doubleMatrix.newInstance(new Object[]{entries}));
    }

    public int getRowDimension() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        int rows = (Integer)getRowDimension.invoke(this.matrix, new Object[0]);
        return rows;
    }

    public int getColumnDimension() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        int cols = (Integer)getColumnDimension.invoke(this.matrix, new Object[0]);
        return cols;
    }

    public double get(int i, int j) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)get.invoke(this.matrix, new Integer(i), new Integer(j));
        return val;
    }

    public JamaMatrix getMatrix(int i0, int i1, int j0, int j1) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = getMatrix1.invoke(this.matrix, new Integer(i0), new Integer(i1), new Integer(j0), new Integer(j1));
        return new JamaMatrix(m);
    }

    public JamaMatrix getMatrix(int[] r, int[] c) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = getMatrix2.invoke(this.matrix, r, c);
        return new JamaMatrix(m);
    }

    public JamaMatrix getMatrix(int i0, int i1, int[] c) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = getMatrix1.invoke(this.matrix, new Integer(i0), new Integer(i1), c);
        return new JamaMatrix(m);
    }

    public JamaMatrix getMatrix(int[] r, int j0, int j1) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = getMatrix1.invoke(this.matrix, r, new Integer(j0), new Integer(j1));
        return new JamaMatrix(m);
    }

    public void set(int i, int j, double s) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        set.invoke(this.matrix, new Integer(i), new Integer(j), new Double(s));
        this.setMatrix(this.matrix);
    }

    public void setMatrix(int i0, int i1, int j0, int j1, JamaMatrix X) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        setMatrix1.invoke(this.matrix, new Integer(i0), new Integer(i1), new Integer(j0), new Integer(j1), X.getMatrix());
        this.setMatrix(this.matrix);
    }

    public void setMatrix(int[] r, int[] c, JamaMatrix X) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        setMatrix2.invoke(this.matrix, r, c, X.getMatrix());
        this.setMatrix(this.matrix);
    }

    public void setMatrix(int[] r, int j0, int j1, JamaMatrix X) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        setMatrix3.invoke(this.matrix, r, new Integer(j0), new Integer(j1), X.getMatrix());
        this.setMatrix(this.matrix);
    }

    public void setMatrix(int i0, int i1, int[] c, JamaMatrix X) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        setMatrix4.invoke(this.matrix, new Integer(i0), new Integer(i1), c, X.getMatrix());
        this.setMatrix(this.matrix);
    }

    public JamaMatrix transpose() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = transpose.invoke(this.matrix, new Object[0]);
        return new JamaMatrix(m);
    }

    public double norm1() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)norm1.invoke(this.matrix, new Object[0]);
        return val;
    }

    public double norm2() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)norm2.invoke(this.matrix, new Object[0]);
        return val;
    }

    public double normInf() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)normInf.invoke(this.matrix, new Object[0]);
        return val;
    }

    public double normF() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)normF.invoke(this.matrix, new Object[0]);
        return val;
    }

    public JamaMatrix uminus() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = uminus.invoke(this.matrix, new Object[0]);
        return new JamaMatrix(m);
    }

    public JamaMatrix plus(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = plus.invoke(this.matrix, B.getMatrix());
        return new JamaMatrix(m);
    }

    public JamaMatrix plusEquals(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        plusEquals.invoke(this.matrix, B.getMatrix());
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix minus(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = minus.invoke(this.matrix, B.getMatrix());
        return new JamaMatrix(m);
    }

    public JamaMatrix minusEquals(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        minusEquals.invoke(this.matrix, B.getMatrix());
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix arrayTimes(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = arrayTimes.invoke(this.matrix, B.getMatrix());
        return new JamaMatrix(m);
    }

    public JamaMatrix arrayTimesEquals(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        arrayTimesEquals.invoke(this.matrix, B.getMatrix());
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix arrayRightDivide(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = arrayRightDivide.invoke(this.matrix, B.getMatrix());
        return new JamaMatrix(m);
    }

    public JamaMatrix arrayRightDivideEquals(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        arrayRightDivideEquals.invoke(this.matrix, B.getMatrix());
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix arrayLeftDivide(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = arrayLeftDivide.invoke(this.matrix, B.getMatrix());
        return new JamaMatrix(m);
    }

    public JamaMatrix arrayLeftDivideEquals(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        arrayLeftDivideEquals.invoke(this.matrix, B.getMatrix());
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix times(double s) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = times1.invoke(this.matrix, new Double(s));
        return new JamaMatrix(m);
    }

    public JamaMatrix timesEquals(double s) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        timesEquals.invoke(this.matrix, new Double(s));
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix times(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = times2.invoke(this.matrix, B.getMatrix());
        return new JamaMatrix(m);
    }

    public JamaMatrix solve(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = solve.invoke(this.matrix, B.getMatrix());
        return new JamaMatrix(m);
    }

    public JamaMatrix solveTranspose(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = solveTranspose.invoke(this.matrix, B.getMatrix());
        return new JamaMatrix(m);
    }

    public JamaMatrix inverse() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = inverse.invoke(this.matrix, new Object[0]);
        return new JamaMatrix(m);
    }

    public double det() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)det.invoke(this.matrix, new Object[0]);
        return val;
    }

    public int rank() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        int val = (Integer)rank.invoke(this.matrix, new Object[0]);
        return val;
    }

    public double cond() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)cond.invoke(this.matrix, new Object[0]);
        return val;
    }

    public double trace() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)trace.invoke(this.matrix, new Object[0]);
        return val;
    }

    public static JamaMatrix random(int m, int n) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object mat = random.invoke(null, new Integer(m), new Integer(n));
        return new JamaMatrix(mat);
    }

    public static JamaMatrix identity(int m, int n) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object mat = identity.invoke(null, new Integer(m), new Integer(n));
        return new JamaMatrix(mat);
    }

    public void print(int w, int d) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        print1.invoke(this.matrix, new Integer(w), new Integer(d));
    }

    public void print(PrintWriter output, int w, int d) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        print2.invoke(this.matrix, output, new Integer(w), new Integer(d));
    }

    public void print(NumberFormat format, int width) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        print3.invoke(this.matrix, format, new Integer(width));
    }

    public void print(PrintWriter output, NumberFormat format, int width) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        print4.invoke(this.matrix, output, format, new Integer(width));
    }

    public static JamaMatrix read(BufferedReader input) throws IOException, VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = read.invoke(null, input);
        return new JamaMatrix(m);
    }

    public JamaCholeskyDecomposition chol() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object c = chol.invoke(this.matrix, new Object[0]);
        return new JamaCholeskyDecomposition(c, false);
    }

    public JamaEigenvalueDecomposition eig() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object e = eig.invoke(this.matrix, new Object[0]);
        return new JamaEigenvalueDecomposition(e, false);
    }

    public JamaLUDecomposition lu() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object l = lu.invoke(this.matrix, new Object[0]);
        return new JamaLUDecomposition(l, false);
    }

    public JamaQRDecomposition qr() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object q = qr.invoke(this.matrix, new Object[0]);
        return new JamaQRDecomposition(q, false);
    }

    public JamaSingularValueDecomposition svd() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object s = svd.invoke(this.matrix, new Object[0]);
        return new JamaSingularValueDecomposition(s, false);
    }
}

