/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"
#include "rename.h"

#include "entry.h"
#include "icons.h"
#include "input.h"
#include "misc.h"
#include "monitor.h"
#include "widgets.h"
#include "remove.h"


G_MODULE_EXPORT
int rename_it(GtkTreeView * treeview, GtkTreeIter * iter, char *nfile, char *ofile)
{

    struct stat st;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_entry_t *en;
    gboolean overwrite=FALSE;

    if(!nfile || !ofile)
	assert_not_reached();

    if(!set_load_wait())
	return FALSE;

    if(lstat(nfile, &st) >= 0)
    {
	 /* dir over dir. file over dir, file over file, dir over file:
	 * keep retrying if cannot unlink... */
	/*if (!query_rm(nfile, ofile,overwrite)){*/
	if (!query_rm(nfile, ofile,TRUE)){
    		    unset_load_wait();
		    return FALSE;
	}
	overwrite=TRUE;
    }
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);


    if(rename(ofile, nfile) == -1)
    {
	print_diagnostics("xfce/error", strerror(errno), ":\n", ofile, " --> ", nfile,  "\n", NULL);
	print_status("xfce/error", strerror(errno), NULL);
        unset_load_wait();
	return FALSE;
    }
    else {
	gboolean duplicate=FALSE;
	tree_entry_t *c_en;
	GtkTreeIter parent,child;
 	if (overwrite) {
	  /* to eliminate duplicate entries */
	  if(gtk_tree_model_iter_parent(treemodel, &parent, iter))
	  {
	    if(gtk_tree_model_iter_children(treemodel, &child, &parent))
	      do {
	        gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
		/*printf("DBG:%s -- %s\n",nfile,c_en->path);*/
	        if (c_en && c_en->path && strcmp(nfile,c_en->path)==0){
		  duplicate=TRUE;
		  break;
	        }
	      } while (gtk_tree_model_iter_next(treemodel, &child));
	    }
	}        
	g_free(en->path);
        en->path=g_strdup(nfile);
        update_text_cell_for_row(NAME_COLUMN,treemodel, iter, (FILENAME(en)));
	if (overwrite) {
	    if (duplicate) remove_row(treemodel, &child,NULL,c_en);
	    unset_load_wait();	   
	    local_monitor(TRUE);
	    return TRUE;
	} 
    }

    unset_load_wait();
    return TRUE;

}



/*   callback  */

G_MODULE_EXPORT
void on_rename_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tree_entry_t *en;
    GtkTreeIter iter;
    en = get_selected_entry(&iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status("xfce/error", strerror(EINVAL), NULL);
	return;
    }
    show_input(RENAME_INPUT);

}
