// DistributionManagerInterface.hh
//
// Copyright (C) 2002, 2003, 2005 Rob Caelers <robc@krandor.org>
// All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// $Id: DistributionManagerInterface.hh,v 1.2 2005/09/23 19:22:32 rcaelers Exp $
//

#ifndef DISTRIBUTIOMANAGERINTERFACE_HH
#define DISTRIBUTIOMANAGERINTERFACE_HH

#include <string>
using namespace std;

class DistributionLogListener;

class DistributionManagerInterface
{
public:
  virtual ~DistributionManagerInterface() {}
  
  virtual bool is_master() const = 0;
  virtual int get_number_of_peers() = 0;
  virtual bool connect(string url) = 0;

  virtual bool disconnect_all() = 0;
  virtual bool reconnect_all() = 0;

  virtual bool add_log_listener(DistributionLogListener *listener) = 0;
  virtual bool remove_log_listener(DistributionLogListener *listener) = 0;
  virtual list<string> get_logs() const = 0;

  virtual bool add_peer(string peer) = 0;
  virtual bool remove_peer(string peer) = 0;
  
  virtual void set_peers(string peers, bool connect = true) = 0;
  virtual list<string> get_peers() const = 0;

  virtual bool get_enabled() const = 0;
  virtual void set_enabled(bool b) = 0;

  virtual string get_username() const = 0;
  virtual void set_username(string name) = 0;

  virtual string get_password() const = 0;
  virtual void set_password(string name) = 0;

  virtual int get_port() const = 0;
  virtual void set_port(int v) = 0;

  virtual int get_reconnect_attempts() const = 0;
  virtual void set_reconnect_attempts(int v) = 0;

  virtual int get_reconnect_interval() const = 0;
  virtual void set_reconnect_interval(int v) = 0;
};

#endif // DISTRIBUTIOMANAGERINTERFACE_HH
