#include "options.h"
#include <iostream>

#include <qapplication.h>

using namespace std;


Option::Option()
{
	name="";
	sName="";
	lName="";
	type=SwitchOption;
	sarg="";
	active=false;
}

void Option::set(const QString &n, const OptionType &t, const QString &s, const QString &l)
{
	sName="-"+s;
	lName="--"+l;
	type=t;
	name=n;
}

QString Option::getName () { return name; }
QString Option::getShort () { return sName; }
QString Option::getLong() { return lName; }
OptionType Option::getType() { return type; }
void Option::setArg(const QString& s) { sarg=s; }
QString Option::getArg() { return sarg; }	
void Option::setActive() { active=true; }	
bool Option::isActive() { return active; }

///////////////////////////////////////////////////////////////
Options::Options() {}	

int Options::parse()
{
	QStringList arglist;
	int i=0;
	while (i<qApp->argc())
	{	
		arglist.append (qApp->argv()[i]);
		i++;
	}

	// Get program name
	progname=arglist.first();
	arglist.pop_front();

	// Work through rest of options
	bool isFile;
	OptionList::iterator itopt;
	QStringList::iterator itarg;
	itarg=arglist.begin();
	while (itarg!=arglist.end())
	{
		isFile=true;
		if ((*itarg).left(1)=="-")
		{
			// Compare given option to all defined options
			itopt=optlist.begin();
			while (itopt!=optlist.end())
			{
				if ((*itarg)==(*itopt).getShort() || 
					(*itarg)==(*itopt).getLong())
				{	
					(*itopt).setActive();
					isFile=false;
					if ((*itopt).getType()==StringOption)
					{
						itarg++;
						if (itarg==arglist.end())
						{
							cout << "Error: argument to option missing\n";
							return 1;
						}
						(*itopt).setArg (*itarg);
						isFile=false;
					}
					break;
				} 
				itopt++;
			}
			if (isFile)
			{
				cout << "Error: Unknown argument "<<*itarg<<endl;
				return 1;
			}
		} else
			filelist.append (*itarg);
		itarg++;
	}
	return 0;
}

void Options::add (const QString &n, const OptionType &t=SwitchOption, const QString &s="", const QString &l="")
{
	Option o;
	o.set (n,t,s,l);
	optlist.append (o);
}

void Options::setHelpText (const QString &s)
{
	helptext=s;
}
	
QString Options::getHelpText ()
{
	return helptext;
}

QString Options::getProgramName()
{
	return progname;
}

QStringList Options::getFileList ()
{
	return filelist;
}

bool Options::isOn(const QString &s)
{
	OptionList::iterator it;
	for ( it = optlist.begin(); it != optlist.end(); ++it )
		if ((*it).getName()==s && (*it).isActive() )
			return true;
	return false;
}

QString Options::getArg(const QString &s)
{
	OptionList::iterator it;
	for ( it = optlist.begin(); it != optlist.end(); ++it )
	{
		if ((*it).getName()==s)
			return (*it).getArg();
	}	
	return "";
}
