##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time

import netsvc
from osv import fields,osv,orm

import crm_operators

class crm_case_categ(osv.osv):
	_name = "crm.case.categ"
	_description = "Category of case"
	_columns = {
		'name': fields.char('Case Category Name', size=64, required=True),
		'case_type': fields.selection([('sale','Sale Case'),('support','Support Case (Helpdesk)'),('vendor','Purchase Case')], 'Case Type'),
	}
crm_case_categ()

def _links_get(self, cr, uid, context={}):
	obj = self.pool.get('res.request.link')
	ids = obj.search(cr, uid, [])
	res = obj.read(cr, uid, ids, ['object', 'name'], context)
	return [(r['object'], r['name']) for r in res]

class crm_case(osv.osv):
	_name = "crm.case"
	_description = "Case"
	_columns = {
		'id': fields.integer('Case ID', readonly=True),
		'name': fields.char('Case Description',size=64, required=True),
		'priority': fields.selection([('very low','Very Low'),('low','Low'),('medium','Medium'),('high','High'),('very high','Very High')], 'Priority'),
		'active': fields.boolean('Active'),
		'description': fields.text('Description'),
		'type': fields.selection([('sale','Sale Case'),('support','Support Case (Helpdesk)'),('purchase','Purchase Case')], 'Case Type'),
		'categ_id': fields.many2one('crm.case.categ', 'Category', domain="[('case_type','=',type)]", relate=True),
		'planned_revenue': fields.float('Planned Revenue'),
		'planned_cost': fields.float('Planned Costs'),
		'probability': fields.float('Probability (0.50)'),
		'document': fields.char('Document', size=64),
		'partner_id': fields.many2one('res.partner', 'Partner', relate=True),
		'partner_address_id': fields.many2one('res.partner.address', 'Contact', domain="[('partner_id','=',partner_id)]"),
		'som': fields.many2one('res.partner.som', 'State of Mind'),
		'date': fields.datetime('Date'),
		'date_deadline': fields.date('Date Next Action'),
		'date_closed': fields.date('Date Closed', readonly=True),
		'canal_id': fields.many2one('res.partner.canal', 'Channel', relate=True),
		'user_id': fields.many2one('res.users', 'User Responsible', relate=True),
		'history_line': fields.one2many('crm.case.history', 'case_id', 'Case History'),
		'state': fields.selection([('draft','Draft'),('open','Open'),('cancel', 'Canceled'),('done', 'Closed')], 'State', size=16, readonly=True),
		'ref' : fields.reference('Reference', selection=_links_get, size=128),
		'ref2' : fields.reference('Reference 2', selection=_links_get, size=128)
	}
	_defaults = {
		'active': lambda *a: 1,
		'state': lambda *a: 'draft',
		'priority': lambda *a: 'low',
		'date': lambda *a: time.strftime('%Y-%m-%d %H:%M:%S'),
	}
	_order = 'date_deadline desc, id'
	def case_log(self, cr, uid, ids, *args):
		ptype = {'sale':'customer', 'support':'customer', 'vendor':'supplier'}
		for case in self.read(cr, uid, ids):
			self.pool.get('crm.case.history').create(cr, uid,
					{'name': 'Contact Operation',
					 'description': case['description'],
					 'som': (case['som'] or False) and case['som'][0],
					 'canal_id': (case['canal_id'] or False) and case['canal_id'][0],
					 'user_id': (case['user_id'] or False) and case['user_id'][0],
					 'case_id': case['id']})
		return self.write(cr, uid, ids, {'description':False, 'som':False, 'canal_id': False})

	def case_close(self, cr, uid, ids, *args):
		ptype = {'sale':'customer', 'support':'customer', 'vendor':'supplier'}
		for case in self.read(cr, uid, ids):
			if case['partner_id'] and self.pool.get('res.partner.event.type').check(cr, uid, 'crm_case_close'):
				self.pool.get('res.partner.event').create(cr, uid,
						{'name': 'Close Case: '+case['name'],
						 'som': (case['som'] or False) and case['som'][0],
						 'description': case['description'],
						 'document': case['document'],
						 'partner_id': case['partner_id'][0],
						 'date': time.strftime('%Y-%m-%d %H:%M:%S'),
						 'canal_id': (case['canal_id'] or False) and case['canal_id'][0],
						 'user_id': (case['user_id'] or False) and case['user_id'][0],
						 'partner_type': ptype.get(case['type'], 'customer')})
			self.pool.get('crm.case.history').create(cr, uid,
					{'name': 'Close',
					 'description': case['description'],
					 'som': False,
					 'canal_id': False,
					 'user_id': uid,
					 'case_id': case['id']})
		self.write(cr, uid, ids, {'state':'done', 'date_closed': time.strftime('%Y-%m-%d')})
		return True

	def case_open(self, cr, uid, ids, *args):
		ptype = {'sale':'customer', 'support':'customer', 'vendor':'supplier'}
		for case in self.read(cr, uid, ids):
			if case['partner_id'] and self.pool.get('res.partner.event.type').check(cr, uid, 'crm_case_open'):
				self.pool.get('res.partner.event').create(cr, uid,
						{'name':'Open Case: '+case['name'],
						 'som':(case['som'] or False) and case['som'][0],
						 'description':case['description'],
						 'document':case['document'],
						 'partner_id':case['partner_id'][0],
						 'date':case['date'],
						 'canal_id':(case['canal_id'] or False) and case['canal_id'][0],
						 'user_id':uid,
						 'partner_type':ptype.get(case['type'], 'customer')})
			self.pool.get('crm.case.history').create(cr, uid,
					{'name': 'Open',
					 'description': case['description'],
					 'som': False,
					 'canal_id': False,
					 'user_id': uid,
					 'case_id': case['id']})
		self.write(cr, uid, [case['id']], {'state':'open', 'active':True, 'user_id':uid})
		return True

	def case_requeue(self, cr, uid, ids, *args):
		self.write(cr, uid, ids, {'state':'draft', 'active':True, 'user_id':False})
		for case in self.read(cr, uid, ids):
			self.pool.get('crm.case.history').create(cr, uid, {'name':'Requeue', 'description':case['description'], 'som':False, 'canal_id':False, 'user_id':uid, 'case_id':case['id']})
		return True

	def case_reset(self, cr, uid, ids, *args):
		self.write(cr, uid, ids, {'state':'draft', 'active':True, 'user_id':False})
		return True
crm_case()

class crm_case_history(osv.osv):
	_name = "crm.case.history"
	_description = "Case history"
	_columns = {
		'name': fields.char('Name', size=64),
		'description': fields.text('Description'),
		'som': fields.many2one('res.partner.som', 'State of Mind'),
		'date': fields.date('Date'),
		'canal_id': fields.many2one('res.partner.canal', 'Channel'),
		'user_id': fields.many2one('res.users', 'User Responsible', readonly=True),
		'case_id': fields.many2one('crm.case', 'Case', required=True, ondelete='cascade')
	}
	_defaults = {
		'date': lambda *a: time.strftime('%Y-%m-%d'),
	}
crm_case_history()

class crm_segmentation(osv.osv):
	'''
		A segmentation is a tool to automatically assign categories on partners.
		These assignations are based on criterions.
	'''
	_name = "crm.segmentation"
	_description = "Partner Segmentation"
	_columns = {
		'name': fields.char('Name', size=64, required=True, help='The name of the segmentation.'),
		'description': fields.text('Description'),
		'categ_id': fields.many2one('res.partner.category', 'Partner Category', required=True, help='The partner category that will be added to partners that match the segmentation criterions after computation.'),
		'exclusif': fields.boolean('Exclusive', help='Check if the category is limited to partners that match the segmentation criterions. If checked, remove the category from partners that doesn\'t match segmentation criterions'),
		'state': fields.selection([('not running','Not Running'),('running','Running')], 'Execution State', readonly=True),
		'partner_id': fields.integer('Max Partner ID processed'),
		'segmentation_line': fields.one2many('crm.segmentation.line', 'segmentation_id', 'Criteria', required=True),
		'som_interval': fields.integer('Days per Periode', help="A period is the average number of days between two cycle of sale or purchase for this segmentation. It's mainly used to detect if a partner has not purchased or buy for a too long time, so we suppose that his state of mind has decreased because he probably bought goods to another supplier. Use this functionnality for recurring businesses."),
		'som_interval_max': fields.integer('Max Interval', help="The computation is made on all events that occured during this interval, the past X periods."),
		'som_interval_decrease': fields.float('Decrease (0>1)', help="If the partner has not purchased (or buied) during a period, decrease the state of mind by this factor. It\'s a multiplication"),
		'som_interval_default': fields.float('Default (0=None)', help="Default state of mind for period preceeding the 'Max Interval' computation. This is the starting state of mind by default if the partner has no event."),
	}
	_defaults = {
		'partner_id': lambda *a: 0,
		'state': lambda *a: 'not running',
		'som_interval_max': lambda *a: 3,
		'som_interval_decrease': lambda *a: 0.8,
		'som_interval_default': lambda *a: 0.5
	}

	def process_continue(self, cr, uid, ids, start=False):
		categs = self.read(cr,uid,ids,['categ_id','exclusif','partner_id'])
		for categ in categs:
			if start:
				if categ['exclusif']:
					cr.execute('delete from res_partner_category_rel where category_id=%d', (categ['categ_id'][0],))
			id = categ['id']
			cr.execute('select id from crm_segmentation_line where segmentation_id=%d', (id,))
			line_ids = [x[0] for x in cr.fetchall()]
			cr.execute('select id from res_partner order by id limit 100 offset %d', (categ['partner_id'],))
			partners = cr.fetchall()
			ok = []
			for (pid,) in partners:
				if self.pool.get('crm.segmentation.line').test(cr, uid, line_ids, pid):
					ok.append(pid)

			for partner_id in ok:
				cr.execute('insert into res_partner_category_rel (category_id,partner_id) values (%d,%d)', (categ['categ_id'][0],partner_id))
			cr.commit()

			if len(partners)==100:
				self.write(cr, uid, [id], {'partner_id':categ['partner_id']+100})
				self.process_continue(cr, uid, [id])
			self.write(cr, uid, [id], {'state':'not running', 'partner_id':0})
			cr.commit()
		return True

	def process_stop(self, cr, uid, ids, *args):
		return self.write(cr, uid, ids, {'state':'not running', 'partner_id':0})

	def process_start(self, cr, uid, ids, *args):
		self.write(cr, uid, ids, {'state':'running', 'partner_id':0})
		return self.process_continue(cr, uid, ids, start=True)
crm_segmentation()

class crm_segmentation_line(osv.osv):
	_name = "crm.segmentation.line"
	_description = "Segmentation line"
	_columns = {
		'name': fields.char('Rule Name', size=64, required=True),
		'segmentation_id': fields.many2one('crm.segmentation', 'Segmentation'),
		'expr_name': fields.selection([('sale','Sale Amount'),('som','State of Mind'),('purchase','Purchase Amount')], 'Control Variable', size=64, required=True),
		'expr_operator': fields.selection([('<','<'),('=','='),('>','>')], 'Operator', required=True),
		'expr_value': fields.float('Value', required=True),
		'operator': fields.selection([('and','Mandatory Expression'),('or','Optional Expression')],'Mandatory / Optionnal', required=True),
	}
	_defaults = {
		'expr_name': lambda *a: 'sale',
		'expr_operator': lambda *a: '>',
		'operator': lambda *a: 'and'
	}
	def test(self, cr, uid, ids, partner_id):
		expression = {'<': lambda x,y: x<y, '=':lambda x,y:x==y, '>':lambda x,y:x>y}
		ok = False
		lst = self.read(cr, uid, ids)
		for l in lst:
			if l['expr_name']=='som':
				datas = self.pool.get('crm.segmentation').read(cr, uid, [l['segmentation_id'][0]], ['som','som_interval','som_interval_max','som_interval_default', 'som_interval_decrease'])
				value = crm_operators.som(cr, uid, partner_id, datas[0])
			elif l['expr_name']=='sale':
				cr.execute('select sum(l.price_unit*l.quantity) from account_invoice_line l left join account_invoice i on (l.invoice_id=i.id) where i.partner_id=%d', (partner_id,))
				value = cr.fetchone()[0] or 0.0
			elif l['expr_name']=='purchase':
				cr.execute('select sum(l.price_unit*l.quantity) from account_invoice_line l left join account_invoice i on (l.invoice_id=i.id) where i.partner_id=%d', (partner_id,))
				value = cr.fetchone()[0] or 0.0
			res = expression[l['expr_operator']](value, l['expr_value'])
			if (not res) and (l['operator']=='and'):
				return False
			if res:
				return True
		return True
crm_segmentation_line()



