/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

int geramail(const char *dirname, int debug, const char *outdir, int userip, const char *email, const char *TempDir)
{

   FILE *fp_in, *fp_top1, *fp_top2, *fp_top3;
   long long int ttnbytes=0, ttnacc=0, tnacc=0;
   long long int tnbytes=0, ttnelap=0, tnelap=0;
   float perc=0.00;
   float perc2=0.00;
   int posicao=0;
   char olduser[MAXLEN], csort[MAXLEN], period[MAXLEN], arqper[MAXLEN];
   char wger[MAXLEN], top1[MAXLEN], top2[MAXLEN], top3[MAXLEN], user[MAXLEN], nacc[20], nbytes[20], url[MAXLEN], tusr[MAXLEN];
   char ip[MAXLEN], hora[9], data[15], elap[16], user2[MAXLEN], wperc[8], wperc2[8];
   char strip1[MAXLEN], strip2[MAXLEN], strip3[MAXLEN], strip4[MAXLEN], strip5[MAXLEN], strip6[MAXLEN], strip7[MAXLEN];
   char incac[30], oucac[30];
   int totuser=0;
   time_t t;
   struct tm *local;
   int cstatus;
   char warea[MAXLEN];
   struct getwordstruct gwarea;

   strcpy(wger,dirname);
   strcpy(top1,dirname);
   strcpy(top2,dirname);
   strcpy(top3,dirname);
   strcpy(tusr,dirname);
   strcat(wger,"/sarg-general");
   strcat(top1,"/top");
   strcat(top2,"/top.tmp");
   strcat(top3,"/report");
   strcat(tusr,"/sarg-users");

   if((fp_in=fopen(wger,"r"))==NULL) {
      fprintf(stderr, "SARG: (email) %s: %s\n",text[45],wger);
      exit(1);
   }

   if((fp_top1=fopen(top1,"w"))==NULL) {
      fprintf(stderr, "SARG: (email) %s: %s\n",text[45],top1);
      exit(1);
   }

   if((fp_top2=fopen(top2,"w"))==NULL) {
      fprintf(stderr, "SARG: (email) %s: %s\n",text[45],top2);
      exit(1);
   }

   olduser[0]='\0';
   totuser=0;

   while(fgets(warea,sizeof(warea),fp_in)) {
      getword_start(&gwarea,warea);
      if (getword(user,sizeof(user),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken user in your %s file.\n",wger);
         exit(1);
      }
      if(strcmp(user,"TOTAL") == 0) {
         continue;
      }
      if (getword(nacc,sizeof(nacc),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken number of access in your %s file.\n",wger);
         exit(1);
      }
      if (getword(nbytes,sizeof(nbytes),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken number of bytes in your %s file.\n",wger);
         exit(1);
      }
      if (getword(url,sizeof(url),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken url in your %s file.\n",wger);
         exit(1);
      }
      if (getword(ip,sizeof(ip),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken source IP address in your %s file.\n",wger);
         exit(1);
      }
      if (getword(hora,sizeof(hora),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken time in your %s file.\n",wger);
         exit(1);
      }
      if (getword(data,sizeof(data),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken date in your %s file.\n",wger);
         exit(1);
      }
      if (getword(elap,sizeof(elap),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken elapsed time in your %s file.\n",wger);
         exit(1);
      }
      if (getword(incac,sizeof(incac),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken in cache column in your %s file.\n",wger);
         exit(1);
      }
      if (getword(oucac,sizeof(oucac),&gwarea,0)<0) {
         printf("SARG: Maybe you have a broken not in cache column in your %s file.\n",wger);
         exit(1);
      }

      if(strcmp(olduser,user) != 0)
      {
         totuser++;

         if (olduser[0] != '\0') {
#if defined(__FreeBSD__)
            fprintf(fp_top2,"%s\t%qu\t%qu\t%qu\n",olduser,tnbytes,tnacc,tnelap);
#elif defined(__alpha) || __ALPHA
            fprintf(fp_top2,"%s\t%ld\t%ld\t%ld\n",olduser,tnbytes,tnacc,tnelap);
#else
            fprintf(fp_top2,"%s\t%lld\t%lld\t%lld\n",olduser,tnbytes,tnacc,tnelap);
#endif
            ttnbytes=ttnbytes+tnbytes;
            ttnacc=ttnacc+tnacc;
            ttnelap=ttnelap+tnelap;
         }
         strcpy(olduser,user);
         tnbytes=0;
         tnacc=0;
         tnelap=0;
      }

      tnbytes=tnbytes+atol(nbytes);
      tnacc=tnacc+atol(nacc);
      tnelap=tnelap+atol(elap);
   }

   if (olduser[0] != '\0') {
#if defined(__FreeBSD__)
      fprintf(fp_top2,"%s\t%qu\t%qu\t%qu\n",olduser,tnbytes,tnacc,tnelap);
#elif defined(__alpha) || __ALPHA
      fprintf(fp_top2,"%s\t%ld\t%ld\t%ld\n",olduser,tnbytes,tnacc,tnelap);
#else
      fprintf(fp_top2,"%s\t%lld\t%lld\t%lld\n",olduser,tnbytes,tnacc,tnelap);
#endif
      ttnbytes=ttnbytes+tnbytes;
      ttnacc=ttnacc+tnacc;
      ttnelap=ttnelap+tnelap;
   }

   fclose(fp_in);
   fclose(fp_top2);

   sprintf(csort,"sort -n -T \"%s\" -r -k 2,2 -o \"%s\" \"%s\"", TempDir, top1, top2);
   cstatus=system(csort);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }

   unlink(top2);

   if((fp_top1=fopen(top1,"a"))==NULL) {
      fprintf(stderr, "SARG: (email) %s: %s\n",text[45],top1);
      exit(1);
   }
#if defined(__FreeBSD__)
   fprintf(fp_top1,"TOTAL\t%qu\t%qu\t%qu\n",ttnbytes,ttnacc,ttnelap);
#elif defined(__alpha) || __ALPHA
   fprintf(fp_top1,"TOTAL\t%ld\t%ld\t%ld\n",ttnbytes,ttnacc,ttnelap);
#else
   fprintf(fp_top1,"TOTAL\t%lld\t%lld\t%lld\n",ttnbytes,ttnacc,ttnelap);
#endif
   fclose(fp_top1);

   /*
   * Obtem o period
   */

   strcpy(arqper,dirname);
   strcat(arqper,"/sarg-period");

   if ((fp_in = fopen(arqper, "r")) == 0){
      fprintf(stderr, "SARG: (email) %s: %s\n",text[45],arqper);
      exit(1);
   }

   if (!fgets(period,sizeof(period),fp_in)) {
      fprintf(stderr,"SARG: (email) read error in %s\n",arqper);
      exit(1);
   }
   fclose(fp_in);

   if((fp_top1=fopen(top1,"r"))==NULL) {
      fprintf(stderr, "SARG: (email) %s: %s\n",text[45],top1);
      exit(1);
   }

   if((fp_top3=fopen(top3,"w"))==NULL) {
      fprintf(stderr, "SARG: (email) %s: %s\n",text[45],top3);
      exit(1);
   }

   strcpy(strip1,text[88]);
   strip_latin(strip1);
   fprintf(fp_top3,"%s\n",strip1);

   strcpy(strip1,text[97]);
   strip_latin(strip1);
   fprintf(fp_top3,"%s\n",strip1);

   strcpy(strip1,text[89]);
   strip_latin(strip1);
   fprintf(fp_top3,"%s %s\n\n",strip1,period);

   strcpy(strip1,text[100]);
   strip_latin(strip1);
   strcpy(strip2,text[98]);
   strip_latin(strip2);
   strcpy(strip3,text[92]);
   strip_latin(strip3);
   strcpy(strip4,text[93]);
   strip_latin(strip4);
   strcpy(strip5,text[94]);
   strip_latin(strip5);
   strcpy(strip6,text[95]);
   strip_latin(strip6);
   strcpy(strip7,text[99]);
   strip_latin(strip7);

   fprintf(fp_top3,"%-7s %-20s %-8s %-15s %%%-6s %-10s %-10s %%%-7s\n------- -------------------- -------- --------------- ------- ---------- ---------- -------\n",strip1,strip2,strip3,strip4,strip4,strip5,strip6,strip7);

   while(fgets(warea,sizeof(warea),fp_top1))
   {
      getword_start(&gwarea,warea);
      if (getword(user,sizeof(user),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken user in your %s file.\n",top1);
         exit(1);
      }
      if (getword(nbytes,sizeof(nbytes),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken number of bytes in your %s file.\n",top1);
         exit(1);
      }
      if (getword(nacc,sizeof(nacc),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken number of access in your %s file.\n",top1);
         exit(1);
      }
      if (getword(elap,sizeof(elap),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken elapsed time in your %s file.\n",top1);
         exit(1);
      }

      if(strchr(user,'_') != NULL)
         fixip(user);

      strcpy(user2,user);

      tnbytes=atol(nbytes);

      if(tnbytes) {
         perc=ttnbytes / 100;
         perc=tnbytes / perc;
      } else perc = 0;

      if(atol(elap)) {
         perc2=ttnelap / 100;
         perc2=atol(elap) / perc2;
      } else perc2 = 0;

      posicao++;
      tnelap=atol(elap);

      sprintf(wperc,"%3.2f%%",perc);
      sprintf(wperc2,"%3.2f%%",perc2);

      if(strcmp(user,"TOTAL") == 0){
         fputs("------- -------------------- -------- --------------- ------- ---------- ---------- -------\n",fp_top3);
#if defined(__FreeBSD__)
         fprintf(fp_top3,"%-7s %20s %8qu %15s %8s %9s %10qu\n",text[107]," ",ttnacc,fixnum(ttnbytes,1)," ",buildtime(ttnelap),ttnelap);
#elif defined(__alpha) || __ALPHA
         fprintf(fp_top3,"%-7s %20s %8ld %15s %8s %9s %10ld\n",text[107]," ",ttnacc,fixnum(ttnbytes,1)," ",buildtime(ttnelap),ttnelap);
#else
         fprintf(fp_top3,"%-7s %20s %8lld %15s %8s %9s %10lld\n",text[107]," ",ttnacc,fixnum(ttnbytes,1)," ",buildtime(ttnelap),ttnelap);
#endif
      } else {
#if defined(__FreeBSD__)
         fprintf(fp_top3,"%7d %20s %8s %15s %7s %10s %10qu %7s%%\n",posicao,user2,nacc,fixnum(tnbytes,1),wperc,buildtime(tnelap),tnelap,wperc2);
#elif defined(__alpha) || __ALPHA
         fprintf(fp_top3,"%7d %20s %8s %15s %7s %10s %10ld %7s%%\n",posicao,user2,nacc,fixnum(tnbytes,1),wperc,buildtime(tnelap),tnelap,wperc2);
#else
         fprintf(fp_top3,"%7d %20s %8s %15s %7s %10s %10lld %7s\n",posicao,user2,nacc,fixnum(tnbytes,1),wperc,buildtime(tnelap),tnelap,wperc2);
#endif
      }
   }

   if(ttnbytes) {
      tnbytes=ttnbytes / totuser;
   } else tnbytes=0;

   strcpy(strip1,text[96]);
   strip_latin(strip1);
#if defined(__FreeBSD__)
   fprintf(fp_top3,"%-7s %20s %8qu %15s %8s %9s %10qu\n",strip1," ",ttnacc/totuser,fixnum(tnbytes,1)," ",buildtime(ttnelap/totuser),ttnelap/totuser);
#elif defined(__alpha) || __ALPHA
   fprintf(fp_top3,"%-7s %20s %8ld %15s %8s %9s %10ld\n",strip1," ",ttnacc/totuser,fixnum(tnbytes,1)," ",buildtime(ttnelap/totuser),ttnelap/totuser);
#else
   fprintf(fp_top3,"%-7s %20s %8lld %15s %8s %9s %10lld\n",strip1," ",ttnacc/totuser,fixnum(tnbytes,1)," ",buildtime(ttnelap/totuser),ttnelap/totuser);
#endif

   fclose(fp_top1);
   unlink(top1);

   t = time(NULL);
   local = localtime(&t);
   fprintf(fp_top3, "\n%s\n", asctime(local));

   fclose(fp_top3);

   if(strcmp(email,"stdout") == 0) {
      if((fp_top3=fopen(top3,"r"))==NULL) {
         fprintf(stderr, "SARG: (email) %s: %s\n",text[45],top3);
         exit(1);
      }

      while(fgets(buf,sizeof(buf),fp_top3)!=NULL)
         printf("%s",buf);
    } else {
      sprintf(buf,"\"%s\" -s \"SARG %s, %s\" \"%s\" <\"%s\"",MailUtility,text[55],asctime(local),email,top3);
      cstatus=system(buf);
      if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
         fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
         fprintf(stderr, "SARG: command: %s\n",buf);
         exit(1);
      }
    }

   if (snprintf(warea,sizeof(warea),"%s/sarg",TempDir)>=sizeof(warea)) {
      fprintf(stderr,"SARG: Temporary directory name too long: %s\n",warea);
      exit(1);
   }
   unlinkdir(warea,0);

   return (0);
}
