#include "opt_sound.h"
#include "common.h"
#include "iconwidget.h"

#include <qbuttongroup.h>
#include <qwhatsthis.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qfiledialog.h>
#include <qlabel.h>

#include "opt_sound-ui.h"

//----------------------------------------------------------------------------
// OptionsTabSound
//----------------------------------------------------------------------------

OptionsTabSound::OptionsTabSound(QObject *parent)
: OptionsTab(parent, "sound", "", tr("Sound"), tr("Configure how Psi sounds"), "psi/playSounds")
{
	w = 0;
	bg_se = bg_sePlay = 0;
}

OptionsTabSound::~OptionsTabSound()
{
	if ( bg_se )
		delete bg_se;
	if ( bg_sePlay )
		delete bg_sePlay;
}

QWidget *OptionsTabSound::widget()
{
	if ( w )
		return 0;

	w = new OptSoundUI();
	OptSoundUI *d = (OptSoundUI *)w;

	le_oe[0] = d->le_oeMessage;
	le_oe[1] = d->le_oeChat1;
	le_oe[2] = d->le_oeChat2;
	le_oe[3] = d->le_oeHeadline;
	le_oe[4] = d->le_oeSystem;
	le_oe[5] = d->le_oeOnline;
	le_oe[6] = d->le_oeOffline;
	le_oe[7] = d->le_oeSend;
	le_oe[8] = d->le_oeIncomingFT;
	le_oe[9] = d->le_oeFTComplete;

	bg_se = new QButtonGroup;
	bg_se->insert(d->tb_seMessage, 0);
	bg_se->insert(d->tb_seChat1, 1);
	bg_se->insert(d->tb_seChat2, 2);
	bg_se->insert(d->tb_seHeadline, 3);
	bg_se->insert(d->tb_seSystem, 4);
	bg_se->insert(d->tb_seOnline, 5);
	bg_se->insert(d->tb_seOffline, 6);
	bg_se->insert(d->tb_seSend, 7);
	bg_se->insert(d->tb_seIncomingFT, 8);
	bg_se->insert(d->tb_seFTComplete, 9);
	connect(bg_se, SIGNAL(clicked(int)), SLOT(chooseSoundEvent(int)));

	bg_sePlay = new QButtonGroup;
	bg_sePlay->insert(d->tb_seMessagePlay, 0);
	bg_sePlay->insert(d->tb_seChat1Play, 1);
	bg_sePlay->insert(d->tb_seChat2Play, 2);
	bg_sePlay->insert(d->tb_seHeadlinePlay, 3);
	bg_sePlay->insert(d->tb_seSystemPlay, 4);
	bg_sePlay->insert(d->tb_seOnlinePlay, 5);
	bg_sePlay->insert(d->tb_seOfflinePlay, 6);
	bg_sePlay->insert(d->tb_seSendPlay, 7);
	bg_sePlay->insert(d->tb_seIncomingFTPlay, 8);
	bg_sePlay->insert(d->tb_seFTCompletePlay, 9);
	connect(bg_sePlay, SIGNAL(clicked(int)), SLOT(previewSoundEvent(int)));

	connect(d->pb_soundReset, SIGNAL(clicked()), SLOT(soundReset()));

	// set up proper tool button icons
	int n;
	for (n = 0; n < 10; n++) {
		IconToolButton *tb = (IconToolButton *)bg_se->find(n);
		tb->setIcon( IconsetFactory::iconPtr("psi/browse") );
		tb = (IconToolButton *)bg_sePlay->find(n);
		tb->setIcon( IconsetFactory::iconPtr("psi/play") );
	}

	// TODO: add QWhatsThis for all widgets

	QWhatsThis::add(d->le_player,
		tr("If your system supports multiple sound players, you may"
		" choose your preferred sound player application here."));
	QWhatsThis::add(d->ck_awaySound,
		tr("Enable this option if you wish to hear sound alerts when your status is \"away\" or \"extended away\"."));
	QWhatsThis::add(d->ck_gcSound,
		tr("Play sounds for all events in groupchat, not only for mentioning of your nick."));

#if defined(Q_WS_WIN)
	d->lb_player->hide();
	d->le_player->hide();
#elif defined(Q_WS_MAC)
	d->lb_player->hide();
	d->le_player->hide();
#endif

	return w;
}

void OptionsTabSound::applyOptions(Options *opt)
{
	if ( !w )
		return;

	OptSoundUI *d = (OptSoundUI *)w;
	opt->player = d->le_player->text();
	opt->noAwaySound = !d->ck_awaySound->isChecked();
	opt->noGCSound = !d->ck_gcSound->isChecked();

	for(int n = 0; n < 10; ++n)
		opt->onevent[n] = le_oe[n]->text();
}

void OptionsTabSound::restoreOptions(const Options *opt)
{
	if ( !w )
		return;

	OptSoundUI *d = (OptSoundUI *)w;

#if defined(Q_WS_WIN)
	d->le_player->setText(tr("Windows Sound"));
#elif defined(Q_WS_MAC)
	d->le_player->setText(tr("Mac OS Sound"));
#else
	d->le_player->setText( opt->player );
#endif

	d->ck_awaySound->setChecked( !opt->noAwaySound );
	d->ck_gcSound->setChecked( !opt->noGCSound );

	for(int n = 0; n < 10; ++n)
		le_oe[n]->setText(opt->onevent[n]);
}

void OptionsTabSound::setData(PsiCon *, QWidget *p)
{
	parentWidget = p;
}

void OptionsTabSound::chooseSoundEvent(int x)
{
	if(option.lastPath.isEmpty())
		option.lastPath = QDir::homeDirPath();
	QString str = QFileDialog::getOpenFileName(option.lastPath, tr("Sound (*.wav)"), parentWidget, "", tr("Choose a sound file"));
	if(!str.isEmpty()) {
		QFileInfo fi(str);
		option.lastPath = fi.dirPath();
		le_oe[x]->setText(str);
		emit dataChanged();
	}
}

void OptionsTabSound::previewSoundEvent(int x)
{
	soundPlay(le_oe[x]->text());
}

void OptionsTabSound::soundReset()
{
	Options opt;
	opt.onevent[eMessage]    = g.pathBase + "/sound/chat2.wav";
	opt.onevent[eChat1]      = g.pathBase + "/sound/chat1.wav";
	opt.onevent[eChat2]      = g.pathBase + "/sound/chat2.wav";
	opt.onevent[eHeadline]   = g.pathBase + "/sound/chat2.wav";
	opt.onevent[eSystem]     = g.pathBase + "/sound/chat2.wav";
	opt.onevent[eOnline]     = g.pathBase + "/sound/online.wav";
	opt.onevent[eOffline]    = g.pathBase + "/sound/offline.wav";
	opt.onevent[eSend]       = g.pathBase + "/sound/send.wav";
	opt.onevent[eIncomingFT] = g.pathBase + "/sound/ft_incoming.wav";
	opt.onevent[eFTComplete] = g.pathBase + "/sound/ft_complete.wav";

	for(int n = 0; n < 10; ++n)
		le_oe[n]->setText(opt.onevent[n]);

	emit dataChanged();
}
