#ifndef OPT_PRESENCE_H
#define OPT_PRESENCE_H

#include "optionstab.h"

class QWidget;
struct Options;

class OptionsTabPresence : public MetaOptionsTab
{
	Q_OBJECT
public:
	OptionsTabPresence(QObject *parent);
};

class OptionsTabPresenceAuto : public OptionsTab
{
	Q_OBJECT
public:
	OptionsTabPresenceAuto(QObject *parent);

	QWidget *widget();
	void applyOptions(Options *opt);
	void restoreOptions(const Options *opt);

private:
	QWidget *w;
};

class OptionsTabPresencePresets : public OptionsTab
{
	Q_OBJECT
public:
	OptionsTabPresencePresets(QObject *parent);
	~OptionsTabPresencePresets();

	QWidget *widget();
	void applyOptions(Options *opt);
	void restoreOptions(const Options *opt);

	void setData(PsiCon *, QWidget *parentDialog);

private slots:
	void selectStatusPreset(int x);
	void newStatusPreset();
	void removeStatusPreset();
	void changeStatusPreset();

private:
	QWidget *w, *parentWidget;
	Options *o;
};

class OptionsTabPresenceMisc : public OptionsTab
{
	Q_OBJECT
public:
	OptionsTabPresenceMisc(QObject *parent);

	QWidget *widget();
	void applyOptions(Options *opt);
	void restoreOptions(const Options *opt);

private:
	QWidget *w;
};

#endif
