#ifndef OPT_GENERAL_H
#define OPT_GENERAL_H

#include "optionstab.h"

class QWidget;
struct Options;
class QButtonGroup;

class OptionsTabGeneral : public MetaOptionsTab
{
	Q_OBJECT
public:
	OptionsTabGeneral(QObject *parent);
};

class OptionsTabGeneralRoster : public OptionsTab
{
	Q_OBJECT
public:
	OptionsTabGeneralRoster(QObject *parent);
	~OptionsTabGeneralRoster();

	QWidget *widget();
	void applyOptions(Options *opt);
	void restoreOptions(const Options *opt);

private:
	QWidget *w;
	QButtonGroup *bg_defAct;
};

class OptionsTabGeneralDocking : public OptionsTab
{
	Q_OBJECT
public:
	OptionsTabGeneralDocking(QObject *parent);

	QWidget *widget();
	void applyOptions(Options *opt);
	void restoreOptions(const Options *opt);

private:
	QWidget *w;
};

class OptionsTabGeneralMisc : public OptionsTab
{
	Q_OBJECT
public:
	OptionsTabGeneralMisc(QObject *parent);
	~OptionsTabGeneralMisc();

	QWidget *widget();
	void applyOptions(Options *opt);
	void restoreOptions(const Options *opt);

private slots:
	void selectBrowser(int);

private:
	QWidget *w;
	QButtonGroup *bg_delChats;
};

class OptionsTabGeneralNotifications : public OptionsTab
{
	Q_OBJECT
public:
	OptionsTabGeneralNotifications(QObject *parent);

	QWidget *widget();
	void applyOptions(Options *opt);
	void restoreOptions(const Options *opt);

private:
	QWidget *w;
};

class OptionsTabGeneralGroupchat : public OptionsTab
{
	Q_OBJECT
public:
	OptionsTabGeneralGroupchat(QObject *parent);

	QWidget *widget();
	void applyOptions(Options *opt);
	void restoreOptions(const Options *opt);

	void setData(PsiCon *, QWidget *);
	bool stretchable() const { return true; }

private slots:
	void addNickColor(QString);
	void addGCHighlight();
	void removeGCHighlight();
	void addGCNickColor();
	void removeGCNickColor();
	void chooseGCNickColor();
	void displayGCNickColor();
	void selectedGCNickColor();

private:
	QWidget *w, *dlg;
};

#endif
