#!/usr/bin/python
#
# Command-line frontend utility for generating code automatically from 
# C structs.
#
# Copyright (c) 2004 MySQL AB
#
# May/2004 - Alfredo K. Kojima: initial version
#


import parser
import sys

import autoxml_c
import autoser_c


verbose=1
parser.verbose=verbose


def generate_code(file, module, generatorL, suffix):
    groups, global_objects= parser.parse(open(file).read(), "xml")

    wanted_groups= []
    if not argd["groups"]:
        wanted_groups= [g["name"] for g in groups]
    else:
        wanted_groups= argd["groups"]

    current_file_name=None
    current_file=None
    prototypeL= []

    for group in wanted_groups:
        # for each generator, generate code for all structs in the 
        # desired group
        group_data= None
        for g in groups:
            if g["name"]==group:
                group_data= g
                break
        if not group_data:
            continue

        if argd["file_prefix"]:
            current_file_name= argd["file_prefix"]+group+suffix
            if current_file:
                current_file.write(module.get_header())
                current_file.write("\n".join(headL)+"\n")
                current_file.write("\n\n\n\n".join(codeL)+"\n")
                current_file.close()
            current_file= open(current_file_name, "w+")
            headL=[]
            codeL=[]
        else:
            if not current_file:
                current_file_name= argd["out_file_name"]
                current_file= open(current_file_name, "w+")
                headL=[]
                codeL=[]

        if verbose:
            print "Outputting code for", group, "in file", current_file_name

        for generator in generatorL:
            gen= generator(group_data, global_objects)

            head, body= gen.generate_code()
            if head:
                headL.append(head)
            if body:
                codeL.append(body)
            
            prototypeL+= gen.get_prototypes()

    if current_file:
        current_file.write(module.get_header(file))
        current_file.write("\n".join(headL)+"\n")
        current_file.write("\n\n".join(codeL)+"\n")
        current_file.close()

    if argd["output_prototypes"] or verbose:
        if verbose:
            print "Prototypes:"
        print "\n".join(prototypeL)

argd={}
argd["out_file_name"]="output.c"
argd["file_prefix"]=None
argd["groups"]=[]
argd["prototype_marker"]=None
argd["output_prototypes"]=0


def help():
    print "%s <command> <file> <options>"%sys.argv[0]
    print "Commands:"
    print "  cxml - C code to read/write XML files"
    print "Options:"
    print "  --output-file <file>  Output everything in the named file"
    print "  --file-prefix <str>   Use the string as the prefix for output files"
    print "  --group <group>       Output data for named group (default: all)"
    print "  --output-prototypes   Print prototypes for defined top level functions"
    print "  --read-only           Output reader only"
    print "  --write-onl           Output writer only"
    print ""

    

class myXMLWriterGenerator(autoxml_c.C_XMLOutputGenerator):
    def is_custom(self, typ):
        if typ == "MYX_NAME_VALUE_PAIR":
            return 1
        return 0

    def process_custom_variable(self, variable, depth, for_array=0):
        d= {
        "entity":self.get_entity_name(variable),
        "content":["obj->%(name)s","obj->%(name)s[i]"][for_array]%variable
        }
        if variable["type"] == "MYX_NAME_VALUE_PAIR":
            lines=[
            self.indent("{", depth),
            self.indent('xmlNodePtr vp= xmlNewTextChild(parent, NULL, "%(entity)s", NULL);' % d, depth+1),
            self.indent('xmlNewProp(vp, "name", %(content)s.name);' % d, depth+1),
            self.indent('xmlNewProp(vp, "value", %(content)s.value);' % d, depth+1),
            self.indent('}', depth)
            ]
            return lines

        print item
        raise NotImplementedError


class myXMLReaderGenerator(autoxml_c.C_XMLInputGenerator):
    def is_custom(self, typ):
        if typ == "MYX_NAME_VALUE_PAIR":
            return 1
        return 0
    
    def process_custom_variable(self, variable, depth, for_array=0):
        if variable["type"] == "MYX_NAME_VALUE_PAIR":
            d= {
            "entity":self.get_entity_name(variable),
            "content":["obj->%(name)s","obj->%(name)s[i]"][for_array]%variable
            }
            lines=[
            self.indent('%(content)s.name= xmlGetProp(node, "name");'%d,depth),
            self.indent('%(content)s.value= xmlGetProp(node, "value");'%d,depth)
            ]
            return lines

        print item
        raise NotImplementedError

    
class myXMLDestroyerGenerator(autoxml_c.C_XMLDestroyerGenerator):
    def is_custom(self, typ):
        if typ == "MYX_NAME_VALUE_PAIR":
            return 1
        return 0

    def process_custom_variable(self, variable, depth, for_array=0):
        if variable["type"] == "MYX_NAME_VALUE_PAIR":
            d= {
            "entity":self.get_entity_name(variable),
            "content":["obj->%(name)s","obj->%(name)s[i]"][for_array]%variable
            }
            lines=[
            self.indent('xmlFree(%(content)s.name);'%d,depth),
            self.indent('xmlFree(%(content)s.value);'%d,depth)
            ]
            return lines

        print item
        raise NotImplementedError


def main(argv):
    global argd
    gen_writer= 1
    gen_reader= 1

    args= argv[2:]
    while args:
        a=args[0]
        if a=="--single-file":
            argd["single_file"]=1
            del args[0]
        elif a == "--file-prefix":
            del args[0]
            argd["file_prefix"]=args[0]
            del args[0]
	elif a == "--output-file":
	    del args[0]
            argd["out_file_name"]= args[0]
	    del args[0]
        elif a == "--group":
            del args[0]
            argd["groups"].append(args[0])
            del args[0]
        elif a == "--output-prototypes":
            argd["output_prototypes"]=1
            del args[0]
        elif a == "--read-only":
            del args[0]
            gen_reader= 1
            gen_writer= 0
        elif a == "--write-only":
            del args[0]
            gen_reader= 0
            gen_writer= 1
        else:
            print "Unknown option", a
            sys.exit(1)
##        elif a == "--prototype-marker":
##            del args[0]
##            argd["prototype_marker"]= args[0]
##            del args[0]
    args= argv[:2]

    suffix=None
    generators=None
    if len(args)>=2:
        module= None
        if args[0]=="cxml":
            if verbose:
                print "Generating C code for libxml"
            generators= []
            if gen_writer:
                generators.append(myXMLWriterGenerator)
            if gen_reader:
                generators.append(myXMLReaderGenerator)
            generators.append(myXMLDestroyerGenerator)
            module= autoxml_c
            suffix=".c"
        elif args[0]=="cser":
            if verbose:
                print "Generating C code for serialization"
            generators=[autoser_c.C_SerializerGenerator,autoser_c.C_UnserializerGenerator]#,autoxml_c.C_XMLFreeGenerator]
            module= autoser_c
            suffix=".c"

        generate_code(args[1], module, generators, suffix)
    else:
        help()

    #elif args[0]=="javaxml":
    #    generate_java_xml_code(args[1:])
    #elif args[0]=="cserializer":
    #    generate_c_serializer_code(args[1:])
    #elif args[0]=="javaserializer":
    #    generate_java_serializer_code(args[1:])

    
main(sys.argv[1:])
