


#include "MYXMySQLResultSetStorage.h"
#include "MYXMySQLResultSetSource.h"





MYXMySQLResultSetSource *open_connection()
{
  MYXMySQLResultSetSource *source= new MYXMySQLResultSetSource();

  puts("connecting");
  if (!source->connect("localhost", 3661, "root", ""))
    g_error("can't connect to localhost");
  puts("connected");
  return source;
}



void test_setup(MYXMySQLResultSetSource *source)
{
  puts("creating databse");
  source->execute("drop database testrs");
  source->execute("create database testrs");
  source->push_schema("testrs");
  
  source->execute("create table t1 (k int(11) primary key, v1 varchar(32), v2 varchar(20))");
  source->execute("create table t2 (k1 int(11) auto_increment, k2 int(11), v1 varchar(32), v2 varchar(20), primary key (k1,k2))");
  puts("done");
}


void dump_rows(MYXMySQLResultSetStorage *sto)
{
  sto->move_first();
  while (sto->next_row())
  {
    const char *value1, *value2, *value3;
    size_t length;
    if (!sto->get(0, value1, length))
      g_error("error getting field value");
    if (!sto->get(1, value2, length))
      g_error("error getting field value");
    if (!sto->get(2, value3, length))
      g_error("error getting field value");

    g_message("=> %s, %s, %s", value1, value2, value3);
  }
}


void test_fillup(MYXMySQLResultSetSource *source)
{
  if (!source->execute("select * from t1"))
    g_error("error executing query");
  
  MYXMySQLResultSetStorage *sto= new MYXMySQLResultSetStorage(source);

  sto->fetch_all();
  
  assert(sto->is_editable());
  
  bigint row;

  row= sto->add_row();
  sto->set(row, 0, "1");
  sto->set(row, 1, "aaa");
  sto->set(row, 2, "apple");
  
  assert(sto->has_changes());

  row= sto->add_row();
  sto->set(row, 0, "2");
  sto->set(row, 1, "bbb");
  sto->set(row, 2, "lemon");

  row= sto->add_row();
  sto->set(row, 0, "3");
  sto->set(row, 1, "ccc");
  sto->set(row, 2, "banana");

  row= sto->add_row();
  sto->set(row, 0, "4");
  sto->set(row, 1, "ddd");
  sto->set(row, 2, "orange");

  row= sto->add_row();
  sto->set(row, 0, "5");
  sto->set(row, 1, "eee");
  sto->set(row, 2, "pineapple");

  row= sto->add_row();
  sto->set(row, 0, "6");
  sto->set(row, 1, "fff");
  sto->set(row, 2, "peach");

  assert(sto->row_has_changes(0));
  
  assert(sto->has_changes());
  MYXResultSetCommitResult *result= sto->commit_changes();
  result->dump();
  delete result;
  
  delete sto;
}


MYXMySQLResultSetStorage *test_query(MYXMySQLResultSetSource *source)
{  
  if (!source->execute("select * from t1"))
    g_error("error executing query");

  MYXMySQLResultSetStorage *sto= new MYXMySQLResultSetStorage(source);

  sto->set_page_size(4);

  dump_rows(sto);
  return sto;
}


void test_modify(MYXMySQLResultSetStorage *sto)
{
  g_message("modifying resultset...");
  sto->set(0, 0, "999");
  sto->set(0, 2, "cabbage");
  sto->set(2, 2, "carrot");
  sto->set(5, 0, "55555");
  
  sto->delete_row(3);
  
  g_message("move_first and dump........");
  dump_rows(sto);
  
  g_message("COMMIT");
  MYXResultSetCommitResult *result= sto->commit_changes();
  if (result)
    result->dump();
  else
    g_message("no errors??");
  delete result;

  assert(!sto->has_changes());

  dump_rows(sto);

  delete sto;
}




int main()
{
  MYXMySQLResultSetSource *source= open_connection();
  MYXMySQLResultSetStorage *sto;
  
  test_setup(source);
  
  test_fillup(source);
  
  sto= test_query(source);
  
  test_modify(sto);
  
  puts("SECOND TRY");
  test_query(source);
  
  delete source;
}
