/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svtools.hxx"

#ifndef INCLUDE_CONFIGITEMS_ACCESSIBILITYOPTIONS_CONST_HXX
#define INCLUDE_CONFIGITEMS_ACCESSIBILITYOPTIONS_CONST_HXX

#include <rtl/ustring.hxx>

namespace
{
    static const ::rtl::OUString s_sAccessibility(RTL_CONSTASCII_USTRINGPARAM("org.openoffice.Office.Common/Accessibility"));
    static const ::rtl::OUString s_sAutoDetectSystemHC(RTL_CONSTASCII_USTRINGPARAM("AutoDetectSystemHC"));
    static const ::rtl::OUString s_sIsForPagePreviews(RTL_CONSTASCII_USTRINGPARAM("IsForPagePreviews"));
    static const ::rtl::OUString s_sIsHelpTipsDisappear(RTL_CONSTASCII_USTRINGPARAM("IsHelpTipsDisappear"));
    static const ::rtl::OUString s_sHelpTipSeconds(RTL_CONSTASCII_USTRINGPARAM("HelpTipSeconds"));
    static const ::rtl::OUString s_sIsAllowAnimatedGraphics(RTL_CONSTASCII_USTRINGPARAM("IsAllowAnimatedGraphics"));
    static const ::rtl::OUString s_sIsAllowAnimatedText(RTL_CONSTASCII_USTRINGPARAM("IsAllowAnimatedText"));
    static const ::rtl::OUString s_sIsAutomaticFontColor(RTL_CONSTASCII_USTRINGPARAM("IsAutomaticFontColor"));
    static const ::rtl::OUString s_sIsSystemFont(RTL_CONSTASCII_USTRINGPARAM("IsSystemFont"));
    static const ::rtl::OUString s_sIsSelectionInReadonly(RTL_CONSTASCII_USTRINGPARAM("IsSelectionInReadonly"));
}

#endif //  INCLUDE_CONFIGITEMS_ACCESSIBILITYOPTIONS_CONST_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
