//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 3>, 351> beta_exp_data = { {
      { SC_(0.1730655412757187150418758392333984375e-5), SC_(0.1730655412757187150418758392333984375e-5), SC_(1155631.551635027016649268884796909927277) }, 
      { SC_(0.216575062950141727924346923828125e-5), SC_(0.1730655412757187150418758392333984375e-5), SC_(1039549.452063747329381617654200841254652) }, 
      { SC_(0.216575062950141727924346923828125e-5), SC_(0.216575062950141727924346923828125e-5), SC_(923467.3524924676425690820378921903570447) }, 
      { SC_(0.72700195232755504548549652099609375e-5), SC_(0.1730655412757187150418758392333984375e-5), SC_(715366.9882608199489156088500706918884474) }, 
      { SC_(0.72700195232755504548549652099609375e-5), SC_(0.216575062950141727924346923828125e-5), SC_(599284.8886895402674421924477675861806454) }, 
      { SC_(0.72700195232755504548549652099609375e-5), SC_(0.72700195232755504548549652099609375e-5), SC_(275102.4248866129549503632384850636365051) }, 
      { SC_(0.14000004739500582218170166015625e-4), SC_(0.1730655412757187150418758392333984375e-5), SC_(649244.3230419389091055494874477610228104) }, 
      { SC_(0.14000004739500582218170166015625e-4), SC_(0.216575062950141727924346923828125e-5), SC_(533162.2234706592346717218748633348329255) }, 
      { SC_(0.14000004739500582218170166015625e-4), SC_(0.72700195232755504548549652099609375e-5), SC_(208979.7596677320047637517666971035319141) }, 
      { SC_(0.14000004739500582218170166015625e-4), SC_(0.14000004739500582218170166015625e-4), SC_(142857.0944488511634633414470885024340382) }, 
      { SC_(0.17196454791701398789882659912109375e-4), SC_(0.1730655412757187150418758392333984375e-5), SC_(635967.2966761120408405544283252854891051) }, 
      { SC_(0.17196454791701398789882659912109375e-4), SC_(0.216575062950141727924346923828125e-5), SC_(519885.1971048323697502064131013612391462) }, 
      { SC_(0.17196454791701398789882659912109375e-4), SC_(0.72700195232755504548549652099609375e-5), SC_(195702.7333019051790657557774869592595619) }, 
      { SC_(0.17196454791701398789882659912109375e-4), SC_(0.14000004739500582218170166015625e-4), SC_(129580.0680830243894812627999923649303964) }, 
      { SC_(0.17196454791701398789882659912109375e-4), SC_(0.17196454791701398789882659912109375e-4), SC_(116303.0417171976400618567245671670493297) }, 
      { SC_(0.60085076256655156612396240234375e-4), SC_(0.1730655412757187150418758392333984375e-5), SC_(594458.8435535046961781833034439822035691) }, 
      { SC_(0.60085076256655156612396240234375e-4), SC_(0.216575062950141727924346923828125e-5), SC_(478376.7439822250699480739314338811953296) }, 
      { SC_(0.60085076256655156612396240234375e-4), SC_(0.72700195232755504548549652099609375e-5), SC_(154194.2801792984055346510144704788292969) }, 
      { SC_(0.60085076256655156612396240234375e-4), SC_(0.14000004739500582218170166015625e-4), SC_(88071.61496041830983457563965247905141874) }, 
      { SC_(0.60085076256655156612396240234375e-4), SC_(0.17196454791701398789882659912109375e-4), SC_(74794.58859459188997822531683455967562115) }, 
      { SC_(0.60085076256655156612396240234375e-4), SC_(0.60085076256655156612396240234375e-4), SC_(33286.13547199056171829186221434157408122) }, 
      { SC_(0.000116783194243907928466796875), SC_(0.1730655412757187150418758392333984375e-5), SC_(586378.651529572636659503110266369369984) }, 
      { SC_(0.000116783194243907928466796875), SC_(0.216575062950141727924346923828125e-5), SC_(470296.5519582930697306370777452683761698) }, 
      { SC_(0.000116783194243907928466796875), SC_(0.72700195232755504548549652099609375e-5), SC_(146114.0881553671010006794541334417041727) }, 
      { SC_(0.000116783194243907928466796875), SC_(0.14000004739500582218170166015625e-4), SC_(79991.42293648792255405447160736354988824) }, 
      { SC_(0.000116783194243907928466796875), SC_(0.17196454791701398789882659912109375e-4), SC_(66714.39657066193835073550620286643916615) }, 
      { SC_(0.000116783194243907928466796875), SC_(0.60085076256655156612396240234375e-4), SC_(25205.94344806645534821918725567217595504) }, 
      { SC_(0.000116783194243907928466796875), SC_(0.000116783194243907928466796875), SC_(17125.75142415007588824659456664464078893) }, 
      { SC_(0.000149052008055150508880615234375), SC_(0.1730655412757187150418758392333984375e-5), SC_(584524.843186061699046596661105506295866) }, 
      { SC_(0.000149052008055150508880615234375), SC_(0.216575062950141727924346923828125e-5), SC_(468442.7436147821658663815479488360288728) }, 
      { SC_(0.000149052008055150508880615234375), SC_(0.72700195232755504548549652099609375e-5), SC_(144260.2798118565930535598166654066443804) }, 
      { SC_(0.000149052008055150508880615234375), SC_(0.14000004739500582218170166015625e-4), SC_(78137.6145929779366207198292645775242312) }, 
      { SC_(0.000149052008055150508880615234375), SC_(0.17196454791701398789882659912109375e-4), SC_(64860.58822715220034984276283119323639683) }, 
      { SC_(0.000149052008055150508880615234375), SC_(0.60085076256655156612396240234375e-4), SC_(23352.13510456004391420247071206624241613) }, 
      { SC_(0.000149052008055150508880615234375), SC_(0.000116783194243907928466796875), SC_(15271.94308064806187957915306088879145787) }, 
      { SC_(0.000149052008055150508880615234375), SC_(0.000149052008055150508880615234375), SC_(13418.13473714855046889923959457185167481) }, 
      { SC_(0.0003985252114944159984588623046875), SC_(0.1730655412757187150418758392333984375e-5), SC_(580325.0267004741284777720102301507805905) }, 
      { SC_(0.0003985252114944159984588623046875), SC_(0.216575062950141727924346923828125e-5), SC_(464242.9271291948561701678823852769833447) }, 
      { SC_(0.0003985252114944159984588623046875), SC_(0.72700195232755504548549652099609375e-5), SC_(140060.4633262723437444763727887594791223) }, 
      { SC_(0.0003985252114944159984588623046875), SC_(0.14000004739500582218170166015625e-4), SC_(73937.79810739772240919420653098643931922) }, 
      { SC_(0.0003985252114944159984588623046875), SC_(0.17196454791701398789882659912109375e-4), SC_(60660.77174157390262331984812205981539232) }, 
      { SC_(0.0003985252114944159984588623046875), SC_(0.60085076256655156612396240234375e-4), SC_(19152.31861900746010982713873615733036615) }, 
      { SC_(0.0003985252114944159984588623046875), SC_(0.000116783194243907928466796875), SC_(11072.12659512946959154647142760990796737) }, 
      { SC_(0.0003985252114944159984588623046875), SC_(0.000149052008055150508880615234375), SC_(9218.318251649302932199820676778504299719) }, 
      { SC_(0.0003985252114944159984588623046875), SC_(0.0003985252114944159984588623046875), SC_(5018.501766299587761063198864612299262498) }, 
      { SC_(0.00063875340856611728668212890625), SC_(0.1730655412757187150418758392333984375e-5), SC_(579381.3241429882314787600400195790681276) }, 
      { SC_(0.00063875340856611728668212890625), SC_(0.216575062950141727924346923828125e-5), SC_(463299.2245717092103071408953485735740662) }, 
      { SC_(0.00063875340856611728668212890625), SC_(0.72700195232755504548549652099609375e-5), SC_(139116.7607687896440448391818012150422867) }, 
      { SC_(0.00063875340856611728668212890625), SC_(0.14000004739500582218170166015625e-4), SC_(72994.09554991890720396147618053871852464) }, 
      { SC_(0.00063875340856611728668212890625), SC_(0.17196454791701398789882659912109375e-4), SC_(59717.06918409693237354458168673772104752) }, 
      { SC_(0.00063875340856611728668212890625), SC_(0.60085076256655156612396240234375e-4), SC_(18208.61606155524405362968798342261554923) }, 
      { SC_(0.00063875340856611728668212890625), SC_(0.000116783194243907928466796875), SC_(10128.42403770997637556860033296324003096) }, 
      { SC_(0.00063875340856611728668212890625), SC_(0.000149052008055150508880615234375), SC_(8274.615694248432457086724782473929150854) }, 
      { SC_(0.00063875340856611728668212890625), SC_(0.0003985252114944159984588623046875), SC_(4074.799209042668601531129156089963301482) }, 
      { SC_(0.00063875340856611728668212890625), SC_(0.00063875340856611728668212890625), SC_(3131.096651924328003273873888262194585402) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.1730655412757187150418758392333984375e-5), SC_(578748.7693423753941389854751026834812459) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.216575062950141727924346923828125e-5), SC_(462666.6697710968255230523836363548096488) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.72700195232755504548549652099609375e-5), SC_(138484.2059681825683485463067171057570855) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.14000004739500582218170166015625e-4), SC_(72361.5407493188315002241913837983386211) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.17196454791701398789882659912109375e-4), SC_(59084.51438350018134300863405362995980529) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.60085076256655156612396240234375e-4), SC_(17576.0612610031009311452486029621355864) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.000116783194243907928466796875), SC_(9495.869237216800935468654175518891346132) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.000149052008055150508880615234375), SC_(7642.060893788815835400370107084726389137) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.0003985252114944159984588623046875), SC_(3442.244408842457181186564692494576592715) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.00063875340856611728668212890625), SC_(2498.541851973839877538873278485733894526) }, 
      { SC_(0.0010718167759478092193603515625), SC_(0.0010718167759478092193603515625), SC_(1865.987052473361599093122986045939836842) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.1730655412757187150418758392333984375e-5), SC_(578146.6868265927030609172756375022129408) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.216575062950141727924346923828125e-5), SC_(462064.5872553161695931215518112441517803) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.72700195232755504548549652099609375e-5), SC_(137882.1234524257874475626971925335633952) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.14000004739500582218170166015625e-4), SC_(71759.45823359352964615332870940784891666) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.17196454791701398789882659912109375e-4), SC_(58482.4318677898305824223777438873245987) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.60085076256655156612396240234375e-4), SC_(16973.97874549335243903972140214316734591) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.000116783194243907928466796875), SC_(8893.78672197223076504620210425011585704) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.000149052008055150508880615234375), SC_(7039.978378695160036028218013910220966586) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.0003985252114944159984588623046875), SC_(2840.161894915349206097759718325761099235) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.00063875340856611728668212890625), SC_(1896.459339169739784663132403554328985513) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.0010718167759478092193603515625), SC_(1263.904541692959035604171522556797270816) }, 
      { SC_(0.00302191521041095256805419921875), SC_(0.00302191521041095256805419921875), SC_(661.8220400131266810689999131402027641628) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.1730655412757187150418758392333984375e-5), SC_(578016.0025685181268331499857959484326202) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.216575062950141727924346923828125e-5), SC_(461933.9029972436470789739437915137396688) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.72700195232755504548549652099609375e-5), SC_(137751.439194377357760353694453171044616) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.14000004739500582218170166015625e-4), SC_(71628.77397557686617053038110269144726432) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.17196454791701398789882659912109375e-4), SC_(58351.74760978825459010321008902984708703) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.60085076256655156612396240234375e-4), SC_(16843.29448769420868022449621523696852871) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.000116783194243907928466796875), SC_(8763.102464440684353948165105364959875751) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.000149052008055150508880615234375), SC_(6909.294121315904663830790758036541933092) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.0003985252114944159984588623046875), SC_(2709.477638713282809157753147679535152997) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.00063875340856611728668212890625), SC_(1765.775084100924740163477142206238117531) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.0010718167759478092193603515625), SC_(1133.220288666299323493943722045599765605) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.00302191521041095256805419921875), SC_(531.1377961700217313330611029023504470134) }, 
      { SC_(0.00499413348734378814697265625), SC_(0.00499413348734378814697265625), SC_(400.4535615941792674028465567198380146162) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.1730655412757187150418758392333984375e-5), SC_(577923.47013037237161592264071987940112) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.216575062950141727924346923828125e-5), SC_(461841.3705591023436482349752076392806884) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.72700195232755504548549652099609375e-5), SC_(137658.9067562882797808798128822121083532) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.14000004739500582218170166015625e-4), SC_(71536.24153755664705557992165457096028908) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.17196454791701398789882659912109375e-4), SC_(58259.21517180074025490948339426147291131) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.60085076256655156612396240234375e-4), SC_(16750.76205014550186712119560464394227822) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.000116783194243907928466796875), SC_(8670.570027472041840968150073639899293803) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.000149052008055150508880615234375), SC_(6816.76168467737971022006025785329645956) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.0003985252114944159984588623046875), SC_(2616.945204626520539896177454918314408481) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.00063875340856611728668212890625), SC_(1673.242652470680913702400448013496185857) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.0010718167759478092193603515625), SC_(1040.687861462776237528634664836456293894) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.00302191521041095256805419921875), SC_(438.6053888733535460854940339961810385184) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.00499413348734378814697265625), SC_(307.9211743857003955201164649559975265798) }, 
      { SC_(0.00928423367440700531005859375), SC_(0.00928423367440700531005859375), SC_(215.3888307210024293021479414172947349225) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.1730655412757187150418758392333984375e-5), SC_(577857.1103120105462918088152584701146253) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.216575062950141727924346923828125e-5), SC_(461775.0107407558023784962240363151107329) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.72700195232755504548549652099609375e-5), SC_(137592.5469381210410493887492747575088313) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.14000004739500582218170166015625e-4), SC_(71469.88171962581735908379641667814792516) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.17196454791701398789882659912109375e-4), SC_(58192.85535398219392427946944369798754863) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.60085076256655156612396240234375e-4), SC_(16684.40223383348686765090202995849409919) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.000116783194243907928466796875), SC_(8604.210213151525639091522040650477022996) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.000149052008055150508880615234375), SC_(6750.401871490235206222723780976773951041) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.0003985252114944159984588623046875), SC_(2550.585400200170113186519606656658358302) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.00063875340856611728668212890625), SC_(1606.882856478110472950889537142578379733) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.0010718167759478092193603515625), SC_(974.3280806680873447466411004722025696667) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.00302191521041095256805419921875), SC_(372.245676422438191418917536518742556246) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.00499413348734378814697265625), SC_(241.5615308999037408315571689087370381133) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.00928423367440700531005859375), SC_(149.029336721961539129458808771551576089) }, 
      { SC_(0.0241700224578380584716796875), SC_(0.0241700224578380584716796875), SC_(82.67035587071256040030513689693888763264) }, 
      { SC_(0.06227754056453704833984375), SC_(0.1730655412757187150418758392333984375e-5), SC_(577831.7349438002624232944051827557830252) }, 
      { SC_(0.06227754056453704833984375), SC_(0.216575062950141727924346923828125e-5), SC_(461749.6353725835462070601985223555464535) }, 
      { SC_(0.06227754056453704833984375), SC_(0.72700195232755504548549652099609375e-5), SC_(137567.1715703949009400464606771149773659) }, 
      { SC_(0.06227754056453704833984375), SC_(0.14000004739500582218170166015625e-4), SC_(71444.50635248787780501901847153485408293) }, 
      { SC_(0.06227754056453704833984375), SC_(0.17196454791701398789882659912109375e-4), SC_(58167.47998712362241628438081568357619627) }, 
      { SC_(0.06227754056453704833984375), SC_(0.60085076256655156612396240234375e-4), SC_(16659.02687072325755849373023638872634394) }, 
      { SC_(0.06227754056453704833984375), SC_(0.000116783194243907928466796875), SC_(8578.834854996261281055218405025808451748) }, 
      { SC_(0.06227754056453704833984375), SC_(0.000149052008055150508880615234375), SC_(6725.026516154862565962788369017435647322) }, 
      { SC_(0.06227754056453704833984375), SC_(0.0003985252114944159984588623046875), SC_(2525.2100666620649499877847633658027656) }, 
      { SC_(0.06227754056453704833984375), SC_(0.00063875340856611728668212890625), SC_(1581.507543923521454928529218471285388102) }, 
      { SC_(0.06227754056453704833984375), SC_(0.0010718167759478092193603515625), SC_(948.9528059260075736779903957068543695902) }, 
      { SC_(0.06227754056453704833984375), SC_(0.00302191521041095256805419921875), SC_(346.870571715556714754611455020570779354) }, 
      { SC_(0.06227754056453704833984375), SC_(0.00499413348734378814697265625), SC_(216.1865977659268719722138946273676254668) }, 
      { SC_(0.06227754056453704833984375), SC_(0.00928423367440700531005859375), SC_(123.6547754561733595527133266024579014923) }, 
      { SC_(0.06227754056453704833984375), SC_(0.0241700224578380584716796875), SC_(57.29707083428338757550378575032845681207) }, 
      { SC_(0.06227754056453704833984375), SC_(0.06227754056453704833984375), SC_(31.92695787102591550783893228017388163082) }, 
      { SC_(0.12234418094158172607421875), SC_(0.1730655412757187150418758392333984375e-5), SC_(577823.7644499583542983884816685815344076) }, 
      { SC_(0.12234418094158172607421875), SC_(0.216575062950141727924346923828125e-5), SC_(461741.6648787986392875920059137822769241) }, 
      { SC_(0.12234418094158172607421875), SC_(0.72700195232755504548549652099609375e-5), SC_(137559.201077278694788089421441003518399) }, 
      { SC_(0.12234418094158172607421875), SC_(0.14000004739500582218170166015625e-4), SC_(71436.5358602533481815671518777609814378) }, 
      { SC_(0.12234418094158172607421875), SC_(0.17196454791701398789882659912109375e-4), SC_(58159.50949530784825529761674961815682685) }, 
      { SC_(0.12234418094158172607421875), SC_(0.60085076256655156612396240234375e-4), SC_(16651.05638452601139538458222365047429789) }, 
      { SC_(0.12234418094158172607421875), SC_(0.000116783194243907928466796875), SC_(8570.86437622617816293160489058232377841) }, 
      { SC_(0.12234418094158172607421875), SC_(0.000149052008055150508880615234375), SC_(6717.056041611601434503816667176115175983) }, 
      { SC_(0.12234418094158172607421875), SC_(0.0003985252114944159984588623046875), SC_(2517.239624791193721935651001445721386388) }, 
      { SC_(0.12234418094158172607421875), SC_(0.00063875340856611728668212890625), SC_(1573.537133504954031944400284911837457022) }, 
      { SC_(0.12234418094158172607421875), SC_(0.0010718167759478092193603515625), SC_(940.9824521839767872273567252676025131813) }, 
      { SC_(0.12234418094158172607421875), SC_(0.00302191521041095256805419921875), SC_(338.9004728231691527607551677909299852596) }, 
      { SC_(0.12234418094158172607421875), SC_(0.00499413348734378814697265625), SC_(208.2167560058912570801594364459221673704) }, 
      { SC_(0.12234418094158172607421875), SC_(0.00928423367440700531005859375), SC_(115.6854909304322058992427948879497648697) }, 
      { SC_(0.12234418094158172607421875), SC_(0.0241700224578380584716796875), SC_(49.32969791056048917020484750450806898952) }, 
      { SC_(0.12234418094158172607421875), SC_(0.06227754056453704833984375), SC_(23.96433089039785878385398026154716224145) }, 
      { SC_(0.12234418094158172607421875), SC_(0.12234418094158172607421875), SC_(16.00879021155347361860225152368293681476) }, 
      { SC_(0.249557673931121826171875), SC_(0.1730655412757187150418758392333984375e-5), SC_(577819.4336758001309487960254412103050995) }, 
      { SC_(0.249557673931121826171875), SC_(0.216575062950141727924346923828125e-5), SC_(461737.3341047510499754357080790383820031) }, 
      { SC_(0.249557673931121826171875), SC_(0.72700195232755504548549652099609375e-5), SC_(137554.8703045289911809439807624151938961) }, 
      { SC_(0.249557673931121826171875), SC_(0.14000004739500582218170166015625e-4), SC_(71432.20508921489553798101101747421928658) }, 
      { SC_(0.249557673931121826171875), SC_(0.17196454791701398789882659912109375e-4), SC_(58155.17872508216014275133336930487316425) }, 
      { SC_(0.249557673931121826171875), SC_(0.60085076256655156612396240234375e-4), SC_(16646.72562520533216181580066063068368562) }, 
      { SC_(0.249557673931121826171875), SC_(0.000116783194243907928466796875), SC_(8566.533631320833922604939737241144459694) }, 
      { SC_(0.249557673931121826171875), SC_(0.000149052008055150508880615234375), SC_(6712.725304910041379547463769414719226049) }, 
      { SC_(0.249557673931121826171875), SC_(0.0003985252114944159984588623046875), SC_(2512.908951502353954899931722742258795843) }, 
      { SC_(0.249557673931121826171875), SC_(0.00063875340856611728668212890625), SC_(1569.206521259641573204771063342667522364) }, 
      { SC_(0.249557673931121826171875), SC_(0.0010718167759478092193603515625), SC_(936.6519499352040807786002507165791527979) }, 
      { SC_(0.249557673931121826171875), SC_(0.00302191521041095256805419921875), SC_(334.5704651347481129696285348965946449717) }, 
      { SC_(0.249557673931121826171875), SC_(0.00499413348734378814697265625), SC_(203.8872472312016457396325552558634401533) }, 
      { SC_(0.249557673931121826171875), SC_(0.00928423367440700531005859375), SC_(111.3570630932922956404588337137553755089) }, 
      { SC_(0.249557673931121826171875), SC_(0.0241700224578380584716796875), SC_(45.00497549746720864960484505977101941205) }, 
      { SC_(0.249557673931121826171875), SC_(0.06227754056453704833984375), SC_(19.64878939634529829482671747157749238241) }, 
      { SC_(0.249557673931121826171875), SC_(0.12234418094158172607421875), SC_(11.70690712490308572160798596818445924781) }, 
      { SC_(0.249557673931121826171875), SC_(0.249557673931121826171875), SC_(7.43117764194363534766326007127396596558) }, 
      { SC_(0.4912221431732177734375), SC_(0.1730655412757187150418758392333984375e-5), SC_(577817.2060900112343156227742783722242477) }, 
      { SC_(0.4912221431732177734375), SC_(0.216575062950141727924346923828125e-5), SC_(461735.1065191436037880774913212617052424) }, 
      { SC_(0.4912221431732177734375), SC_(0.72700195232755504548549652099609375e-5), SC_(137552.6427210502013719330760830235066265) }, 
      { SC_(0.4912221431732177734375), SC_(0.14000004739500582218170166015625e-4), SC_(71429.97750854271826748417926689981137106) }, 
      { SC_(0.4912221431732177734375), SC_(0.17196454791701398789882659912109375e-4), SC_(58152.95114574299223451554307458631053944) }, 
      { SC_(0.4912221431732177734375), SC_(0.60085076256655156612396240234375e-4), SC_(16644.49806375133515468300027499878555891) }, 
      { SC_(0.4912221431732177734375), SC_(0.000116783194243907928466796875), SC_(8564.30609350908744706175299411555016727) }, 
      { SC_(0.4912221431732177734375), SC_(0.000149052008055150508880615234375), SC_(6710.497780553044738565348466209402848711) }, 
      { SC_(0.4912221431732177734375), SC_(0.0003985252114944159984588623046875), SC_(2510.681531144392994425176618709216867447) }, 
      { SC_(0.4912221431732177734375), SC_(0.00063875340856611728668212890625), SC_(1566.979201011764353073771832954929489243) }, 
      { SC_(0.4912221431732177734375), SC_(0.0010718167759478092193603515625), SC_(934.424810070900872096317300784806140845) }, 
      { SC_(0.4912221431732177734375), SC_(0.00302191521041095256805419921875), SC_(332.3441361674208545920338936890520219368) }, 
      { SC_(0.4912221431732177734375), SC_(0.00499413348734378814697265625), SC_(201.661736077042279104131587974361267686) }, 
      { SC_(0.4912221431732177734375), SC_(0.00928423367440700531005859375), SC_(109.1333230334003841978154414034929309558) }, 
      { SC_(0.4912221431732177734375), SC_(0.0241700224578380584716796875), SC_(42.78729872557591865541089375762901990334) }, 
      { SC_(0.4912221431732177734375), SC_(0.06227754056453704833984375), SC_(17.4460819316241158060196349843707386278) }, 
      { SC_(0.4912221431732177734375), SC_(0.12234418094158172607421875), SC_(9.526325503205847116031906435161417490588) }, 
      { SC_(0.4912221431732177734375), SC_(0.249557673931121826171875), SC_(5.29246960141209501761625821192793399267) }, 
      { SC_(0.4912221431732177734375), SC_(0.4912221431732177734375), SC_(3.219402118875910610609405938089991233448) }, 
      { SC_(0.98384749889373779296875), SC_(0.1730655412757187150418758392333984375e-5), SC_(577815.8027083794188612080128409845969464) }, 
      { SC_(0.98384749889373779296875), SC_(0.216575062950141727924346923828125e-5), SC_(461733.7031378069519186395663902905333779) }, 
      { SC_(0.98384749889373779296875), SC_(0.72700195232755504548549652099609375e-5), SC_(137551.2393431762108897557348038998382483) }, 
      { SC_(0.98384749889373779296875), SC_(0.14000004739500582218170166015625e-4), SC_(71428.57413523420669457796654195811935814) }, 
      { SC_(0.98384749889373779296875), SC_(0.17196454791701398789882659912109375e-4), SC_(58151.54777460286663680012700676534401016) }, 
      { SC_(0.98384749889373779296875), SC_(0.60085076256655156612396240234375e-4), SC_(16643.0947217045916480034221544627958719) }, 
      { SC_(0.98384749889373779296875), SC_(0.000116783194243907928466796875), SC_(8562.902789920195444129742529158545021282) }, 
      { SC_(0.98384749889373779296875), SC_(0.000149052008055150508880615234375), SC_(6709.094498850205456474844856071691922634) }, 
      { SC_(0.98384749889373779296875), SC_(0.0003985252114944159984588623046875), SC_(2509.278418605274018068298560942907018612) }, 
      { SC_(0.98384749889373779296875), SC_(0.00063875340856611728668212890625), SC_(1565.576251301580865950004135795195775444) }, 
      { SC_(0.98384749889373779296875), SC_(0.0010718167759478092193603515625), SC_(933.0221537319602153754215436787494718852) }, 
      { SC_(0.98384749889373779296875), SC_(0.00302191521041095256805419921875), SC_(330.94279829404303569958136432588517172) }, 
      { SC_(0.98384749889373779296875), SC_(0.00499413348734378814697265625), SC_(200.2617273230187333085558792165477777705) }, 
      { SC_(0.98384749889373779296875), SC_(0.00928423367440700531005859375), SC_(107.7361906421497149255109757675877579688) }, 
      { SC_(0.98384749889373779296875), SC_(0.0241700224578380584716796875), SC_(41.39999224071125263346840515441953038723) }, 
      { SC_(0.98384749889373779296875), SC_(0.06227754056453704833984375), SC_(16.08289156666177645326150319535659473659) }, 
      { SC_(0.98384749889373779296875), SC_(0.12234418094158172607421875), SC_(8.198400692520445676182225309146007699082) }, 
      { SC_(0.98384749889373779296875), SC_(0.249557673931121826171875), SC_(4.02999561966720298968320014949698099934) }, 
      { SC_(0.98384749889373779296875), SC_(0.4912221431732177734375), SC_(2.055936454338069847305712686754828341873) }, 
      { SC_(0.98384749889373779296875), SC_(0.98384749889373779296875), SC_(1.032929315290172610887789380564667043814) }, 
      { SC_(1.1576130390167236328125), SC_(0.1730655412757187150418758392333984375e-5), SC_(577815.5427355465330915369348887400795881) }, 
      { SC_(1.1576130390167236328125), SC_(0.216575062950141727924346923828125e-5), SC_(461733.4431650622074324438967975281817502) }, 
      { SC_(1.1576130390167236328125), SC_(0.72700195232755504548549652099609375e-5), SC_(137550.9793714654803594510193138363286492) }, 
      { SC_(1.1576130390167236328125), SC_(0.14000004739500582218170166015625e-4), SC_(71428.31416488681012363291524217606772926) }, 
      { SC_(1.1576130390167236328125), SC_(0.17196454791701398789882659912109375e-4), SC_(58151.28780490298846292292924692819082452) }, 
      { SC_(1.1576130390167236328125), SC_(0.60085076256655156612396240234375e-4), SC_(16642.83476069247566223083782889998522446) }, 
      { SC_(1.1576130390167236328125), SC_(0.000116783194243907928466796875), SC_(8562.642840392122818351324568387557108215) }, 
      { SC_(1.1576130390167236328125), SC_(0.000149052008055150508880615234375), SC_(6708.834555857556625073381977740604849335) }, 
      { SC_(1.1576130390167236328125), SC_(0.0003985252114944159984588623046875), SC_(2509.018526125546521001310180066162018485) }, 
      { SC_(1.1576130390167236328125), SC_(0.00063875340856611728668212890625), SC_(1565.31640744103289671756170868901482807) }, 
      { SC_(1.1576130390167236328125), SC_(0.0010718167759478092193603515625), SC_(932.762397463961604068383352380008707687) }, 
      { SC_(1.1576130390167236328125), SC_(0.00302191521041095256805419921875), SC_(330.683435598755846538735187753113103072) }, 
      { SC_(1.1576130390167236328125), SC_(0.00499413348734378814697265625), SC_(200.0027612402289005219777498221840778645) }, 
      { SC_(1.1576130390167236328125), SC_(0.00928423367440700531005859375), SC_(107.4780823888026835210510576747111862097) }, 
      { SC_(1.1576130390167236328125), SC_(0.0241700224578380584716796875), SC_(41.14480937139578889465846396482000171393) }, 
      { SC_(1.1576130390167236328125), SC_(0.06227754056453704833984375), SC_(15.83485487407192992497766195076157117598) }, 
      { SC_(1.1576130390167236328125), SC_(0.12234418094158172607421875), SC_(7.960724407358708826099312543374012404891) }, 
      { SC_(1.1576130390167236328125), SC_(0.249557673931121826171875), SC_(3.811245606947061220014698222754841790021) }, 
      { SC_(1.1576130390167236328125), SC_(0.4912221431732177734375), SC_(1.864985985433908578407382661632190748347) }, 
      { SC_(1.1576130390167236328125), SC_(0.98384749889373779296875), SC_(0.8794113894526297066913746532758752650854) }, 
      { SC_(1.1576130390167236328125), SC_(1.1576130390167236328125), SC_(0.7354166217091777980353479508271062498694) }, 
      { SC_(3.451677799224853515625), SC_(0.1730655412757187150418758392333984375e-5), SC_(577814.1115428662525250588276510514518625) }, 
      { SC_(3.451677799224853515625), SC_(0.216575062950141727924346923828125e-5), SC_(461732.0119731896580478075110675971130346) }, 
      { SC_(3.451677799224853515625), SC_(0.72700195232755504548549652099609375e-5), SC_(137549.5481890686767487197748703286316759) }, 
      { SC_(3.451677799224853515625), SC_(0.14000004739500582218170166015625e-4), SC_(71426.88299498362472887101957257955998093) }, 
      { SC_(3.451677799224853515625), SC_(0.17196454791701398789882659912109375e-4), SC_(58149.85664093366220262799673637038534166) }, 
      { SC_(3.451677799224853515625), SC_(0.60085076256655156612396240234375e-4), SC_(16641.40367633707961597297946229365750965) }, 
      { SC_(3.451677799224853515625), SC_(0.000116783194243907928466796875), SC_(8561.21186127346057231030592776995438185) }, 
      { SC_(3.451677799224853515625), SC_(0.000149052008055150508880615234375), SC_(6707.403636626728503799366352647557445894) }, 
      { SC_(3.451677799224853515625), SC_(0.0003985252114944159984588623046875), SC_(2507.588069747633700223421192377319476019) }, 
      { SC_(3.451677799224853515625), SC_(0.00063875340856611728668212890625), SC_(1563.886396520179848712892080358485069201) }, 
      { SC_(3.451677799224853515625), SC_(0.0010718167759478092193603515625), SC_(931.3331889732664829172067120712796382419) }, 
      { SC_(3.451677799224853515625), SC_(0.00302191521041095256805419921875), SC_(329.2578308974055353737435199710138357799) }, 
      { SC_(3.451677799224853515625), SC_(0.00499413348734378814697265625), SC_(198.5807853328874673841146331473466734076) }, 
      { SC_(3.451677799224853515625), SC_(0.00928423367440700531005859375), SC_(106.0639454209989242636167523256705443384) }, 
      { SC_(3.451677799224853515625), SC_(0.0241700224578380584716796875), SC_(39.7573038840965945540156405590665655751) }, 
      { SC_(3.451677799224853515625), SC_(0.06227754056453704833984375), SC_(14.51173499786859531896732896410575858912) }, 
      { SC_(3.451677799224853515625), SC_(0.12234418094158172607421875), SC_(6.729195913158595075950019443099100171292) }, 
      { SC_(3.451677799224853515625), SC_(0.249557673931121826171875), SC_(2.741304677698721344294365319525317222167) }, 
      { SC_(3.451677799224853515625), SC_(0.4912221431732177734375), SC_(1.017497836883268981227414728898846256669) }, 
      { SC_(3.451677799224853515625), SC_(0.98384749889373779296875), SC_(0.2990587867064133290738023100895227166341) }, 
      { SC_(3.451677799224853515625), SC_(1.1576130390167236328125), SC_(0.2163386847733147106857844677090817253937) }, 
      { SC_(3.451677799224853515625), SC_(3.451677799224853515625), SC_(0.01652519763303650081335292786607962178339) }, 
      { SC_(7.88237094879150390625), SC_(0.1730655412757187150418758392333984375e-5), SC_(577813.198754792140261330701291638647824) }, 
      { SC_(7.88237094879150390625), SC_(0.216575062950141727924346923828125e-5), SC_(461731.0991860013706484306714826322844342) }, 
      { SC_(7.88237094879150390625), SC_(0.72700195232755504548549652099609375e-5), SC_(137548.6354122722570766622771847951442809) }, 
      { SC_(7.88237094879150390625), SC_(0.14000004739500582218170166015625e-4), SC_(71425.97023188866086605860479363423699013) }, 
      { SC_(7.88237094879150390625), SC_(0.17196454791701398789882659912109375e-4), SC_(58148.94388434619971311205149730394800817) }, 
      { SC_(7.88237094879150390625), SC_(0.60085076256655156612396240234375e-4), SC_(16640.49100705869051291353363757612255783) }, 
      { SC_(7.88237094879150390625), SC_(0.000116783194243907928466796875), SC_(8560.299307399680047010183807714288865753) }, 
      { SC_(7.88237094879150390625), SC_(0.000149052008055150508880615234375), SC_(6706.491148425126574230225684369287728173) }, 
      { SC_(7.88237094879150390625), SC_(0.0003985252114944159984588623046875), SC_(2506.676089056185727260916043452878904278) }, 
      { SC_(7.88237094879150390625), SC_(0.00063875340856611728668212890625), SC_(1562.97490418432113091213819441692776976) }, 
      { SC_(7.88237094879150390625), SC_(0.0010718167759478092193603515625), SC_(930.4225761445689384094548311853658027148) }, 
      { SC_(7.88237094879150390625), SC_(0.00302191521041095256805419921875), SC_(328.3511648607457177397481676726530367527) }, 
      { SC_(7.88237094879150390625), SC_(0.00499413348734378814697265625), SC_(197.6780882430004280958306091311600158314) }, 
      { SC_(7.88237094879150390625), SC_(0.00928423367440700531005859375), SC_(105.1698040852280070001916999885796092379) }, 
      { SC_(7.88237094879150390625), SC_(0.0241700224578380584716796875), SC_(38.89204373537342329818544125873862680698) }, 
      { SC_(7.88237094879150390625), SC_(0.06227754056453704833984375), SC_(13.71508274837784947531246616075179768398) }, 
      { SC_(7.88237094879150390625), SC_(0.12234418094158172607421875), SC_(6.027021665253566247206937588837870045568) }, 
      { SC_(7.88237094879150390625), SC_(0.249557673931121826171875), SC_(2.196025911549003286622100093306905004255) }, 
      { SC_(7.88237094879150390625), SC_(0.4912221431732177734375), SC_(0.6646129822482021273307209187266122443084) }, 
      { SC_(7.88237094879150390625), SC_(0.98384749889373779296875), SC_(0.1325556606373684570310603701407924055613) }, 
      { SC_(7.88237094879150390625), SC_(1.1576130390167236328125), SC_(0.08430925565819839284942640666812918054188) }, 
      { SC_(7.88237094879150390625), SC_(3.451677799224853515625), SC_(0.001567578372048954697546190363817432566287) }, 
      { SC_(7.88237094879150390625), SC_(7.88237094879150390625), SC_(0.2304086783008952665744998296791021930007e-4) }, 
      { SC_(15.848876953125), SC_(0.1730655412757187150418758392333984375e-5), SC_(577812.467396494064942097256551467225537) }, 
      { SC_(15.848876953125), SC_(0.216575062950141727924346923828125e-5), SC_(461730.3678286549639904324126292681940118) }, 
      { SC_(15.848876953125), SC_(0.72700195232755504548549652099609375e-5), SC_(137547.9040660901316000472092040840673884) }, 
      { SC_(15.848876953125), SC_(0.14000004739500582218170166015625e-4), SC_(71425.23890042634784384697230625424169406) }, 
      { SC_(15.848876953125), SC_(0.17196454791701398789882659912109375e-4), SC_(58148.21255987503466037789783804288733992) }, 
      { SC_(15.848876953125), SC_(0.60085076256655156612396240234375e-4), SC_(16639.75977638419101692348021851942073003) }, 
      { SC_(15.848876953125), SC_(0.000116783194243907928466796875), SC_(8559.568200701221551218767963648849246027) }, 
      { SC_(15.848876953125), SC_(0.000149052008055150508880615234375), SC_(6705.760112274562377109693147086107759687) }, 
      { SC_(15.848876953125), SC_(0.0003985252114944159984588623046875), SC_(2505.945598047360836406987017984692903213) }, 
      { SC_(15.848876953125), SC_(0.00063875340856611728668212890625), SC_(1562.244937662732265726871770794485810834) }, 
      { SC_(15.848876953125), SC_(0.0010718167759478092193603515625), SC_(929.6935540045242455486443804204735207793) }, 
      { SC_(15.848876953125), SC_(0.00302191521041095256805419921875), SC_(327.6263775091254046984727283245152516425) }, 
      { SC_(15.848876953125), SC_(0.00499413348734378814697265625), SC_(196.9575542754211734070057984061189034343) }, 
      { SC_(15.848876953125), SC_(0.00928423367440700531005859375), SC_(104.4584212615345465801581259971762769937) }, 
      { SC_(15.848876953125), SC_(0.0241700224578380584716796875), SC_(38.21136981001168010710740679190694930632) }, 
      { SC_(15.848876953125), SC_(0.06227754056453704833984375), SC_(13.10618362350255476392166743793259749139) }, 
      { SC_(15.848876953125), SC_(0.12234418094158172607421875), SC_(5.514029391894522673178885977576812901954) }, 
      { SC_(15.848876953125), SC_(0.249557673931121826171875), SC_(1.833598229039232723593123386645917772312) }, 
      { SC_(15.848876953125), SC_(0.4912221431732177734375), SC_(0.467845046165576115379722912718972755625) }, 
      { SC_(15.848876953125), SC_(0.98384749889373779296875), SC_(0.06664123970861700317203157698863069745986) }, 
      { SC_(15.848876953125), SC_(1.1576130390167236328125), SC_(0.03776996613323409917542405876735205164805) }, 
      { SC_(15.848876953125), SC_(3.451677799224853515625), SC_(0.0001767056825017873997922509336879545386291) }, 
      { SC_(15.848876953125), SC_(7.88237094879150390625), SC_(0.310532280359287823834522315221229918373e-6) }, 
      { SC_(15.848876953125), SC_(15.848876953125), SC_(0.2576651451920685510042001174792567650789e-9) }, 
      { SC_(31.314670562744140625), SC_(0.1730655412757187150418758392333984375e-5), SC_(577811.7705852061307949254353294671322771) }, 
      { SC_(31.314670562744140625), SC_(0.216575062950141727924346923828125e-5), SC_(461729.6710184828160166319994100531668849) }, 
      { SC_(31.314670562744140625), SC_(0.72700195232755504548549652099609375e-5), SC_(137547.2072690075496939939676230577664587) }, 
      { SC_(31.314670562744140625), SC_(0.14000004739500582218170166015625e-4), SC_(71424.54212060195465862284514291276978183) }, 
      { SC_(31.314670562744140625), SC_(0.17196454791701398789882659912109375e-4), SC_(58147.51578824736212268726758935041995717) }, 
      { SC_(31.314670562744140625), SC_(0.60085076256655156612396240234375e-4), SC_(16639.06311472621275702017697078807585708) }, 
      { SC_(31.314670562744140625), SC_(0.000116783194243907928466796875), SC_(8558.871684391681177902610046087055681713) }, 
      { SC_(31.314670562744140625), SC_(0.000149052008055150508880615234375), SC_(6705.063678672548887519293397395332516276) }, 
      { SC_(31.314670562744140625), SC_(0.0003985252114944159984588623046875), SC_(2505.24980349352938047593785567583576373) }, 
      { SC_(31.314670562744140625), SC_(0.00063875340856611728668212890625), SC_(1561.549757854035533455898102964904417179) }, 
      { SC_(31.314670562744140625), SC_(0.0010718167759478092193603515625), SC_(928.999480869800191174333706227134595703) }, 
      { SC_(31.314670562744140625), SC_(0.00302191521041095256805419921875), SC_(326.9372633593889344749789623402894509337) }, 
      { SC_(31.314670562744140625), SC_(0.00499413348734378814697265625), SC_(196.2734150111948032449933491989589331273) }, 
      { SC_(31.314670562744140625), SC_(0.00928423367440700531005859375), SC_(103.7849653265487425512027398001941283229) }, 
      { SC_(31.314670562744140625), SC_(0.0241700224578380584716796875), SC_(37.57355943415404987582558557137728471079) }, 
      { SC_(31.314670562744140625), SC_(0.06227754056453704833984375), SC_(12.55038605336216829222092298247150246565) }, 
      { SC_(31.314670562744140625), SC_(0.12234418094158172607421875), SC_(5.06466450422007092993671829951452526177) }, 
      { SC_(31.314670562744140625), SC_(0.249557673931121826171875), SC_(1.542483843415710154392732807527862496098) }, 
      { SC_(31.314670562744140625), SC_(0.4912221431732177734375), SC_(0.3335279709424437595711652140518853567302) }, 
      { SC_(31.314670562744140625), SC_(0.98384749889373779296875), SC_(0.03409297661295516414885174102503442819277) }, 
      { SC_(31.314670562744140625), SC_(1.1576130390167236328125), SC_(0.01721838700844971854228152401760085523744) }, 
      { SC_(31.314670562744140625), SC_(3.451677799224853515625), SC_(0.1900362128922583001056640211044473004449e-4) }, 
      { SC_(31.314670562744140625), SC_(7.88237094879150390625), SC_(0.2885050414250820990910991383845819731228e-8) }, 
      { SC_(31.314670562744140625), SC_(15.848876953125), SC_(0.6530600415427592338710565326600917620279e-13) }, 
      { SC_(31.314670562744140625), SC_(31.314670562744140625), SC_(0.8915675179813854663775491877023168025702e-19) }, 
      { SC_(35.515575408935546875), SC_(0.1730655412757187150418758392333984375e-5), SC_(577811.6427939229375161086906177400275569) }, 
      { SC_(35.515575408935546875), SC_(0.216575062950141727924346923828125e-5), SC_(461729.5432274267192940591041545317110485) }, 
      { SC_(35.515575408935546875), SC_(0.72700195232755504548549652099609375e-5), SC_(137547.0794806155767312939551779369164394) }, 
      { SC_(35.515575408935546875), SC_(0.14000004739500582218170166015625e-4), SC_(71424.41433572253924394173477030901070617) }, 
      { SC_(35.515575408935546875), SC_(0.17196454791701398789882659912109375e-4), SC_(58147.38800503622156242701682984885441441) }, 
      { SC_(35.515575408935546875), SC_(0.60085076256655156612396240234375e-4), SC_(16638.93535389697145567616644195839808463) }, 
      { SC_(35.515575408935546875), SC_(0.000116783194243907928466796875), SC_(8558.7439531443773341365422276985698545) }, 
      { SC_(35.515575408935546875), SC_(0.000149052008055150508880615234375), SC_(6704.935964257969942256683796604190388483) }, 
      { SC_(35.515575408935546875), SC_(0.0003985252114944159984588623046875), SC_(2505.122219132224374561111132130667265447) }, 
      { SC_(35.515575408935546875), SC_(0.00063875340856611728668212890625), SC_(1561.422298589200014741982262412434636973) }, 
      { SC_(35.515575408935546875), SC_(0.0010718167759478092193603515625), SC_(928.8722467787222242808854452351889563633) }, 
      { SC_(35.515575408935546875), SC_(0.00302191521041095256805419921875), SC_(326.8110378414911903385288649321631400664) }, 
      { SC_(35.515575408935546875), SC_(0.00499413348734378814697265625), SC_(196.1482005962757034094399257872899036696) }, 
      { SC_(35.515575408935546875), SC_(0.00928423367440700531005859375), SC_(103.6619197982581616421872226071400592126) }, 
      { SC_(35.515575408935546875), SC_(0.0241700224578380584716796875), SC_(37.45772609209636964536574943912854380171) }, 
      { SC_(35.515575408935546875), SC_(0.06227754056453704833984375), SC_(12.450993041772750669407167680667607419) }, 
      { SC_(35.515575408935546875), SC_(0.12234418094158172607421875), SC_(4.986241033913772097760869076957541032543) }, 
      { SC_(35.515575408935546875), SC_(0.249557673931121826171875), SC_(1.494248013206312554952038234048230712297) }, 
      { SC_(35.515575408935546875), SC_(0.4912221431732177734375), SC_(0.3133802674518380533642801450941624241265) }, 
      { SC_(35.515575408935546875), SC_(0.98384749889373779296875), SC_(0.03012063183422189552497230190183310697765) }, 
      { SC_(35.515575408935546875), SC_(1.1576130390167236328125), SC_(0.01488854601694810064869001826934615844448) }, 
      { SC_(35.515575408935546875), SC_(3.451677799224853515625), SC_(0.1249353030883651639444207203869412646859e-4) }, 
      { SC_(35.515575408935546875), SC_(7.88237094879150390625), SC_(0.1169663515742618634451758579426537250388e-8) }, 
      { SC_(35.515575408935546875), SC_(15.848876953125), SC_(0.1250851178791656557811931908536049655477e-13) }, 
      { SC_(35.515575408935546875), SC_(31.314670562744140625), SC_(0.5365332615381537353158263927841062696094e-20) }, 
      { SC_(35.515575408935546875), SC_(35.515575408935546875), SC_(0.2474098388705327630350038282012894724267e-21) }
   } };
#undef SC_




