#ifndef RGBA_TO_CIDX_H
#define RGBA_TO_CIDX_H

#include <sys/types.h>
#if defined(WIN32)
# include "../include/os.h"
#endif


typedef struct _ColormapColor		ColormapColor;


/*
 *	Colormap Color:
 */
struct _ColormapColor {
	u_int8_t        r, g, b;
};


extern int RGBAToCIdx(
	const u_int8_t *rgba,
	int width, int height, int bpl,
	int max_colors,
	u_int8_t **cidx_rtn,		/* Color index image data return */
	ColormapColor **cmap_rtn,	/* Colormap colors return */
	int *ncolors_rtn,		/* Number of colors in cmap_rtn */
	int (*progress_cb)(
		int, int,
		void *data
	), 
	void *data
);


#endif	/* RGBA_TO_CIDX_H */
