/*
                        Endeavour Recycle Bin Callbacks
 */

#ifndef RECBIN_CB_H
#define RECBIN_CB_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "edv_mime_type.h"
#include "recbin.h"


/* GTK+ Signal Callbacks */
extern void EDVRecBinContentsItemDestroyCB(gpointer data);

extern gint EDVRecBinDeleteEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint EDVRecBinKeyEventCB(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint EDVRecBinEnterNotifyEventCB(
	 GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVRecBinLeaveNotifyEventCB(
	 GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVRecBinButtonPressEventCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void EDVRecBinHandleChildAttachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void EDVRecBinHandleChildDetachedCB(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void EDVRecBinResizeColumnCB(
	GtkCList *clist, gint column, gint width, gpointer data
);
extern void EDVRecBinClickColumnCB(
	GtkCList *clist, gint column, gpointer data
);
extern void EDVRecBinSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
extern void EDVRecBinUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

/* Menu Item Callbacks */
extern void EDVRecBinMenuItemCB(GtkWidget *widget, gpointer data);
extern gint EDVRecBinMenuItemEnterCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVRecBinMenuItemLeaveCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

/* Find Bar Callbacks */
extern void EDVRecBinFindBarStartCB(edv_findbar_struct *fb, gpointer data);
extern void EDVRecBinFindBarEndCB(
	edv_findbar_struct *fb, gint total_matches, gpointer data
);
extern void EDVRecBinFindBarMatchCB(
	const gchar *path, const struct stat *lstat_buf,
	const gchar *excerpt, gint line_index,
	gpointer data
);

/* Status Bar Callbacks */
extern void EDVRecBinStatusMessageCB(const gchar *message, gpointer data);
extern void EDVRecBinStatusProgressCB(gfloat progress, gpointer data);

/* Write Protect Changed Callback */
extern void EDVRecBinWriteProtectChangedCB(
	edv_recbin_struct *recbin, gboolean state
);

/* Recycled Object Callbacks */
extern void EDVRecBinRecycledObjectAddedNotifyCB(
	edv_recbin_struct *recbin, guint index
);
extern void EDVRecBinRecycledObjectModifiedNotifyCB(
	edv_recbin_struct *recbin, guint index
);
extern void EDVRecBinRecycledObjectRemovedNotifyCB(
	edv_recbin_struct *recbin, guint index
);

/* Reconfigured Callback */
extern void EDVRecBinReconfiguredNotifyCB(edv_recbin_struct *recbin);

/* MIME Type Callbacks */
extern void EDVRecBinMimeTypeAddedCB(
	edv_recbin_struct *recbin,
	gint mt_num, edv_mime_type_struct *mt
);
extern void EDVRecBinMimeTypeModifiedCB(
	edv_recbin_struct *recbin,
	gint mt_num, edv_mime_type_struct *mt
);
extern void EDVRecBinMimeTypeRemovedCB(
	edv_recbin_struct *recbin, gint mt_num
);


#endif	/* RECBIN_CB_H */
