/*
** Copyright 1998 - 2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"courier.h"
#include	"rw.h"
#include	"comcargs.h"
#include	"rfc822.h"
#include	"afx.h"
#include	"afxtempl.h"
#include	<string.h>
#include	<signal.h>
#include	<stdlib.h>
#include	<stdio.h>

#if	HAVE_LOCALE_H
#include	<locale.h>
#endif

#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<iostream>
#include	"dbobj.h"
#include	"maxlongsize.h"
#include	"numlib/numlib.h"

static const char rcsid[]="$Id: aliascombine.C,v 1.7 2003/01/05 04:01:14 mrsam Exp $";

using namespace std;

static int readalias(DbObj &obj, CString &aliasname)
{
CString	key=aliasname + "\n0";
size_t	dummy;
char	*lenptr=obj.Fetch(key, key.GetLength(), dummy, 0);
size_t	num;
CString	name;
CString	namelist;
unsigned cnt;
char	buf[NUMBUFSIZE];

	if (!lenptr)
	{
		num=1;
	}
	else
	{
		num=atol(lenptr)+1;
		free(lenptr);
	}

	cnt=0;
	namelist="";
	for (;;)
	{
		if ( name << cin )	return (-1);
		if (name.GetLength() == 0)	break;
		if (cnt >= 100)
		{
			libmail_str_size_t(num++, buf);
			key=aliasname + "\n" + buf;
			
			if (obj.Store(key, key.GetLength(),
				namelist, namelist.GetLength()+1, "R"))
				return (-1);
			namelist="";
			cnt=0;
		}
		namelist += name.Mid(1, name.GetLength()-2) + "\n";
		++cnt;
	}

	if (cnt)
	{
		libmail_str_size_t(num, buf);
		key=aliasname + "\n" + buf;
		
		if (obj.Store(key, key.GetLength(),
			namelist, namelist.GetLength()+1, "R"))
			return (-1);
		key=aliasname + "\n0";
		libmail_str_size_t(num, buf);

		if (obj.Store(key, key.GetLength(), buf, strlen(buf)+1, "R"))
			return (-1);
	}
	return (0);
}

static int dumpdb(DbObj &obj)
{
char	*key, *val, *datval, *p;
size_t	keylen, vallen, datvallen;
CString	keystr, keybuf;
size_t	nblocks, i;
int	j;
char	buf[NUMBUFSIZE+1];

	for (key=obj.FetchFirstKeyVal(keylen, val, vallen); key;
		free(val), key=obj.FetchNextKeyVal(keylen, val, vallen))
	{
		memcpy(keystr.GetBuffer(keylen), key, keylen);
		keystr.ReleaseBuffer(keylen);
		j=keystr.Find('\n');
		if (strcmp((const char *)keystr+j, "\n0")) continue;
		cout << "*" << keystr.Left(j) << endl;
	}

	for (key=obj.FetchFirstKeyVal(keylen, val, vallen); key;
		free(val), key=obj.FetchNextKeyVal(keylen, val, vallen))
	{
		memcpy(keystr.GetBuffer(keylen), key, keylen);
		keystr.ReleaseBuffer(keylen);
		j=keystr.Find('\n');
		if (strcmp((const char *)keystr+j, "\n0")) continue;
		nblocks=atol(val);
		keystr=keystr.Left(j);
		cout << '<' << keystr << '>' << endl;
		for (i=0; i<nblocks; )
		{
			++i;
			buf[0]='\n';
			libmail_str_size_t(i, buf+1);
			keybuf=keystr + buf;
			if ((datval=obj.Fetch(keybuf, keybuf.GetLength(),
				datvallen, 0)) != 0)
			{
				for (p=datval; (p=strtok(p, "\n")) != 0; p=0)
					cout << '<' << p << '>' << endl;
				free(datval);
			}
		}
		cout << endl;
	}
	return (0);
}

int cppmain(int argc, char **argv)
{
char *filename=mktmpfilename();
DbObj tempdb;
CString	aliasname;

#if HAVE_SETLOCALE
	setlocale(LC_ALL, "C");
#endif

	clog_open_stderr("aliascombine");
	if (!filename || tempdb.Open(filename, "N"))
		clog_msg_errno();
	unlink(filename);
	free(filename);

	while ((aliasname << cin) == 0)
	{
		if (aliasname == ".")
		{
			if (dumpdb(tempdb))
			{
				clog_msg_prerrno();
				break;
			}

			cout << "." << endl;
			break;
		}
		aliasname=aliasname.Mid(1, aliasname.GetLength()-2);
		if (readalias(tempdb, aliasname))
		{
			clog_msg_prerrno();
			break;
		}
	}
	return (0);
}
