// curses++.cc
//
//  Copyright 1999,2000,2001 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  A few initialization routines and so on.

#include "curses++.h"

#include <stdarg.h>

#include <string>

//  Note: resize handling is *really* nasty.  REALLY nasty.  I mean it. :)

#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/ioctl.h>

cwindow rootwin=NULL;
cwindow rootwinhack=NULL;

using namespace std;

chstring::chstring(const string &s)
{
  (*this)=s;
}

chstring::chstring(const string &s, int attr)
{
  (*this)=s;
  set_attr(attr);
}

// Routines to manipulate chstrings:
void chstring::add_attr(int attrs)
{
  for(chstring::iterator i=begin(); i!=end(); ++i)
    (*i)|=attrs;
}

void chstring::remove_attr(int attrs)
{
  for(chstring::iterator i=begin(); i!=end(); ++i)
    (*i)&=~attrs;
}

void chstring::set_attr(int attrs)
{
  for(chstring::iterator i=begin(); i!=end(); ++i)
    (*i)=((*i)&A_CHARTEXT)|attrs;
}

int char_traits<chtype>::compare(const chtype *s1,
				 const chtype *s2,
				 size_t n)
{
  const chtype *s1end=s1+n;

  while(s1!=s1end)
    {
      chtype c1=*s1;
      chtype c2=*s2;

      if(c1<c2)
	return -1;
      else if(c1>c2)
	return 1;

      ++s1;
      ++s2;
    }

  return 0;
}

size_t char_traits<chtype>::length (const char_type* s)
{
  size_t rval=0;

  while(*s!=eos())
    {
      ++rval;
      ++s;
    }

  return rval;
}

chtype *char_traits<chtype>::assign(char_type *s,
				    size_t n,
				    const char_type &c)
{
  char_type *ends=s+n;

  while(s!=ends)
    {
      *s=c;
      ++s;
    }

  return s;
}

chstring &chstring::operator=(const std::string &s)
{
  erase();

  for(std::string::const_iterator i=s.begin();
      i!=s.end(); ++i)
    push_back((*i)|A_NORMAL);

  return *this;
}

void init_curses()
{
  rootwin=initscr();
  rootwinhack=rootwin;

  cbreak();
  noecho();
  nonl();
  intrflush(stdscr,FALSE);
  keypad(stdscr,TRUE);

  start_color();
}

void resize()
{
  int fd;

  if( (fd=open("/dev/tty",O_RDONLY)!=-1))
    {
      struct winsize w;
      if(ioctl(fd, TIOCGWINSZ, &w)!=-1)
	{
	  resizeterm(w.ws_row,w.ws_col);
	  rootwin=newwin(w.ws_row, w.ws_col, 0, 0);
	  assert(rootwin);
	  //assert(rootwin.getmaxy()==w.ws_row);
	  //assert(rootwin.getmaxx()==w.ws_col);
	  return;
	}
      else
	{
	  beep();
	  perror("ioctl");
	}
      close(fd);
    }
  else
    {
      beep();
      perror("open");
    }
}

int cwindow::printw(char *str, ...)
{
  va_list args;
  int amt;

  va_start(args, str);
  amt=vwprintw(win, str, args);
  va_end(args);

  return amt;
}

void cwindow::show_string_as_progbar(int x, int y, string s, int attr1, int attr2, int size1, int totalsize)
{
  int width,height;

  getmaxyx(height,width);

  attrset(attr1);
  move(y, x);

  for(int i=0; i<totalsize; i++)
    {
      if(i==size1)
	attrset(attr2);

      if(((unsigned int) i)<s.size())
	addch((unsigned char) s[i]);
      // Ack, that's ugly.  Remind me to use strings that have unsigned chars
      // as their contents next time..
      else
	addch(' ');
    }
}

void cwindow::display_header(string s, int attr)
  // Y'know, this could be just a call to show_as_progbar or whatever I called
  // it..
{
  attrset(attr);

  int width,height;
  getmaxyx(height,width);

  move(0,0);
  for(int i=0; i<width; i++)
    addch(' ');

  mvaddnstr(0,0,s.c_str(),width);
}

void cwindow::display_status(string s, int attr)
{
  attrset(attr);

  int width,height;
  getmaxyx(height,width);

  move(height-1,0);
  for(int i=0; i<width; i++)
    addch(' ');

  mvaddnstr(height-1,0,s.c_str(),width);
}
