/*____________________________________________________________________________
	
	Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)
	Portions copyright (C) 1998-1999 EMusic.com

	alsapmo.h by Gabor Fleischer <flocsy@usa.net>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
	$Id: alsapmo.h,v 1.16 2004/02/07 14:58:12 turtledavid Exp $
____________________________________________________________________________*/


#ifndef INCLUDED_ALSAPMO_H_
#define INCLUDED_ALSAPMO_H_

/* system headers */
#include <stdlib.h>

#include <alsa/asoundlib.h>

#define AUDIO_FORMAT_SIGNED_16    0x110
#define AUDIO_FORMAT_UNSIGNED_16  0x120
#define AUDIO_FORMAT_UNSIGNED_8   0x1
#define AUDIO_FORMAT_SIGNED_8     0x2
#define AUDIO_FORMAT_ULAW_8       0x4
#define AUDIO_FORMAT_ALAW_8       0x8

/* project headers */
#include <config.h>
#include "thread.h"
#include "mutex.h"
#include "pmo.h"
#include "pmoevent.h"
#include "eventbuffer.h"
#include "zinfvolume.h"

#define BIT_SELECT  0x1f
#define SLEEPTIME   256

static const uint32_t OBUFFERSIZE = 2 * 1152;

enum {
    pmoError_MinimumError = 0x00010000,
    pmoError_DeviceOpenFailed,
    pmoError_IOCTL_F_GETFL,
    pmoError_IOCTL_F_SETFL,
    pmoError_IOCTL_SNDCTL_DSP_RESET,
    pmoError_IOCTL_SNDCTL_DSP_SAMPLESIZE,
    pmoError_IOCTL_SNDCTL_DSP_STEREO,
    pmoError_IOCTL_SNDCTL_DSP_SPEED,
    pmoError_ALSA_CardNumber,
    pmoError_ALSA_DeviceNumber,
    pmoError_ALSA_Playback_Info,
    pmoError_ALSA_Playback_Params,
    pmoError_ALSA_DeviceCloseFailed,
    pmoError_ALSA_MixerOpenFailed,
    pmoError_ALSA_Mixer_Info,
    pmoError_MaximumError
};

class AlsaPMO : public PhysicalMediaOutput
{
public:
    AlsaPMO(FAContext *context);
    virtual ~AlsaPMO();
    
    virtual Error Init(OutputInfo* info);
    static void   StartWorkerThread(void *);
    virtual void  Pause(void);
    void SetVolume(int32_t left, int32_t right);
    void GetVolume(int32_t &left, int32_t &right);
    
 private:

    void	WorkerThread(void); 
    int 	get_space(void);    
    virtual Error Reset(bool user_stop);
    void          HandleTimeInfoEvent(PMOTimeInfoEvent *pEvent);
    bool          WaitForDrain(void);  
    struct mgroup {
	long int min;
	long int max;
	long int volumeR;
	long int volumeL;
    }m_group;    
    bool	m_properlyInitialized;
#ifdef SOUNDCARD
    static int audio_fd;
#endif
    Thread	*m_pBufferThread;
    int		m_iOutputBufferSize, m_iBytesPerSample;
    int		m_iBaseTime;
    int		m_iDataSize, rd_index;
    int		alsa_bits_per_sample, alsa_frame_size,alsa_bps; 
    struct 	pollfd *pfds;
    int 	nfds;
    int		m_iCard, m_iDevice;
    int		m_iChannel;
    snd_pcm_t	*m_handle;
    FAContext   *m_context;
    int		m_channels, m_samples, m_samplesPerFrame;
    long int		totalWrittenToALSABuffer;
};

#endif /* _ALSAPMO_H_ */

/* arch-tag: 3ff9fd60-d55f-430b-8be0-940b7cd2f45a
   (do not change this comment) */
