#ifndef _CRC32_H
#define _CRC32_H 1

#ifndef HAVE_U_INT32_T
# ifdef HAVE_UINT32_T
   typedef uint32_t u_int32_t;
# else
   /* Just pray that this is large enough. */
   typedef unsigned long int u_int32_t;
/*#  error "Cannot find a 32 bit unsigned type!" */
# endif
#endif

/* CRC32 context */
struct crc32_ctx
{
	size_t byte_count;
	u_int32_t crc32;
};

/* make the interface identical to that exported by md5.c */
#define crc32_finish_ctx(ctx) (void)0
extern void crc32_init_ctx(struct crc32_ctx *ctx);
extern u_int32_t crc32_process_bytes(const void *buffer, size_t len, struct crc32_ctx *ctx);
extern u_int32_t crc32_read_ctx(const struct crc32_ctx *ctx);

#endif /* _CRC32_H */

