#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../include/Y2/Y.h"
#include "../include/Y2/Ylib.h"

#include "../include/string.h"


static void print_help(void);


#define MIN(a,b)        ((a) < (b) ? (a) : (b))
#define MAX(a,b)        ((a) > (b) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define ABSOLUTE(x)     (((x) < 0) ? ((x) * -1) : (x))


/*
 *	Prints help message.
 */
static void print_help(void)
{
	printf("\
Usage: yclientmessage [options] [message]\n\
\n\
    [options] can be any of the following:\n\
\n\
        --format <string|binary>     Specifies the message data format.\n\
        --type <#>                   Specifies the message type (value must\n\
                                     be an integer).\n\
        --recorder <address:port>    Specify which Y server to connect to.\n\
\n\
    Return values:\n\
\n\
        0       Success.\n\
        1       General error.\n\
        2       Cannot connect to Y server error.\n\
        3       Systems error.\n\
\n"
	);
}


int main(int argc, char *argv[])
{
	int i;
	const char *arg_ptr;

	const char *con_arg = NULL;

	YConnection *con = NULL;

	int format = YClientMessageFormatString;
	int type = YClientMessageTypeComment;
	char message[YClientMessageMessageMax];


        *message = '\0';

	/* If no arguments are given then print the help message. */
	if(argc < 2)
	{
	    print_help();
	    return(1);
	}

	/* Parse arguments. */
	for(i = 1; i < argc; i++)
	{
	    arg_ptr = argv[i];
	    if(arg_ptr == NULL)
		continue;

	    /* Help. */
	    if(strcasepfx(arg_ptr, "--h") ||
               strcasepfx(arg_ptr, "-h") ||
               !strcmp(arg_ptr, "?")
	    )
	    {
		print_help();
		return(0);
	    }
            /* Connect address. */
            else if(strcasepfx(arg_ptr, "--rec") ||
                    strcasepfx(arg_ptr, "-rec")
            )
            {
                i++;
                arg_ptr = (i < argc) ? argv[i] : NULL;
		if(arg_ptr != NULL)
                {
                    con_arg = arg_ptr;
                }
                else
                {
                    fprintf(
			stderr,
			"%s: Requires argument.\n",
			argv[i - 1]
                    );
		    continue;
                }
            }
            /* Message format. */
            else if(strcasepfx(arg_ptr, "--f") ||
                    strcasepfx(arg_ptr, "-f")
            )
            {
                i++;
                arg_ptr = (i < argc) ? argv[i] : NULL;
                if(arg_ptr != NULL)
                {
		    if(!strcasecmp(arg_ptr, "string"))
			format = YClientMessageFormatString;
		    else if(!strcasecmp(arg_ptr, "binary"))
                        format = YClientMessageFormatBinary;
		    else if(!strcasecmp(arg_ptr, "integer8"))
                        format = YClientMessageFormatInteger8;
                    else if(!strcasecmp(arg_ptr, "integeru8"))
                        format = YClientMessageFormatIntegerU8;
                    else if(!strcasecmp(arg_ptr, "integer16"))
                        format = YClientMessageFormatInteger16;
                    else if(!strcasecmp(arg_ptr, "integeru16"))
                        format = YClientMessageFormatIntegerU16;
                    else if(!strcasecmp(arg_ptr, "integer24"))
                        format = YClientMessageFormatInteger24;
                    else if(!strcasecmp(arg_ptr, "integeru24"))
                        format = YClientMessageFormatIntegerU24;
                    else if(!strcasecmp(arg_ptr, "integer32"))
                        format = YClientMessageFormatInteger32;
                    else if(!strcasecmp(arg_ptr, "integeru32"))
                        format = YClientMessageFormatIntegerU32;
                    else if(!strcasecmp(arg_ptr, "integer64"))
                        format = YClientMessageFormatInteger64;
                    else if(!strcasecmp(arg_ptr, "integeru64"))
                        format = YClientMessageFormatIntegerU64;
                    else
                        format = YClientMessageFormatString;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        argv[i - 1]
                    );
                    continue;
                }
            }
            /* Message type. */
            else if(strcasepfx(arg_ptr, "--t") ||
                    strcasepfx(arg_ptr, "-t")
            )
            {
                i++;
                arg_ptr = (i < argc) ? argv[i] : NULL;
                if(arg_ptr != NULL)
                {
                    type = atoi(arg_ptr);
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        argv[i - 1]
                    );
                    continue;
                }
            }
            /* All else assume message. */
            else if((*arg_ptr != '\0') &&
                    (*arg_ptr != '-') &&
                    (*arg_ptr != '+')
	    )
	    {
		strncpy(message, arg_ptr, YClientMessageMessageMax);
		message[YClientMessageMessageMax - 1] = '\0';
	    }
	}


        /* Connect to Y server. */
        con = YOpenConnection(
            NULL,               /* No start argument. */
            con_arg
        );
        if(con == NULL)
        {
            fprintf(stderr, "Cannot connect to Y server");
            if(con_arg == NULL)
                con_arg = getenv("RECORDER");
            if(con_arg == NULL)
                fprintf(stderr, ".\n");
            else
                fprintf(stderr, ": %s\n", con_arg);
            return(2);
        }

	/* Send client message. */
	if(YSendClientMessage(
	    con, True, format, type, message, strlen(message)
	))
	{
	    /* Error sending client message. */
	    fprintf(
		stderr,
		"Error sending client message.\n"
	    );
	}
	else
	{
	    Boolean need_break = False;
	    YEvent event;
	    YEventClientMessage *clientmessage;

	    /* Wait for client message response, we should get a
	     * YClientMessage event since we specified that we want
	     * one in the call to YSendClientMessage().
	     */
	    while(YGetNextEvent(con, &event, True) > 0)
	    {
		switch(event.type)
		{
		  case YDisconnect:
		  case YShutdown:
		    YCloseConnection(con, False);
		    con = NULL;
		    need_break = True;
		    break;

		  case YClientMessage:
		    clientmessage = &event.clientmessage;
		    if(clientmessage->length > 0)
		    {
			int len = MIN(
			    clientmessage->length,
			    YClientMessageMessageMax - 1
			);
			memcpy(message, clientmessage->message, len);
			message[len] = '\0';
		    }
		    else
		    {
			*message = '\0';
		    }
		    switch(format)
		    {
		      case YClientMessageFormatString:
			printf(
			    "Sent client message \"%s\"\n",
			    message
			);
			break;

                      case YClientMessageFormatBinary:
                        printf(
                            "Sent client message (binary)\n"
                        );
                        break;
                      case YClientMessageFormatInteger8:
                        printf(
                            "Sent client message value %i\n",
                            *(int8_t *)message
                        );
                        break;
                      case YClientMessageFormatIntegerU8:
                        printf(
                            "Sent client message value %i\n",
                            *(u_int8_t *)message
                        );
                        break;
                      case YClientMessageFormatInteger16:
                        printf(
                            "Sent client message value %i\n",
                            *(int16_t *)message
                        );
                        break;
                      case YClientMessageFormatIntegerU16:
                        printf(
                            "Sent client message value %i\n",
                            *(u_int16_t *)message
                        );
                        break;
                      case YClientMessageFormatInteger24:
                        printf(
                            "Sent client message value %i\n",
                            *(int32_t *)message
                        );
                        break;
                      case YClientMessageFormatIntegerU24:
                        printf(
                            "Sent client message value %i\n",
                            *(u_int32_t *)message
                        );
                        break;
                      case YClientMessageFormatInteger32:
                        printf(
                            "Sent client message value %i\n",
                            *(int32_t *)message
                        );
                        break;
                      case YClientMessageFormatIntegerU32:
                        printf(
                            "Sent client message value %i\n",
                            *(u_int32_t *)message
                        );
                        break;
                      case YClientMessageFormatInteger64:
                        printf(
                            "Sent client message value %ld\n",
                            (long)(*(int64_t *)message)
                        );
                        break;
                      case YClientMessageFormatIntegerU64:
                        printf(
                            "Sent client message value %ld\n",
                            (unsigned long)(*(u_int64_t *)message)
                        );
                        break;
		    }
		    need_break = True;
		    break;
		}
		if(need_break)
		    break;
	    }
	}

        /* Disconnect from Y server. */
        YCloseConnection(con, False);
        con = NULL;

	return(0);
}
