/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "singit/config_xmms.h"
#include "singit/macros.h"

#include "singit_debug.h"
#include "editor_config.h"
#include "editor_status.h"

static gpointer editor_config_init_event(SingitConfigGen *scg, gpointer user_data)
{
	EditorConfigData *editor_config_data = g_malloc(sizeof(EditorConfigData));

	editor_config_data->multiSelect = FALSE;
	editor_config_data->showHints = TRUE;
	editor_config_data->extendedLyrics = TRUE;
	editor_config_data->checkSyncBeforeSave = FALSE;

	editor_config_data->reactionTime = 500;
	editor_config_data->underscoreWhiteTransform = 0;
	editor_config_data->stripHtml = 6;

#ifdef HAVE_QUERY_DEPS
	editor_config_data->artistMatch = MATCH_PERFECT;
	editor_config_data->titleMatch = MATCH_FIRST;
#endif

	editor_config_data->winPosX = -1;
	editor_config_data->winPosY = -1;

	return editor_config_data;
}

static void editor_config_free_event(SingitConfigGen *scg, EditorConfigData *cfg_data, gpointer user_data)
{
	g_free(cfg_data);
}

#define CFG_DATA     cfg_data
#define CFG_FILE     cfg_file
#define SECTION     "SingitEditor"

static void editor_config_load_event(SingitConfigGen *scg, ConfigFile* cfg_file, EditorConfigData *cfg_data, gpointer user_data)
{
	READ_CFG_DEF(boolean, multiSelect, FALSE);
	READ_CFG_DEF(boolean, showHints, TRUE);
	READ_CFG_DEF(boolean, extendedLyrics, TRUE);
	READ_CFG_DEF(boolean, checkSyncBeforeSave, FALSE);

	READ_CFG_DEF(int, reactionTime, 500);
	READ_CFG_DEF(int, underscoreWhiteTransform, 0);
	READ_CFG_DEF(int, stripHtml, 7);

#ifdef HAVE_QUERY_DEPS
	READ_CFG_DEF_CAST(int, artistMatch, MATCH_PERFECT);
	READ_CFG_DEF_CAST(int, titleMatch, MATCH_FIRST);
#endif

	READ_CFG_DEF(int, winPosX, -1);
	READ_CFG_DEF(int, winPosY, -1);
}

static void editor_config_save_event(SingitConfigGen *scg, ConfigFile* cfg_file, EditorConfigData *cfg_data, gpointer user_data)
{
	WRITE_CFG(boolean, multiSelect);
	WRITE_CFG(boolean, showHints);
	WRITE_CFG(boolean, extendedLyrics);
	WRITE_CFG(boolean, checkSyncBeforeSave);

	WRITE_CFG(int, reactionTime);
	WRITE_CFG(int, underscoreWhiteTransform);
	WRITE_CFG(int, stripHtml);

#ifdef HAVE_QUERY_DEPS
	WRITE_CFG(int, artistMatch);
	WRITE_CFG(int, titleMatch);
#endif

	WRITE_CFG(int, winPosX);
	WRITE_CFG(int, winPosY);
}

#undef SECTION
#undef CFG_FILE
#undef CFG_DATA

SingitConfigGen* editor_config_new(void)
{
	g_return_val_if_fail(EDT_STATUS, NULL);
	g_return_val_if_fail(EDT_STATUS->config == NULL,
		SINGIT_CONFIG_GEN(EDT_STATUS->config));

	EDT_STATUS->config = singit_config_xmms_new();
	singit_config_gen_set_filename
		(EDT_STATUS->config, CONFIG_FILENAME);
	singit_config_gen_clear_initial(&EDT_STATUS->config);

	gtk_signal_connect(GTK_OBJECT(EDT_STATUS->config), "init_data",
		GTK_SIGNAL_FUNC(editor_config_init_event), NULL);
	gtk_signal_connect(GTK_OBJECT(EDT_STATUS->config), "free_data",
		GTK_SIGNAL_FUNC(editor_config_free_event), NULL);
	gtk_signal_connect(GTK_OBJECT(EDT_STATUS->config), "load",
		GTK_SIGNAL_FUNC(editor_config_load_event), NULL);
	gtk_signal_connect(GTK_OBJECT(EDT_STATUS->config), "save",
		GTK_SIGNAL_FUNC(editor_config_save_event), NULL);

	return EDT_STATUS->config;
}
