/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2003 Nicolas Adenis-Lamarre (aspegic500@free.fr)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_XOSD_CONFIG_H__
#define __DISPLAYER_XOSD_CONFIG_H__

#include "singit/config_xmms.h"
#include "xosd.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct{

  gboolean forceGlobals;
  
  /* has global equivalent */
  //gboolean showEmpty;
  //gboolean autoResize;
  gboolean debugEnable;
  
  /* string values */
  gchar   *lyricFontName;
  gchar   *normalTextColor;
  gint shadow_offset;
  gint h_offset;
  gint v_offset;
  //gchar   *progressTextColor;
  //gchar   *progressBarColor;
  
  /* integer values */
  xosd_align alignement;
  xosd_pos position;
}
XosdConfigData;

SingitConfigGen *displayer_xosd_config_new(void);

#define GET_DCC ((XosdConfigData *) \
	singit_config_gen_get_data(STATUS->m_config))

#define DEBUG(x) \
	do { if (STATUS && GET_DSCD && GET_DSCD->debugEnable) debug x; } while (0);

#define GET_CFG(val) (GET_DCC->forceGlobals == TRUE) \
	? (GET_SCD->val) : GET_DCC->val

#ifdef __cplusplus
}
#endif // __cplusplus

#endif  // __DISPLAYER_XOSD_CONFIG_H__
