
#ifndef __X_FLOAT_LIST_H__
#define __X_FLOAT_LIST_H__

// by Andrew O'Meara

#include "XPtrList.h"
#include "UtilStr.h"
#include "XLongList.h"


class XFloatList : public XPtrList {

public:
	XFloatList( ListOrderingT inOrdering = cOrderNotImportant );		// See XPtrList.h for ListOrderingT choices

	// See XPtrList.h for description of functions.
	inline long				Add( float inNum )								{ return XPtrList::Add( *((void**) &inNum) );			}
	inline float			Fetch( long inIndex )							{ long t = (long) XPtrList::Fetch( inIndex ); return *((float*) &t);}
	inline bool				Fetch( long inIndex, float* ioPtrDest ) const	{ return XPtrList::Fetch( inIndex, (void**)ioPtrDest );	}

	// Computes a specified number of values that represent center-values for that current list of floats
	// Note: if this float list isn't already sorted from LowToHigh, GetMeans() will have to perform a full sort!!
	void					FindMeans( long inNumMeans, float outMeans[], float inSigmaScale = 0.05 ) const;

	// Smoothes all the floats in this list
	void					GaussSmooth( float inSigma, bool inCircular );

	float					operator[] ( const long inIndex )				{ long t = (long) XPtrList::Fetch( inIndex ); return *((float*) &t);}

	// Generic utility fcn to gauss-smooth a 1D curve.
	static void				GaussSmooth( float inSigma, long inN, bool inCircular, float inSrceDest[] );
	static void				GaussSmooth( float inSigma, long inN, bool inCircular, float inSrce[], float inDest[] );

	static void				SlopeSmooth( float inSmoothness, long inN, float ioData[] );

protected:
	static int				sFloatComparitor( const void* inA, const void* inB, const void* inPtr );
	static int				sQSFloatComparitor( const void* inA, const void* inB );

#define MASK_MAX		40

	static float			sMask[ MASK_MAX ];
	static UtilStr			sTemp;
};

#endif // __X_FLOAT_LIST_H__
