

#ifndef __RECT_UTILS_H__
#define __RECT_UTILS_H__

#include "Eg Common.h"

#ifdef WIN_QUICKTIME_PRESENT
#include <QuickDraw.h>
#endif

#if EG_WIN || EG_X

#ifndef WIN_QUICKTIME_PRESENT
extern short 		PtInRect( const Point& inPt, const Rect* inRect );
#endif

extern void		UnionRect( const Rect* inR1, const Rect* inR2, Rect* outRect );
extern void		OffsetRect( Rect* inRect, int inDelX, int inDelY );
extern void		InsetRect( Rect* inR, int inDelX, int inDelY );
extern void		SetRect( Rect* inR, long left, long top, long right, long bot );

#endif

#if EG_MAC
#include <QuickDraw.h>
#endif

extern bool		IntersectRect( const Rect* inR1, const Rect* inR2, Rect* outRect );
extern void		OffsetRect( const Rect& inRect, Rect* outRect, int inDelX, int inDelY );
extern void		UnionPt( long x, long y, Rect* ioRect );
extern void		SetRect( Rect* ioRect, const LongRect* inRect );
extern void		SetRect( LongRect* ioRect, const Rect* inRect );
extern void		InsetRect( LongRect* inR, int inDelX, int inDelY );

// Returns 0 if rect has a 0 or negative area
extern int		PositiveArea( const Rect& inRect );

// Returns 0 if rect has negative area
extern int		IsValidRect( const Rect& inRect );

#endif // __RECT_UTILS_H__
