

void FourierAnalyzer::TransformPolar( __inputElementType inF[], long inN, long inNumBins, float inBinRange, float inFreqStart, float outMagnitude[], float outAngle[] ) {

	int j;

	// Precompute trig tables for the sample we're about to handle (and are likely to handle in the future)
	// Regenerate trig lookup tables only if client asks for different specs
	if ( inBinRange != mBinRange || mN != inN || inNumBins != mNumBins || mFreqStart != inFreqStart )
		GenerateTrigTables( inN, inNumBins, inBinRange, inFreqStart );

	// Perform the FFT to get the real and imaginary spectrum components
	Transform( inF, inN, inNumBins, inBinRange, inFreqStart, mSinFT, outMagnitude );

	// Calculate the phase angle for each freq bin
	if ( outAngle ) {
		for ( j = 0; j < inNumBins; j++ )
			outAngle[ j ] = atan2( mSinFT[ j ], outMagnitude[ j ] );
	}

	// Calculate the magnitude of each freq component (ie, it's independent of the phase angle)
	for ( j = 0; j < inNumBins; j++ )
		outMagnitude[ j ] = sqrt( outMagnitude[ j ] * outMagnitude[ j ] + mSinFT[ j ] * mSinFT[ j ] );
}


void FourierAnalyzer::Transform( __inputElementType inF[], long inN, long inNumBins, float inBinRange, float inFreqStart, float outSin[], float outCos[] ) {

	float* trig, samp;
	int i, j;

	// Precompute trig tables for the sample we're about to handle (and are likely to handle in the future)
	// Regenerate trig lookup tables only if client asks for different specs
	if ( inBinRange != mBinRange || mN != inN || inNumBins != mNumBins || mFreqStart != inFreqStart )
		GenerateTrigTables( inN, inNumBins, inBinRange, inFreqStart );

	// Init the output freq spectrums
	for ( i = 0; i < mNumBins; i++ )
		outSin[ i ] = 0;
	for ( i = 0; i < mNumBins; i++ )
		outCos[ i ] = 0;

	// Finally, we can do the fourier transform...
	trig = mTrigLookup;
	for ( i = 0; i < inN; i++ ) {
		samp = inF[ i ];
		for ( j = 0; j < inNumBins; j++ ) {
			outCos[ j ] += (*trig) * samp; trig++;	// *trig here is cos( j * 2pi * (i/inN) )
			outSin[ j ] += (*trig) * samp; trig++;	// *trig here is sin( j * 2pi * (i/inN) )
		}
	}

}
