/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "displayer_karaoke_window_status.h"

// Since the karaoke_window is a singleton, keep this global static object
static SingitSingleton       *karaoke_window_status = NULL;
static SingitSingletonClass  *parent_class = NULL;

static void karaoke_window_status_class_init (KaraokeWindowNewStatusClass *klass);
static void karaoke_window_status_init (KaraokeWindowNewStatus *sstat);
static void karaoke_window_status_destroy(GtkObject *object);

GtkType karaoke_window_status_get_type (void)
{
	static GtkType karaoke_window_status_type = 0;

	if (!karaoke_window_status_type) {

		static const GtkTypeInfo karaoke_window_status_info =
		{
			(gchar*) "KaraokeWindowNewStatus",
			sizeof (KaraokeWindowNewStatus),
			sizeof (KaraokeWindowNewStatusClass),
			(GtkClassInitFunc) karaoke_window_status_class_init,
			(GtkObjectInitFunc) karaoke_window_status_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		karaoke_window_status_type = gtk_type_from_name("KaraokeWindowNewStatus");
		if ((karaoke_window_status_type == GTK_TYPE_NONE) ||
			(karaoke_window_status_type == GTK_TYPE_INVALID))
		{
			karaoke_window_status_type = gtk_type_unique
				(TYPE_SINGIT_SINGLETON, &karaoke_window_status_info);
		}
		else { parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON); }
	}

	return karaoke_window_status_type;
}

static void karaoke_window_status_class_init (KaraokeWindowNewStatusClass *klass)
{
	GtkObjectClass *object_class = (GtkObjectClass*) klass;

	parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON);

	object_class->destroy = karaoke_window_status_destroy;
}

static void karaoke_window_status_init(KaraokeWindowNewStatus *sstat)
{
	sstat->timestamp_context_id = 0;
	sstat->song_context_id = 0;
	sstat->messageCounter = 0;
	sstat->jump_to_song = 0;

	sstat->fileName = NULL;
	sstat->song = NULL;
	sstat->update_song = FALSE;

	sstat->print_debug = FALSE;
	sstat->toggle_yz = FALSE;
	sstat->guess_synced_lyrics = FALSE;
	sstat->show_jumping_ball = FALSE;
	sstat->hide_if_not_found = TRUE;
	sstat->hide_if_not_found_fullscreen = FALSE;
	sstat->auto_resize = TRUE;

	sstat->start_fullscreen = FALSE;
	sstat->is_fullscreen = FALSE;

	sstat->karaoke_widget = NULL;
	sstat->fullscreen_background_color = NULL;
}

static void karaoke_window_status_destroy(GtkObject *object)
{
	KaraokeWindowNewStatus *sstat;

	g_return_if_fail(object != NULL);
	g_return_if_fail(IS_KARAOKE_WINDOW_STATUS (object));

	sstat = KARAOKE_WINDOW_STATUS(object);

	sstat->messageCounter = 0;
	sstat->timestamp_context_id = 0;

	if (sstat->fileName) {
		g_free(sstat->fileName);
		sstat->fileName = NULL;
	}

	if (sstat->fullscreen_background_color) {
		g_free(sstat->fullscreen_background_color);
		sstat->fullscreen_background_color = NULL;
	}

	singit_song_detach(&sstat->song);

	if (GTK_OBJECT_CLASS(parent_class)->destroy)
		GTK_OBJECT_CLASS(parent_class)->destroy(object);
}

SingitSingleton* karaoke_window_status_ref(void)
{
	gboolean init;
	SingitSingleton *status = singit_singleton_construct
		(&karaoke_window_status, TYPE_KARAOKE_WINDOW_STATUS, &init);
	if (init == TRUE)
		{ return status; }
	return singit_singleton_attach(status);
}

void karaoke_window_status_unref(SingitSingleton** single)
{
	g_return_if_fail(karaoke_window_status != NULL);

	if (single == NULL) {
		SingitSingleton* unref_single = karaoke_window_status;
		singit_singleton_detach(&unref_single);
	}
	else {
		g_return_if_fail(*single == karaoke_window_status);
		singit_singleton_detach(single);
	}
}

SingitSingleton* karaoke_window_status_noref(void)
{
	if (karaoke_window_status == NULL)
		{ return NULL; }

	g_return_val_if_fail(IS_KARAOKE_WINDOW_STATUS(karaoke_window_status), NULL);

	return karaoke_window_status;
}
