/* -----------------------------------------------------------------------
   xpm button routines for XfreeCD
   
   Copyright 1998 by Brian C. Lane
   ----------------------------------------------------------------------- */
#include <gtk/gtk.h>
#include "xpm_button.h"

/* Create a button with 2 xpm pixmaps for pressed and unpressed states */
GtkWidget *xpm_button( GtkWidget *parent, struct _pbutton *pb )
{
  GtkWidget	*event_box;
  GtkWidget	*hbox;
  GtkStyle	*style;

  /* get style of button.. I assume it's to get the background color.
   * if someone knows the real reason, please enlighten me. */
  style = gtk_widget_get_style( parent );

  /* Make a hbox to hold the image */
  hbox = gtk_hbox_new( FALSE, 0 );
  gtk_container_border_width( GTK_CONTAINER( hbox ), 0 );

  /* now on to the xpm stuff.. load xpm */
  pb->image.up_pixmap = gdk_pixmap_create_from_xpm_d (parent->window,
                                       &pb->image.up_mask,
                                       &style->bg[GTK_STATE_NORMAL],
                                       (gchar **) pb->up_xpm);

  pb->image.dn_pixmap = gdk_pixmap_create_from_xpm_d (parent->window,
                                       &pb->image.dn_mask,
                                       &style->bg[GTK_STATE_NORMAL],
                                       (gchar **) pb->dn_xpm);

  /* Start with the up image */
  pb->wid = gtk_pixmap_new (pb->image.up_pixmap, pb->image.up_mask);

  gtk_box_pack_start (GTK_BOX (hbox), pb->wid, FALSE, FALSE, 0);

  gtk_widget_show(pb->wid);
     
  /* Create the event box that will hold the image and callbacks */
  event_box = gtk_event_box_new();
/*  gtk_container_add (GTK_CONTAINER(parent), event_box);          
 * gtk_widget_show (event_box);
 */

  /* Add the box containing the image to the button */
  gtk_container_add (GTK_CONTAINER (event_box), hbox);  

  /* Make sure that the image is visible */
  gtk_widget_show( hbox );

  /* Set the clipping size (this should come from the pixmap somehow) */
/*  gtk_widget_set_usize (hbox, 29, 30); */

  /* Add the callback functions */
  gtk_widget_set_events( event_box, GDK_BUTTON_PRESS_MASK |
                                    GDK_BUTTON_RELEASE_MASK );

  gtk_signal_connect (GTK_OBJECT (event_box), "button_press_event",
                      GTK_SIGNAL_FUNC (pb->press), NULL );
  gtk_signal_connect (GTK_OBJECT (event_box), "button_release_event",
                      GTK_SIGNAL_FUNC (pb->release), NULL );

  return( event_box );
}
