/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.Context;
import com.icl.saxon.om.AttributeInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NodeImpl;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class AttributeImpl
extends NodeImpl
implements AttributeInfo,
Attr {
    protected Name name;
    protected String value;

    public AttributeImpl() {
    }

    public AttributeImpl(ElementImpl elementImpl, Name name) {
        this.parent = elementImpl;
        AttributeCollection attributeCollection = elementImpl.getAttributeList();
        this.index = attributeCollection.getPosition(name);
        this.name = attributeCollection.getExpandedName(this.index);
        this.value = attributeCollection.getValue(this.index);
    }

    public AttributeImpl(ElementImpl elementImpl, int n) throws SAXException {
        this.parent = elementImpl;
        this.index = n;
        this.name = elementImpl.getAttributeList().getExpandedName(n);
        this.value = elementImpl.getAttributeList().getValue(n);
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof AttributeImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        AttributeImpl attributeImpl = (AttributeImpl)nodeInfo;
        return this.parent.isSameNode(attributeImpl.parent) && this.name.equals(attributeImpl.name);
    }

    public long getSequenceNumber() {
        return this.parent.getSequenceNumber() + 32768L + (long)this.index;
    }

    public final short getNodeType() {
        return 2;
    }

    public String getValue() {
        return this.value;
    }

    public Name getExpandedName() {
        return this.name;
    }

    public final String getURI() {
        return this.name.getURI();
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public NodeInfo getPreviousInDocument() {
        return null;
    }

    public NodeInfo getNextInDocument() {
        return null;
    }

    public int getNumberSingle(Pattern pattern, Pattern pattern2) throws SAXException {
        throw new SAXException("getNumberSingle() is not supported for attribute nodes");
    }

    public int getNumberAny(Pattern pattern, Pattern pattern2) throws SAXException {
        throw new SAXException("getNumberAny() is not supported for attribute nodes");
    }

    public Vector getNumberMulti(Pattern pattern, Pattern pattern2) throws SAXException {
        throw new SAXException("getNumberMulti() is not supported for attribute nodes");
    }

    public String getSequentialKey() {
        return this.parent.getSequentialKey() + "_" + this.name;
    }

    public void copy(Outputter outputter) throws SAXException {
        outputter.writeAttribute(this.name, this.value);
    }

    public void defaultAction(Context context) throws SAXException {
        context.getOutputter().writeContent(this.value);
    }

    public String getPath() {
        return this.parent.getPath() + "/@" + this.name;
    }

    public String toString() {
        return this.name.getDisplayName() + "=\"" + this.value + "\"";
    }

    public String getName() {
        return this.getDisplayName();
    }

    public boolean getSpecified() {
        return true;
    }

    public void setValue(String string) throws DOMException {
        this.disallowUpdate();
    }

    public Element getOwnerElement() {
        return (ElementImpl)this.parent;
    }
}

