/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Loader;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.DocumentHandlerProxy;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.FOPEmitter;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.style.StyleElement;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class XSLOutput
extends StyleElement {
    String method = null;
    String version = null;
    String indent = null;
    String encoding = null;
    String mediaType = null;
    String doctypeSystem = null;
    String doctypePublic = null;
    String omitDeclaration = null;
    String standalone = null;
    Vector cdataElements = null;
    Emitter handler = null;

    public void prepareAttributes() throws SAXException {
        Object object;
        Object object2;
        this.checkAllowedAttributes();
        this.method = this.getAttributeValue("method");
        if (!(this.method == null || this.method.equals("xml") || this.method.equals("html") || this.method.equals("text"))) {
            object2 = new Name(this.method, this, false);
            if (((Name)object2).getPrefix().equals("")) {
                throw this.styleError("method must be xml, html, or text, or a prefixed name");
            }
            object = ((Name)object2).getLocalName();
            if (((String)object).equals("fop")) {
                this.handler = new FOPEmitter();
                this.method = "saxon:user";
            } else if (((String)object).equals("xhtml")) {
                this.method = "xhtml";
            } else {
                this.handler = XSLOutput.makeEmitter((String)object);
                this.method = "saxon:user";
            }
        }
        this.version = this.getAttributeValue("version");
        this.indent = this.getIndent();
        this.encoding = this.getAttributeValue("encoding");
        this.mediaType = this.getAttributeValue("media-type");
        this.doctypeSystem = this.getAttributeValue("doctype-system");
        this.doctypePublic = this.getAttributeValue("doctype-public");
        this.omitDeclaration = this.getAttributeValue("omit-xml-declaration");
        if (this.omitDeclaration != null && !this.omitDeclaration.equals("yes") && !this.omitDeclaration.equals("no")) {
            throw this.styleError("omit-xml-declaration attribute must be yes or no");
        }
        this.standalone = this.getAttributeValue("standalone");
        if (this.standalone != null && !this.standalone.equals("yes") && !this.standalone.equals("no")) {
            throw this.styleError("standalone attribute must be yes or no");
        }
        object2 = this.getAttributeValue("cdata-section-elements");
        if (object2 != null) {
            this.cdataElements = new Vector();
            object = new StringTokenizer((String)object2);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                Name name = new Name(string, this, true);
                this.cdataElements.addElement(name);
            }
        }
    }

    protected String getIndent() throws SAXException {
        String string = this.getAttributeValue("indent");
        if (string == null || string.equals("yes") || string.equals("no")) {
            return string;
        }
        throw this.styleError("indent must be yes or no");
    }

    protected void checkAllowedAttributes() throws SAXException {
        String[] stringArray = new String[]{"method", "version", "indent", "encoding", "media-type", "doctype-system", "doctype-public", "omit-xml-declaration", "standalone", "cdata-section-elements"};
        this.allowAttributes(stringArray);
    }

    public void validate() throws SAXException {
        this.checkTopLevel();
        this.checkEmpty();
    }

    public void process(Context context) throws SAXException {
    }

    public void setDetails(OutputDetails outputDetails) throws SAXException {
        if (this.method != null) {
            outputDetails.setMethod(this.method);
        }
        if (this.version != null) {
            outputDetails.setVersion(this.version);
        }
        if (this.indent != null) {
            outputDetails.setIndent(this.indent);
        }
        if (this.encoding != null) {
            outputDetails.setEncoding(this.encoding);
        }
        if (this.mediaType != null) {
            outputDetails.setMediaType(this.mediaType);
        }
        if (this.doctypeSystem != null) {
            outputDetails.setDoctypeSystem(this.doctypeSystem);
        }
        if (this.doctypePublic != null) {
            outputDetails.setDoctypePublic(this.doctypePublic);
        }
        if (this.omitDeclaration != null) {
            outputDetails.setOmitDeclaration(this.omitDeclaration);
        }
        if (this.standalone != null) {
            outputDetails.setStandalone(this.standalone);
        }
        if (this.cdataElements != null) {
            outputDetails.addCdataElements(this.cdataElements);
        }
        if (this.handler != null) {
            outputDetails.setEmitter(this.handler);
        }
    }

    public static Emitter makeEmitter(String string) throws SAXException {
        Object object = Loader.getInstance(string);
        if (object instanceof Emitter) {
            return (Emitter)object;
        }
        if (object instanceof DocumentHandler) {
            DocumentHandlerProxy documentHandlerProxy = new DocumentHandlerProxy();
            documentHandlerProxy.setUnderlyingDocumentHandler((DocumentHandler)object);
            return documentHandlerProxy;
        }
        if (object instanceof ContentHandler) {
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler((ContentHandler)object);
            return contentHandlerProxy;
        }
        throw new SAXException("Failed to load emitter " + string + ": it is not a SAX DocumentHandler or SAX2 ContentHandler");
    }
}

