/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.axis;

import com.icl.saxon.NameTest;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import org.xml.sax.SAXException;

abstract class AxisEnumeration
implements NodeEnumeration {
    protected NodeInfo start;
    protected NodeInfo next;
    protected int nodeType;
    protected NameTest nodeName;

    public AxisEnumeration(NodeInfo nodeInfo, int n, NameTest nameTest) throws SAXException {
        this.next = nodeInfo;
        this.start = nodeInfo;
        this.nodeType = n;
        this.nodeName = nameTest;
    }

    protected boolean conforms(NodeInfo nodeInfo) throws SAXException {
        if (nodeInfo == null) {
            return true;
        }
        if (this.nodeName == null) {
            return nodeInfo.isa(this.nodeType);
        }
        return nodeInfo.isa(this.nodeType) && this.nodeName.isNameOf(nodeInfo);
    }

    protected final void advance() throws SAXException {
        do {
            this.step();
        } while (!this.conforms(this.next));
    }

    protected abstract void step() throws SAXException;

    public final boolean hasMoreElements() throws SAXException {
        return this.next != null;
    }

    public final NodeInfo nextElement() throws SAXException {
        NodeInfo nodeInfo = this.next;
        this.advance();
        return nodeInfo;
    }

    public boolean isSorted() throws SAXException {
        return false;
    }

    public boolean isReverseSorted() throws SAXException {
        return !this.isSorted();
    }

    public boolean isPeer() throws SAXException {
        return false;
    }
}

