#!/usr/local/bin/perl
# list_keys.cgi
# Display all keys in your keyring

require './gnupg-lib.pl';
&ui_print_header(undef, $text{'keys_title'}, "");

@keys = &list_keys();
print "$text{'keys_desc'}<p>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'keys_id'}</b></td> ",
      "<td><b>$text{'keys_secret'}</b></td> <td><b>$text{'keys_date'}</b></td> ",
      "<td><b>$text{'keys_name'}</b></td> <td><b>$text{'keys_email'}</b></td> ",
      "</tr>\n";
foreach $k (@keys) {
	print "<tr $cb>\n";
	print "<td><a href='edit_key.cgi?idx=$k->{'index'}'>$k->{'key'}</a></td>\n";
	print "<td>",$k->{'secret'} ? "<b>$text{'yes'}</b>"
				    : $text{'no'},"</td>\n";
	print "<td>$k->{'date'}</td>\n";
	print "<td>",join("<br>", map { &html_escape($_) } @{$k->{'name'}}),"&nbsp;</td>\n";
	print "<td>",join("<br>", map { &html_escape($_) } @{$k->{'email'}}),"&nbsp;</td>\n";
	print "</tr>\n";
	}
print "</table><br>\n";

print "<hr>\n";
print "$text{'keys_importdesc'}<p>\n";
print "<form action=import.cgi method=post enctype=multipart/form-data>\n";
print "<table>\n";

print "<tr> <td valign=top><b>$text{'keys_from'}</b></td>\n";
print "<td><input type=radio name=mode value=0 checked> $text{'keys_mode0'}\n";
print "<input type=file name=key><br>\n";

print "<input type=radio name=mode value=1> $text{'keys_mode1'}\n";
print "<input name=file size=35> ",&file_chooser_button("to"),"</td> </tr>\n";

print "</table>\n";
print "<input type=submit value='$text{'keys_import'}'></form>\n";

print "<hr>\n";
print &text('keys_recvdesc', "<tt>$config{'keyserver'}</tt>"),"<p>\n";
print "<form action=recv.cgi>\n";
print "<input type=submit value='$text{'keys_recv'}'>\n";
print "<input name=id size=10></form>\n";

&ui_print_footer("", $text{'index_return'});

