ALTER TABLE groups RENAME TO twig_groups;
ALTER TABLE members RENAME TO twig_members;

DROP TABLE twig_timesheet;

ALTER TABLE twig_mail_prefs ADD sortby varchar(10);
ALTER TABLE twig_mail_prefs ADD sortorder int;
ALTER TABLE twig_mail_prefs ADD dande int;
ALTER TABLE twig_mail_prefs ADD savesent int;
ALTER TABLE twig_mail_prefs ADD sentfold varchar(100);
ALTER TABLE twig_mail_prefs ADD cmdline2 int;
ALTER TABLE twig_mail_prefs ADD newwindow int;

ALTER TABLE twig_contacts ADD email2 varchar(100);
ALTER TABLE twig_contacts ADD email3 varchar(200);
ALTER TABLE twig_contacts ADD title varchar(100);
ALTER TABLE twig_contacts ADD pager varchar(30);
ALTER TABLE twig_contacts ADD ofax varchar(30);
ALTER TABLE twig_contacts ADD department varchar(100);
ALTER TABLE twig_contacts ADD office varchar(100);
ALTER TABLE twig_contacts ADD spouse varchar(100);
ALTER TABLE twig_contacts ADD bday varchar(40);
ALTER TABLE twig_contacts ADD oaddress1 varchar(100);
ALTER TABLE twig_contacts ADD oaddress2 varchar(100);
ALTER TABLE twig_contacts ADD ocity varchar(100);
ALTER TABLE twig_contacts ADD ozip varchar(10);
ALTER TABLE twig_contacts ADD ostate varchar(10);
ALTER TABLE twig_contacts ADD ocountry varchar(100);

CREATE SEQUENCE twaccid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twaccid');

CREATE TABLE twig_accounts (
   id 		int4 DEFAULT nextval ( 'twaccid'),
   username	varchar(20),
   password 	varchar(20),
   SID		int4,
   onnow	INT,
   expire	INT,
   laston	INT,
   PRIMARY KEY  (id)
);

CREATE INDEX twig_accounts_id_index ON twig_accounts (id, username);

CREATE SEQUENCE twasid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twasid');

CREATE TABLE twig_acls (
   SID 		int4 DEFAULT nextval ( 'twasid'),
   identity 	varchar(64) NOT NULL,
   access 	int4 DEFAULT 0
);

CREATE INDEX twig_acls_sid_index ON twig_acls (SID);

CREATE SEQUENCE twagid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twagid');

CREATE TABLE twig_acl_groups (
   SID 		int4 DEFAULT nextval ( 'twagid'),
   groupname 	varchar(64) NOT NULL,
   username 	varchar(20) NOT NULL,
   PRIMARY KEY	(groupname)
);

CREATE INDEX twig_acl_groups_sid_index ON twig_acl_groups (SID, groupname);

CREATE SEQUENCE twbprf start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twbprf');

CREATE TABLE twig_bookmarks_prefs (
   id 		int4 DEFAULT nextval ( 'twbprf' ),
   username 	varchar(20),
   sortby 	varchar(10) NOT NULL,
   sortorder 	int4 DEFAULT '0' NOT NULL,
   dgroup 	int4 DEFAULT '0' NOT NULL,
   PRIMARY KEY  (id)
);

CREATE SEQUENCE twcprf start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twcprf');

CREATE TABLE twig_contacts_prefs (
   id 		int4 DEFAULT nextval ( 'twcprf' ),
   username 	varchar(20),
   sortby 	varchar(10) NOT NULL,
   sortorder 	int4 DEFAULT 0 NOT NULL,
   dgroup 	int4 DEFAULT 0 NOT NULL,
   PRIMARY KEY  (id)
);

CREATE TABLE twig_context (
   id 		varchar(40) NOT NULL,
   username 	varchar(20) NOT NULL,
   context 	text NOT NULL,
   sid 		int4 DEFAULT 0 NOT NULL
);

CREATE INDEX twig_contect_id_index ON twig_context (id);
CREATE INDEX twig_contect_username_index ON twig_context (id);
CREATE INDEX twig_contect_sid_index ON twig_context (id);

CREATE SEQUENCE twgpid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twgpid');

CREATE TABLE twig_global_prefs (
   id 		int4 DEFAULT nextval ( 'twgpid'),
   username 	varchar(20),
   mstyle1 	int4 DEFAULT 0 NOT NULL,
   mstyle2 	int4 DEFAULT 3 NOT NULL,
   language 	varchar(20),
   mailfoot	int4,
   prevnext	varchar(20),
   PRIMARY KEY (id)
);

CREATE SEQUENCE twmpid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twmpid');

CREATE TABLE twig_main_prefs (
   id 		int4 DEFAULT nextval ( 'twaccid'),
   username 	varchar(20),
   schedule 	int4 DEFAULT 1 NOT NULL,
   recentmail 	int4 DEFAULT 1 NOT NULL,
   PRIMARY KEY	(id)
);

CREATE SEQUENCE twsprf start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twsprf');

CREATE TABLE twig_schedule_prefs (
   id 		int4 DEFAULT nextval ( 'twtprf' ),
   username 	varchar(20),
   dgroup 	int4 DEFAULT 0 NOT NULL,
   PRIMARY KEY	(id)
);

CREATE TABLE twig_session (
   id 		varchar(40) NOT NULL,
   username 	varchar(20) NOT NULL,
   session 	text NOT NULL,
   sid 		int4 DEFAULT 0 NOT NULL
);

CREATE INDEX twig_session_id_index ON twig_session (id);
CREATE INDEX twig_session_username_index ON twig_session (username);
CREATE INDEX twig_session_sid_index ON twig_session (sid);

CREATE SEQUENCE twtprf start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twtprf');

CREATE TABLE twig_todo_prefs (
   id 		int4 DEFAULT nextval ( 'twtprf' ),
   username 	varchar(20),
   sortby 	varchar(10) NOT NULL,
   sortorder 	int4 DEFAULT '0' NOT NULL,
   dgroup 	int4 DEFAULT '0' NOT NULL,
   priority	int4 DEFAULT '0' NOT NULL,
   PRIMARY KEY  (id)
);

GRANT ALL ON twig_accounts TO nobody;
GRANT ALL ON twig_acls TO nobody;
GRANT ALL ON twig_acl_groups TO nobody;
GRANT ALL ON twig_contacts_prefs TO nobody;
GRANT ALL ON twig_bookmarks_prefs TO nobody;
GRANT ALL ON twig_todo_prefs TO nobody;
GRANT ALL ON twig_schedule_prefs TO nobody;
GRANT ALL ON twig_session TO nobody;
GRANT ALL ON twig_context TO nobody;
GRANT ALL ON twig_global_prefs TO nobody;
GRANT ALL ON twig_main_prefs TO nobody;
