<?php
 // 
 //  filename:  ibase.db.inc.php3
 //  author:    victor m. varela (IMS) - victor@netims.com
 //  comment:   interbase functions
 // 

ibase_timefmt("%Y-%m-%d", IBASE_DATE);
ibase_timefmt("%Y-%m-%d %H:%M:%S", IBASE_TIMESTAMP);		      
$ibase_db = 0;

class record_set
    {
    var $rs;
    var $con;
    var $fields;
    var $fieldnames;
    var $row;
    var $num_rows;
    var $rowidx;

    // record_set: constructor
    function record_set ($con, $statement = "")
        {
        $this->fields = array();
        $this->con = $con;
        if ($statement)
           {
           if (strtolower(strtok($statement," ")) == 'select')
             {
             $this->open( $statement );
             }
           else
             {
  	     $this->exec( $statement );
             }
           }
        }

    // eof: row is greater than number of rows
    function eof()
        {
        return ($this->rowidx > $this->num_rows);
        }

    // open: get a new cursor from database
    // --
    // to obtain number of record, we use another query
    function open($select)
        {
        $countsql = substr($select, strpos(strtolower($select),'from'));
        $countsql = 'select count(1) ' . $countsql;
        $rs_count = ibase_query($this->con, $countsql);
        if ($rs_count)
           {
           $row = ibase_fetch_row($rs_count);
           $this->num_rows = $row[0];
           $this->rowidx  = -1;
           ibase_free_result($rs_count);
           if ($this->num_rows > 0) 
              {
              if ($this->exec($select))
                 {
                 // get table field names
                 $nf = ibase_num_fields($this->rs);
                 for ($i = 0; $i < $nf; $i++)
                     {
                     $fi = ibase_field_info($this->rs,$i);
                     $this->fieldnames[$i] = $fi["name"];
                     }
                 // go to first record
                 $this->moveto(0);
                 }
              }
           return TRUE;
           }
        else
           {
           $this->num_rows = 0;
           return FALSE;
           }
        }

    // exec: exec a SQL command
    function exec($statement)
        {
        $statement = str_replace("password", "\"PASSWORD\"", $statement);
        $this->rs = ibase_query($this->con, $statement);
        if ($this->rs == 0) { TWIGDebug("SQL: " . $statement); }
        return ($this->rs != 0);
        }

    // makearray: convert a row struct into a indexed array with field names.
    function makearray()
        {
        if ($this->row)
            {
            for ($i = 0; $i < count($this->fieldnames); $i++)
                {
                $this->fields[strtolower($this->fieldnames[$i])] = $this->row[$i];
                $this->fields[strtoupper($this->fieldnames[$i])] = $this->row[$i];
                $this->fields[$i] = $this->row[$i];
                }
            return FALSE;
            }
        return TRUE;
        }

    // moveto: read all from current to param (IB doesn't support random access)
    function moveto($row)
        {
        while ((! $this->eof()) and ($this->rowidx < $row))
            {
            $this->rowidx = $this->rowidx + 1;
            if (! $this->eof()) 
                {
                $this->row = ibase_fetch_row($this->rs);
                }
            }
        if (! $this->eof()) { $this->makearray(); }
        }
    }


// TWIG specific functions

function TWIGProcessSQLString( $string )
	{
	global $config;

	if( !$config["GMQRUN"] ) { $config["GMQRUN"] = get_magic_quotes_runtime() + 1; }

	if( $config["GMQRUN"] == 2 )
		{
		return stripslashes( $string );
		}
	else
		{
		return $string;
		}
	}

function SQLString( $string ) 
	{
  	$string = addslashes( $string );
  
	return $string;
 	}

function createSqlDate( $year, $month, $day ) 
	{
   	return sprintf( "%04d-%02d-%02d", $year, $month, $day);
 	}

function createSqlDateTime( $year, $month, $day, $hour, $min, $sec ) 
	{
   	return sprintf( "%04d-%02d-%02d %02d:%02d:%02d", $year, $month, $day, $hour, $min, $sec );
 	}

function convertUTimetoSQLTime( $utime )
	{
	$fields = explode( " ", date( "Y m d H i s", $utime ) );

   	return createSqlDateTime( $fields[0], $fields[1], $fields[2], $fields[3], $fields[4], $fields[5] );
	}

function convertSQLTimetoUTime( $sqldate ) 
	{
   	return( mktime( substr( $sqldate, 11, 2 ), substr( $sqldate, 14, 2 ), substr( $sqldate, 17, 2 ), 
   	        substr( $sqldate, 5, 2 ), substr( $sqldate, 8, 2 ), substr( $sqldate, 0, 4 ) ) );
 	}

function MakeInsertString( $data ) 
	{
  	while( list( $key, $val ) = each( $data ) ) 
		{
    		if( $val != "--remove" ) 
			{
      			$string["fields"] .= $key . ", ";
      			$string["values"] .= "'" . SQLString( $val ) . "', ";
    			}
  		}

  	$string["fields"] = ereg_replace(", $", "", $string["fields"] );
  	$string["values"] = ereg_replace(", $", "", $string["values"] );

  	return $string;
 	}

function MakeUpdateString( $data ) 
	{
  	while( list( $key, $val ) = each( $data ) ) 
		{
		$strings .= $key . " = '" . SQLString( $val ) . "', ";
  		}

  	$strings = ereg_replace( ", $", " ", $strings );

  	return $strings;
 	}

function dbQuery( $statement ) 
	{
  	global $dbconfig, $ibase_db;

        if (! $ibase_db)
            {
  	    $ibase_db = ibase_pconnect( $dbconfig["sqlserver"] . ":" .
                        $dbconfig["defaultdb"],
                        $dbconfig["sqlusername"],
                        $dbconfig["sqlpassword"] ) or die("error in connection");
            }
        return new record_set($ibase_db, $statement);
 	}

function dbResult( &$result, $i, $field ) 
	{
	if (! $result) { return 0; }
        $result->moveto($i);
  	return $result->fields[$field];
 	}

function dbNumRows( $result ) 
	{
  	return ($result) ? $result->num_rows : -1;
 	}

function dbResultArray( &$result, $i) 
	{
	if (! $result) { return 0; }
        $result->moveto($i);
	return $result->fields;
 	}

 Function dbLastInsertID( $result, $table )
 	{
	// As yet, no support for this in our ibase module
	// Hopefully an InterBase god can help!
	return FALSE;
	}

 Function dbStoreBLOB( $table, $id, $field, $blob )
 	{
	$sql = "UPDATE $table SET $field = '" . addslashes( $blob ) . "' WHERE id = '$id'";
	$res = dbQuery( $sql );
	return $res;
	}

 Function dbRetrieveBLOB( $table, $id, $field, $blob = "" )
 	{
	$sql = "SELECT $field FROM $table WHERE id = '$id'";
	$res = dbQuery( $sql );
	if( dbNumRows( $res ) == 1 )
		{
		$ret = dbResultArray( $res, 0 );
		return $ret[$field];
		}
	elseif( dbNumRows( $res ) < 1 )
		{
   		TWIGPrintError( "dbRetrieveBLOB: no rows found matching id '$id' in table '$table'" );
		}
	elseif( dbNumrows( $res ) > 1 )
		{
   		TWIGPrintError( "dbRetrieveBLOB: id '$id' was not unique in table '$table'" );
		}
	return FALSE;
	}

?>
