<?php	// TWIG	MySQL Functions

 require( "lib/db/sqltxt/dbase.inc.php3" );
 require( "lib/db/sqltxt/sqlcommands.inc.php3" );

 Function TWIGProcessSQLString( $string )
	{
	global $config;

	if( !$config["GMQRUN"] ) { $config["GMQRUN"] = get_magic_quotes_runtime() + 1; }

	if( $config["GMQRUN"] == 2 )
		{
		return stripslashes( $string );
		}
	else
		{
		return $string;
		}
	}

 Function SQLString( $string ) 
	{
  	$string = addslashes( $string );

 	return $string;
 	}

 Function createSqlDate( $year, $month, $day ) 
	{
   	return sprintf( "%04d%02d%02d", $year, $month, $day );
 	}

 Function createSqlDateTime( $year, $month, $day, $hour, $min, $sec ) 
	{
   	return sprintf( "%04d%02d%02d%02d%02d%02d", $year, $month, $day, $hour, $min, $sec );
 	}

 Function convertUTimetoSQLTime( $utime )
	{
	$fields = explode( " ", date( "Y m d H i s", $utime ) );

   	return createSqlDateTime( $fields[0], $fields[1], $fields[2], $fields[3], $fields[4], $fields[5] );
	}

 Function convertSQLTimetoUTime( $sqldate ) 
	{
   	return( mktime( substr( $sqldate, 8, 2 ), substr( $sqldate, 10, 2 ), substr( $sqldate, 12, 2 ), substr( $sqldate, 4, 2 ), substr( $sqldate, 6, 2 ), substr( $sqldate, 0, 4 ) ) );
 	}

 Function MakeInsertString( $data )
	{
  	while( list( $key, $val ) = each( $data ) ) 
		{
    		if( $val != "--remove" ) 
			{
      			$fields[] = $key;
      			$values[] = "'" . SQLString( $val ) . "'";
    			}
  		}

  	$string["fields"] .= implode( ", ", $fields );
  	$string["values"] .= implode( ", ", $values );

  	return $string;
 	} 

 Function MakeUpdateString( $data )
	{
	while( list( $key, $val ) = each( $data ) ) 
		{
    		$temp[] = $key . " = '". SQLString( $val ) . "'";
   		}

  	$strings .= implode( ", ", $temp );

  	return $strings;
 	} 

 Function dbQuery( $statement ) 
	{
  	global $dbconfig;

  	$result = SQLTXTQuery( $dbconfig["defaultdb"], $statement );

  	return $result;
 	}

 Function dbResult( $result, $i, $field ) 
	{
  	return SQLTXTResult( $result, $i, $field );
 	}

 Function dbNumRows( $result ) 
	{
  	return SQLTXTNumRows( $result );
 	}

 Function dbResultArray( $result, $i ) 
	{
  	return SQLTXTFetchArray( $result, $i );
 	}

 Function dbLastInsertID( $result, $table )
 	{
	Global $sqltxt_insertid;
	return $sqltxt_insertid;
	}

 Function dbStoreBLOB( $table, $id, $field, $blob )
 	{
	$sql = "UPDATE $table SET $field = '" . addslashes( $blob ) . "' WHERE id = '$id'";
	$res = dbQuery( $sql );
	return $res;
	}

 Function dbRetrieveBLOB( $table, $id, $field, $blob = "" )
 	{
	$sql = "SELECT $field FROM $table WHERE id = '$id'";
	$res = dbQuery( $sql );
	if( dbNumRows( $res ) == 1 )
		{
		$ret = dbResultArray( $res, 0 );
		return $ret[$field];
		}
	elseif( dbNumRows( $res ) < 1 )
		{
   		TWIGPrintError( "dbRetrieveBLOB: no rows found matching id '$id' in table '$table'" );
		}
	elseif( dbNumrows( $res ) > 1 )
		{
   		TWIGPrintError( "dbRetrieveBLOB: id '$id' was not unique in table '$table'" );
		}
	return FALSE;
	}

?>
