/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* transcalc.h
 */

#ifndef __TRANSCALC_H
#define __TRANSCALC_H

#include <config.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <pwd.h>
#include <math.h>
#include <gtk/gtk.h>
#include "units.h"


#if !HAVE_STRCPY
#  if HAVE_BCOPY
#    define strcpy(dest, src)   bcopy (src, dest, 1 + strlen (src))
#  else /* !HAVE_BCOPY */
error no strcpy or bcopy
#  endif /* HAVE_BCOPY */
#endif /* HAVE_STRCPY */


GtkWidget *main_body_window;
GtkWidget *transtype_combo;
/*GtkWidget *status;*/

#define MICROSTRIP 0
#define RECTWAVEGUIDE 1
#define COAX 2
#define C_MICROSTRIP 3


#define NUMSUBPARS 9
#define NUMCOMPPARS 3
#define NUMPHYSPARS 4
#define NUMELECPARS 4

#define SUBPARAMTYPE 0
#define COMPPARAMTYPE 1
#define PHYSPARAMTYPE 2
#define ELECPARAMTYPE 3

#ifndef M_PI
#define M_PI           3.14159265358979323846  /* pi */
#endif

#define MU0 (4*M_PI*1e-7)       /* permeability */
#define ER0 (8.854e-12)         /* permittivity */
#define C (2.997956377e8)                /* speed of light m/s*/

#define CONSISTENT 0             /* status of fields in calculation */
#define INCONSISTENT 1

/*config directory*/

#define TRC_CONFIG_DIRECTORY ".transcalc"
#define TRC_CONFIG_DIRECTORY_MODE S_IRWXU
#define TRC_CONFIG_FILE TRC_CONFIG_DIRECTORY "/transcalc.cfg"
#define TRC_SAVE_FILE TRC_CONFIG_DIRECTORY "/transcalc.trc"

#define SAVE_OPER 0
#define SAVE_END 1
#define LOAD_OPER 0
#define LOAD_INIT 1

typedef struct _trans_win {
  GtkWidget *subparam_frame;
  GtkWidget *subparam_table;
  GtkWidget *subparam_text[NUMSUBPARS];
  GtkWidget *subparam_combo[NUMSUBPARS];
  GtkWidget *component_param_frame;
  GtkWidget *component_param_table;
  GtkWidget *component_param_text[NUMCOMPPARS];
  GtkWidget *component_param_combo[NUMCOMPPARS];
  GtkWidget *physical_param_frame;
  GtkWidget *physical_param_table;
  GtkWidget *physical_param_text[NUMPHYSPARS];
  GtkWidget *physical_param_combo[NUMPHYSPARS];  
  GtkWidget *physical_param_fix[2];
  GtkWidget *Synbutton;
  GtkWidget *Analbutton;
  GtkWidget *electrical_param_frame;
  GtkWidget *electrical_param_table;
  GtkWidget *electrical_param_text[NUMELECPARS];
  GtkWidget *electrical_param_combo[NUMELECPARS];
  GtkWidget *drawing_frame;
  GtkWidget *results_frame;
  GtkWidget *results_text;
  GtkWidget *status_frame;
  GtkWidget *status;
} trans_win;

typedef struct _trans_gui {
  GtkWidget *mainwindow;
  GtkWidget *menu;
  GtkWidget *vertbox;
  GtkWidget *body;
} trans_gui;

typedef struct _tgui_trans {
  trans_gui *topgui;
  trans_win *twin;
} tgui_trans;

typedef struct _trans_label {
  char *substrate_label_name[NUMSUBPARS];
  char *component_label_name[NUMCOMPPARS];
  char *physical_label_name[NUMPHYSPARS];
  char *electrical_label_name[NUMELECPARS];
  char *stooltips_helptext[NUMSUBPARS];
  char *ctooltips_helptext[NUMCOMPPARS];
  char *ptooltips_helptext[NUMPHYSPARS];
  char *etooltips_helptext[NUMELECPARS];
} trans_label;

typedef struct _trans_value {
  gfloat subparams_value[NUMSUBPARS];
  gfloat component_params_value[NUMCOMPPARS];
  gfloat physical_params_value[NUMPHYSPARS];
  gfloat electrical_params_value[NUMELECPARS];
} trans_value;

short current_transtype;
trans_win *twin;
short statusint;
trans_gui *tgui;
gboolean statusexists;
int main_window_width, main_window_height;

extern gint delete_event (GtkWidget *, GdkEvent *, gpointer);
extern void destroy (GtkWidget *, gpointer);
/*extern GtkWidget *setup_body (GtkWidget *);*/
extern GtkWidget *setup_body (trans_gui *);
/*extern void analyze_microstrip (GtkWidget *, tgui_trans *);*/
extern void analyze_microstrip (GtkWidget *, trans_win *);
/*extern void analyze_microstrip (GtkWidget *);*/


#define MAX_ERROR 0.000001
#endif

