namespace eval preferences {
    variable prefs

    # Define the options database.
    option add *Preferences.borderwidth 1
    option add *Preferences.relief flat

    # Define the preferences data structure
    array set prefs {
	dialog ""
    }

    switch $tkWorld(ostype) {
	windows {
	    set prefs(font.title) {helvetica 12 bold}
	    set prefs(font.message) {helvetica 10}
	    set prefs(font.info) {helvetica 10 italic}
	    set prefs(font.contact) {helvetica 10}
	}
	default {
	    set prefs(font.title) {helvetica 14 bold}
	    set prefs(font.message) {helvetica 12}
	    set prefs(font.info) {helvetica 12 italic}
	    set prefs(font.contact) {helvetica 12}
	}
    }
}

# preferences::create --
#
#   Method to create an Preferences information dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::create { } {
    global tkWorld
    variable prefs

    # Put the focus on the preferences dialog if it is already open.
    if [winfo exists $prefs(dialog)] {
	switch -- [wm state $prefs(dialog)] {
	    normal {
		raise $prefs(dialog)
	    }
	    withdrawn -
	    iconic {
		wm deiconify $prefs(dialog)
	    }
	}
	focus $prefs(dialog)
	return
    } else {
	set prefs(dialog) [dialog::create .preferences Preferences]
    }

    # The first tab has the display options like Balloon Help and
    # start finish images in the LW.
    set tab1 [tabnotebook::page \
	    [dialog::interior $prefs(dialog)] "Display"]

    # Use a frame to encapsulate the File and Regexp options so that
    # the frame can be centered accross the grid columns.
    set f1 [frame $tab1.f1 \
	    -class TabnotebookFrame]

    # Create the top frame which allows the user to set the
    # balloon help and the Start/Finish Display
    checkbutton $f1.balloon \
	    -text "Show Balloon Help" \
	    -variable balloonhelp::balloonhelp(active) \
	    -onvalue 1 \
	    -offvalue 0
    checkbutton $f1.start_finish \
	    -text "Show Start/Finish headers in the Log Window" \
	    -variable tkWorld(start_finish_display) \
	    -onvalue 1 \
	    -offvalue 0
    grid $f1.balloon \
	    -padx 5 \
	    -pady 5 \
	    -sticky w
    grid $f1.start_finish \
	    -padx 5 \
	    -pady 5 \
	    -sticky w

    # Build the first tab.
    grid $f1 \
	    -padx 5 \
	    -pady 5 \
	    -sticky news

    # Define the lists for the reset and clear methods
    set prefs(list.reset) ""
    set prefs(list.clear) ""
    
}

# preferences::ok  --
#
#   Method which invokes preferences::close to close the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::ok { } {
    preferences::close
}

# preferences::reset --
#
#   Method to reset the radio and checkbuttons in the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::reset { } {
    global tkWorld
    variable prefs

    set tkWorld(start_finish_display) 1
    set balloonhelp::balloonhelp(active) 1
}

# preferences::clear --
#
#   Method to clear entry items of their text and reset the
#   background and foreground properties.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::clear { } {
    # No private variables.
}

# preferences::help --
#
#   Method to invoke the Preferences Command Help.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::help { } {
    global tkWorld

    help::create "help/preferences.html" "Preferences Help"
}

# preferencs::close --
#
#   Method to close the preferences dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc preferences::close { } {
    variable prefs

    balloonhelp::cancel
    destroy $prefs(dialog)
}