/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "Contest.H"
#include "main.h"
#include "lektionsauswertung.h"
#include "ContestWizard.H"
#include "ContestRankingDlg.H"

BEGIN_EVENT_TABLE(Contest,LessonController)
  LESSON_START(wxID_ANY, Contest::onLessonStart)
  LESSON_ABORT(wxID_ANY, Contest::onLessonAbort)
  LESSON_FINISH(wxID_ANY, Contest::onLessonFinish)
END_EVENT_TABLE()

Contest::Contest (wxWindow* parent, ContestDesc& cdata)
  : parent(parent),
    data(cdata)
{
  controllerName=_("contest");
  lesson=0;
  if (!Hauptfenster::getPtr()->setLessonController(this)) {
    throw Abbruch();
  }
  UrlFile* p = 0;
  if (data.pictureFile.getURLstr().Len()) {
    p = &data.pictureFile;
  }
  UrlFile* d = 0;
  if (data.descrFile.getURLstr().Len()) {
    d = &data.descrFile;
  }
  ContestWizard* wizard = new ContestWizard(parent,data.title,
					    p,d);
  if (wizard->runWizard()) {
    this->username=wizard->getName();
    wizard->Destroy();
  } else {
    wizard->Destroy();
    Hauptfenster::getPtr()->setLessonController(0,false);
    throw Abbruch();
  }
  lesson = 0;
  lesson = new Lektion(data.lessonFile, this);
}

Contest::~Contest () {
  if (runningLesson()) {
    lesson->LektionAbbrechen();
    delete lesson;
  }
}

void Contest::onLessonStart (wxCommandEvent& WXUNUSED(e)) {
  /* you can put things here that get run before the lesson starts */
}
void Contest::onLessonAbort (wxCommandEvent& WXUNUSED(e)) {
  /* you can put things here that get run when the lesson was aborted */
  if (this->username != _T("")) {
    wxMessageDialog dlg(this->parent,
			_("Your data was not stored in the contest list\nbecause you aborted the contest."),
			_("Aborted lesson notification"),
			wxICON_INFORMATION|wxOK);
    dlg.ShowModal();
  }
  delete lesson;
  lesson = 0;
}

#include <wx/file.h>
#include <wx/wfstream.h>
#include <wx/txtstrm.h>

void Contest::onLessonFinish (wxCommandEvent& WXUNUSED(e)) {
  /* you can put things here that get run when the lesson was finished */
  //save the results
  if (this->username != _T("")) {
    wxFile file;
    if ((file.Exists(this->data.dataFile.GetFullPath()) == false &&
	 file.Create(this->data.dataFile.GetFullPath(),
		     false,wxS_IRUSR|wxS_IWUSR|wxS_IRGRP|wxS_IROTH) == false) ||
	file.Open(this->data.dataFile.GetFullPath(),wxFile::write_append) == false){
      ::wxLogFatalError(_("Cannot open or create contest data file."));
    }
    wxFileOutputStream filestream(file);
    if (filestream.Ok()) {
      wxTextOutputStream fts(filestream);
      LEntry e = lesson->GetLessonData();
      fts << _T("\"")
	  << wxString(wxConvCurrent->cMB2WC((char*)this->username.c_str()), wxConvUTF8)
	  << _T("\",")
	  << e.getRichtig() << _T(",")
	  << e.getFehler() << _T(",")
	  << e.getZeitString()
	  << endl;
    }
    file.Close();
  }
  lauswertung laus(Hauptfenster::getPtr(), _("Your contest statistics"), lesson);
  laus.ShowModal();
  ContestRankingDlg ranking(Hauptfenster::getPtr(),this->data.title,
			    this->data.dataFile,this->data.weight);
  ranking.ShowModal();
  delete lesson;
  lesson = 0;
  Hauptfenster::getPtr()->setLessonController(0);
}
