/* swapinfo.c, copyright Neven Lovric <nlovric@linux.hr> */

#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/param.h>
#include <fcntl.h>
#include <string.h>
#include "swapinfo.h"

unsigned long swapsize(char *path)
{
   int fd;
   char buf[1024];
   int pos = 0;
   int ret;
   char *ptr;
   unsigned row = 0;
   char rpath[MAXPATHLEN];
   unsigned long size;
   char *endptr;
   
   errno = 0;
   if (!realpath(path, rpath)) {
      errno = 1;
      return(0);
   }
   if ((fd = open("/proc/swaps", O_RDONLY)) == -1) {
      errno = 2;
      return(0);
   }
   while (1) {
      if ((ret = read(fd, buf + pos, 1)) == -1) {
         close(fd);
         errno = 2;
         return(0);
      }
      if (!ret) {
         close(fd);
         return(0);
      }
      if (buf[pos] == '\n' || pos == 1023) {
         if (row) {
            buf[pos] = 0;
            ptr = strchr(buf, ' ');
            if (ptr) {
               *ptr = 0;
               if (!strcmp(buf, rpath)) {
                  ptr++;
                  while (1) {
                     while (*ptr == '\t')
                        ptr++;
                     size = strtoul(ptr, &endptr, 10);
                     if (*endptr == '\t')
                        return(size << 10);
                     while (*ptr != '\t') {
                        if (!*ptr) {
                           errno = 3;
                           return(0);
                        }
                        ptr++;
                     }
                  }
               }
            }
         }
         row ++;
         pos = 0;
      } else
         pos++;
   }
}
