///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// $Id: ProximityPhraseBuilder.h,v 1.2 2003/10/24 15:59:34 bburton Exp $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//

#ifndef _ProximityPhraseBuilder_h
#define _ProximityPhraseBuilder_h

#include <strstream>
#include "AbstractPhraseBuilder.h"

class ProximityPhraseBuilder : public AbstractPhraseBuilder
{
public:
  ProximityPhraseBuilder(int max_words,
                         char separator = 'X')
    : m_maxWords(max_words),
      m_separator(separator)
  {
  }

  void setMinWords(int value)
  {
  }

  void setMaxChars(int value)
  {
  }

  void setMaxWords(int value)
  {
    m_maxWords = value;
    trimToSize(m_maxWords);
  }

  int getMinWords()
  {
    return 2;
  }

  int getMaxWords()
  {
    return m_maxWords;
  }

  int getWordCount() const
  {
    return m_words.size();
  }

  void addWord(const string &word)
  {
    trimToSize(m_maxWords - 1);
    m_words.push_back(word);
  }

  const char *getPhrase(int num_words)
  {
    assert(num_words > 0);
    assert(num_words <= m_maxWords);
    assert(num_words <= m_words.size());

    ostrstream s(m_buffer, sizeof(m_buffer));
    if (num_words == 1) {
      s << getWord(1) << ends;
    } else {
      s << getWord(num_words) << m_separator << getWord(1) << m_separator << (num_words - 1) << ends;
    }
    return m_buffer;
  }

  void clear()
  {
    m_words.clear();
  }

private:
  const string &getWord(int index)
  {
    assert(index >= 1);
    assert(index <= m_words.size());

    return m_words[m_words.size() - index];
  }

  void trimToSize(int max_size)
  {
    if (m_words.size() > max_size) {
      vector<string>::iterator start = m_words.begin();
      m_words.erase(start, start + (m_words.size() - max_size));
    }
  }

private:
  /// Not implemented.
  ProximityPhraseBuilder(const ProximityPhraseBuilder &);

  /// Not implemented.
  ProximityPhraseBuilder& operator=(const ProximityPhraseBuilder &);

private:
  vector<string> m_words;
  char m_buffer[1024];
  int m_maxWords;
  char m_separator;
};

#endif // _ProximityPhraseBuilder_h
