///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// $Id: MimeHeader.h,v 1.7 2003/08/30 21:42:24 bburton Exp $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//

#ifndef _MimeHeader_h
#define _MimeHeader_h

#include <vector>
#include "MimeLineReader.h"

class MimeHeader
{
public:
  MimeHeader();
  ~MimeHeader();

  bool read(MimeLineReader &in,
            bool skip_current,
            bool allow_from);

  bool isMime();
  const string &getContentType()
  {
    return m_contentType;
  }

  const string &getBoundary()
  {
    return m_boundary;
  }

  const string &getTerminator()
  {
    return m_terminator;
  }

  const string &getEncoding()
  {
    return m_encoding;
  }

  const string &getCharSet()
  {
    return m_charset;
  }

  bool isText()
  {
    return m_isText;
  }

  bool isMultiPart()
  {
    return m_isMultiPart;
  }

  bool isMessage()
  {
    return m_isMessage;
  }

  bool isQuoted()
  {
    return m_isQuoted;
  }

  bool isBase64()
  {
    return m_isBase64;
  }

  int getFieldCount() const
  {
    return m_lines.size();
  }

  bool getField(int index,
                string &value) const;

  bool getFieldName(int index,
                    string &name) const;

  bool getField(const string &name,
                string &value) const;

  bool getField(const string &name,
                vector<string> &values) const;

  static bool isFromLine(bool prev_blank,
                         const string &line);

private:
  void addField(const string &line);
  string findParam(const string &line,
                   const string &lower_line,
                   const string &param_name,
                   const string &default_value);

private:
  vector<string> m_lines;
  vector<string> m_names;
  bool m_isMime;
  bool m_isText;
  bool m_isQuoted;
  bool m_isBase64;
  bool m_isMultiPart;
  bool m_isMessage;
  string m_contentType;
  string m_boundary;
  string m_terminator;
  string m_encoding;
  string m_charset;
};

#endif // _MimeHeader_h
